/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCodeGrant
implements AccessTokenGrant {
    private String code;
    private String redirectUri;

    public AuthorizationCodeGrant(String code) {
        this.code = code;
    }

    public AuthorizationCodeGrant(String code, URI uri) {
        this.code = code;
        this.redirectUri = uri.toString();
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getType() {
        return "authorization_code";
    }

    @Override
    public MultivaluedMap<String, String> toMap() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putSingle("grant_type", "authorization_code");
        map.putSingle("code", this.code);
        if (this.redirectUri != null) {
            map.putSingle("redirect_uri", this.redirectUri);
        }
        return map;
    }
}

