/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.InetAddressUtils;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlAssertionValidator
extends SignatureTrustValidator {
    private static final Log LOG = LogFactory.getLog(SamlAssertionValidator.class);
    private int futureTTL = 60;
    private int ttl = 1800;
    private boolean validateSignatureAgainstProfile = true;
    private String requiredSubjectConfirmationMethod;
    private boolean requireStandardSubjectConfirmationMethod = true;
    private boolean requireBearerSignature = true;

    public void setFutureTTL(int newFutureTTL) {
        this.futureTTL = newFutureTTL;
    }

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getAssertion() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        AssertionWrapper assertion = credential.getAssertion();
        this.verifySubjectConfirmationMethod(assertion);
        this.checkConditions(assertion);
        this.checkAudienceRestrictions(assertion, data.getAudienceRestrictions());
        this.checkAuthnStatements(assertion);
        this.checkOneTimeUse(assertion, data);
        this.validateAssertion(assertion);
        if (assertion.isSigned()) {
            this.verifySignedAssertion(assertion, data);
        }
        return credential;
    }

    protected void verifySubjectConfirmationMethod(AssertionWrapper samlAssertion) throws WSSecurityException {
        List<String> methods = samlAssertion.getConfirmationMethods();
        if (methods == null || methods.isEmpty()) {
            if (this.requiredSubjectConfirmationMethod != null) {
                LOG.debug((Object)"A required subject confirmation method was not present");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            if (this.requireStandardSubjectConfirmationMethod) {
                LOG.debug((Object)"A standard subject confirmation method was not present");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        boolean signed = samlAssertion.isSigned();
        boolean requiredMethodFound = false;
        boolean standardMethodFound = false;
        for (String method : methods) {
            if (OpenSAMLUtil.isMethodHolderOfKey(method)) {
                if (samlAssertion.getSubjectKeyInfo() == null) {
                    LOG.debug((Object)"There is no Subject KeyInfo to match the holder-of-key subject conf method");
                    throw new WSSecurityException(0, "noKeyInSAMLToken");
                }
                if (!signed) {
                    LOG.debug((Object)"A holder-of-key assertion must be signed");
                    throw new WSSecurityException(0, "invalidSAMLsecurity");
                }
                standardMethodFound = true;
            }
            if (method == null) continue;
            if (method.equals(this.requiredSubjectConfirmationMethod)) {
                requiredMethodFound = true;
            }
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(method) || "urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(method)) {
                standardMethodFound = true;
                if (!this.requireBearerSignature || signed) continue;
                LOG.debug((Object)"A Bearer Assertion was not signed");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            if (!"urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(method) && !"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(method)) continue;
            standardMethodFound = true;
        }
        if (!requiredMethodFound && this.requiredSubjectConfirmationMethod != null) {
            LOG.debug((Object)"A required subject confirmation method was not present");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (!standardMethodFound && this.requireStandardSubjectConfirmationMethod) {
            LOG.debug((Object)"A standard subject confirmation method was not present");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    protected Credential verifySignedAssertion(AssertionWrapper assertion, RequestData data) throws WSSecurityException {
        Credential trustCredential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        return super.validate(trustCredential, data);
    }

    protected void checkConditions(AssertionWrapper assertion) throws WSSecurityException {
        DateTime currentTime;
        DateTime validFrom = null;
        DateTime validTill = null;
        DateTime issueInstant = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml2().getIssueInstant();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
            issueInstant = assertion.getSaml1().getIssueInstant();
        }
        if (validFrom != null) {
            currentTime = new DateTime();
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(this.futureTTL)))) {
                LOG.debug((Object)"SAML Token condition (Not Before) not met");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.debug((Object)"SAML Token condition (Not On Or After) not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (issueInstant != null) {
            currentTime = new DateTime();
            if (issueInstant.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(this.futureTTL)))) {
                LOG.debug((Object)"SAML Token IssueInstant not met");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            if (validTill == null) {
                currentTime = new DateTime();
                currentTime.minusSeconds(this.ttl);
                if (issueInstant.isBefore((ReadableInstant)currentTime)) {
                    LOG.debug((Object)"SAML Token IssueInstant not met. The assertion was created too long ago.");
                    throw new WSSecurityException(0, "invalidSAMLsecurity");
                }
            }
        }
    }

    public void checkAudienceRestrictions(AssertionWrapper assertion, List<String> audienceRestrictions) throws WSSecurityException {
        Conditions conditions;
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            return;
        }
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            org.opensaml.saml2.core.Conditions conditions2 = assertion.getSaml2().getConditions();
            if (conditions2 != null && conditions2.getAudienceRestrictions() != null && !conditions2.getAudienceRestrictions().isEmpty()) {
                boolean foundAddress = false;
                block0: for (AudienceRestriction audienceRestriction : conditions2.getAudienceRestrictions()) {
                    if (audienceRestriction.getAudiences() == null) continue;
                    List audiences = audienceRestriction.getAudiences();
                    for (Audience audience : audiences) {
                        String audienceURI = audience.getAudienceURI();
                        if (!audienceRestrictions.contains(audienceURI)) continue;
                        foundAddress = true;
                        continue block0;
                    }
                }
                if (!foundAddress) {
                    throw new WSSecurityException(0, "invalidSAMLsecurity");
                }
            }
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null && (conditions = assertion.getSaml1().getConditions()) != null && conditions.getAudienceRestrictionConditions() != null && !conditions.getAudienceRestrictionConditions().isEmpty()) {
            boolean foundAddress = false;
            block2: for (AudienceRestrictionCondition audienceRestriction : conditions.getAudienceRestrictionConditions()) {
                if (audienceRestriction.getAudiences() == null) continue;
                List audiences = audienceRestriction.getAudiences();
                for (org.opensaml.saml1.core.Audience audience : audiences) {
                    String audienceURI = audience.getUri();
                    if (!audienceRestrictions.contains(audienceURI)) continue;
                    foundAddress = true;
                    continue block2;
                }
            }
            if (!foundAddress) {
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
    }

    protected void checkAuthnStatements(AssertionWrapper assertion) throws WSSecurityException {
        block5: {
            block4: {
                if (!assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) || assertion.getSaml2().getAuthnStatements() == null) break block4;
                List authnStatements = assertion.getSaml2().getAuthnStatements();
                for (AuthnStatement authnStatement : authnStatements) {
                    DateTime authnInstant = authnStatement.getAuthnInstant();
                    DateTime sessionNotOnOrAfter = authnStatement.getSessionNotOnOrAfter();
                    String subjectLocalityAddress = null;
                    if (authnStatement.getSubjectLocality() != null && authnStatement.getSubjectLocality().getAddress() != null) {
                        subjectLocalityAddress = authnStatement.getSubjectLocality().getAddress();
                    }
                    this.validateAuthnStatement(authnInstant, sessionNotOnOrAfter, subjectLocalityAddress, this.futureTTL);
                }
                break block5;
            }
            if (!assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) || assertion.getSaml1().getAuthenticationStatements() == null) break block5;
            List authnStatements = assertion.getSaml1().getAuthenticationStatements();
            for (AuthenticationStatement authnStatement : authnStatements) {
                DateTime authnInstant = authnStatement.getAuthenticationInstant();
                String subjectLocalityAddress = null;
                if (authnStatement.getSubjectLocality() != null && authnStatement.getSubjectLocality().getIPAddress() != null) {
                    subjectLocalityAddress = authnStatement.getSubjectLocality().getIPAddress();
                }
                this.validateAuthnStatement(authnInstant, null, subjectLocalityAddress, this.futureTTL);
            }
        }
    }

    private void validateAuthnStatement(DateTime authnInstant, DateTime sessionNotOnOrAfter, String subjectLocalityAddress, int futureTTL) throws WSSecurityException {
        DateTime currentTime = new DateTime();
        if (authnInstant.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(futureTTL)))) {
            LOG.debug((Object)"SAML Token AuthnInstant not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (sessionNotOnOrAfter != null && sessionNotOnOrAfter.isBeforeNow()) {
            LOG.debug((Object)"SAML Token SessionNotOnOrAfter not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (subjectLocalityAddress != null && !InetAddressUtils.isIPv4Address(subjectLocalityAddress) && !InetAddressUtils.isIPv6Address(subjectLocalityAddress)) {
            LOG.debug((Object)("SAML Token SubjectLocality address is not valid: " + subjectLocalityAddress));
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    protected void checkOneTimeUse(AssertionWrapper samlAssertion, RequestData data) throws WSSecurityException {
        if (samlAssertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && samlAssertion.getSaml2().getConditions() != null && samlAssertion.getSaml2().getConditions().getOneTimeUse() != null && data.getSamlOneTimeUseReplayCache() != null) {
            String identifier = samlAssertion.getId();
            ReplayCache replayCache = data.getSamlOneTimeUseReplayCache();
            if (replayCache.contains(identifier)) {
                throw new WSSecurityException(3, "badSamlToken", new Object[]{"A replay attack has been detected"});
            }
            DateTime expires = samlAssertion.getSaml2().getConditions().getNotOnOrAfter();
            if (expires != null) {
                Date rightNow = new Date();
                long currentTime = rightNow.getTime();
                long expiresTime = expires.getMillis();
                replayCache.add(identifier, 1L + (expiresTime - currentTime) / 1000L);
            } else {
                replayCache.add(identifier);
            }
            replayCache.add(identifier);
        }
    }

    protected void validateAssertion(AssertionWrapper assertion) throws WSSecurityException {
        if (this.validateSignatureAgainstProfile) {
            assertion.validateSignatureAgainstProfile();
        }
        if (assertion.getSaml1() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml1-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml1());
                specValidators.validate((XMLObject)assertion.getSaml1());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
        }
        if (assertion.getSaml2() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml2-core-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml2());
                specValidators.validate((XMLObject)assertion.getSaml2());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
        }
    }

    public boolean isValidateSignatureAgainstProfile() {
        return this.validateSignatureAgainstProfile;
    }

    public void setValidateSignatureAgainstProfile(boolean validateSignatureAgainstProfile) {
        this.validateSignatureAgainstProfile = validateSignatureAgainstProfile;
    }

    public String getRequiredSubjectConfirmationMethod() {
        return this.requiredSubjectConfirmationMethod;
    }

    public void setRequiredSubjectConfirmationMethod(String requiredSubjectConfirmationMethod) {
        this.requiredSubjectConfirmationMethod = requiredSubjectConfirmationMethod;
    }

    public boolean isRequireStandardSubjectConfirmationMethod() {
        return this.requireStandardSubjectConfirmationMethod;
    }

    public void setRequireStandardSubjectConfirmationMethod(boolean requireStandardSubjectConfirmationMethod) {
        this.requireStandardSubjectConfirmationMethod = requireStandardSubjectConfirmationMethod;
    }

    public boolean isRequireBearerSignature() {
        return this.requireBearerSignature;
    }

    public void setRequireBearerSignature(boolean requireBearerSignature) {
        this.requireBearerSignature = requireBearerSignature;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }
}

