/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.conversation.dkalgo;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.DerivationAlgorithm;

public class P_SHA1
implements DerivationAlgorithm {
    public byte[] createKey(byte[] secret, byte[] seed, int offset, long length) throws ConversationException {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            byte[] tempBytes = P_SHA1.P_hash(secret, seed, mac, offset + (int)length);
            byte[] key = new byte[(int)length];
            for (int i = 0; i < key.length; ++i) {
                key[i] = tempBytes[i + offset];
            }
            return key;
        }
        catch (Exception ex) {
            throw new ConversationException("errorInKeyDerivation", null, ex);
        }
    }

    private static byte[] P_hash(byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] a = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
            mac.init(key);
            mac.update(a);
            a = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(a);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = P_SHA1.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }
}

