/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.AdminTier;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class MemberAddArg {
    protected final String memberEmail;
    protected final String memberGivenName;
    protected final String memberSurname;
    protected final String memberExternalId;
    protected final String memberPersistentId;
    protected final boolean sendWelcomeEmail;
    protected final AdminTier role;

    public MemberAddArg(String memberEmail, String memberGivenName, String memberSurname, String memberExternalId, String memberPersistentId, boolean sendWelcomeEmail, AdminTier role) {
        if (memberEmail == null) {
            throw new IllegalArgumentException("Required value for 'memberEmail' is null");
        }
        if (memberEmail.length() > 255) {
            throw new IllegalArgumentException("String 'memberEmail' is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", memberEmail)) {
            throw new IllegalArgumentException("String 'memberEmail' does not match pattern");
        }
        this.memberEmail = memberEmail;
        if (memberGivenName == null) {
            throw new IllegalArgumentException("Required value for 'memberGivenName' is null");
        }
        if (memberGivenName.length() < 1) {
            throw new IllegalArgumentException("String 'memberGivenName' is shorter than 1");
        }
        if (memberGivenName.length() > 100) {
            throw new IllegalArgumentException("String 'memberGivenName' is longer than 100");
        }
        if (!Pattern.matches("[^/:?*<>\"|]*", memberGivenName)) {
            throw new IllegalArgumentException("String 'memberGivenName' does not match pattern");
        }
        this.memberGivenName = memberGivenName;
        if (memberSurname == null) {
            throw new IllegalArgumentException("Required value for 'memberSurname' is null");
        }
        if (memberSurname.length() < 1) {
            throw new IllegalArgumentException("String 'memberSurname' is shorter than 1");
        }
        if (memberSurname.length() > 100) {
            throw new IllegalArgumentException("String 'memberSurname' is longer than 100");
        }
        if (!Pattern.matches("[^/:?*<>\"|]*", memberSurname)) {
            throw new IllegalArgumentException("String 'memberSurname' does not match pattern");
        }
        this.memberSurname = memberSurname;
        if (memberExternalId != null && memberExternalId.length() > 64) {
            throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
        }
        this.memberExternalId = memberExternalId;
        this.memberPersistentId = memberPersistentId;
        this.sendWelcomeEmail = sendWelcomeEmail;
        if (role == null) {
            throw new IllegalArgumentException("Required value for 'role' is null");
        }
        this.role = role;
    }

    public MemberAddArg(String memberEmail, String memberGivenName, String memberSurname) {
        this(memberEmail, memberGivenName, memberSurname, null, null, true, AdminTier.MEMBER_ONLY);
    }

    public String getMemberEmail() {
        return this.memberEmail;
    }

    public String getMemberGivenName() {
        return this.memberGivenName;
    }

    public String getMemberSurname() {
        return this.memberSurname;
    }

    public String getMemberExternalId() {
        return this.memberExternalId;
    }

    public String getMemberPersistentId() {
        return this.memberPersistentId;
    }

    public boolean getSendWelcomeEmail() {
        return this.sendWelcomeEmail;
    }

    public AdminTier getRole() {
        return this.role;
    }

    public static Builder newBuilder(String memberEmail, String memberGivenName, String memberSurname) {
        return new Builder(memberEmail, memberGivenName, memberSurname);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.memberPersistentId, this.sendWelcomeEmail, this.role});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberAddArg other = (MemberAddArg)obj;
            return !(this.memberEmail != other.memberEmail && !this.memberEmail.equals(other.memberEmail) || this.memberGivenName != other.memberGivenName && !this.memberGivenName.equals(other.memberGivenName) || this.memberSurname != other.memberSurname && !this.memberSurname.equals(other.memberSurname) || this.memberExternalId != other.memberExternalId && (this.memberExternalId == null || !this.memberExternalId.equals(other.memberExternalId)) || this.memberPersistentId != other.memberPersistentId && (this.memberPersistentId == null || !this.memberPersistentId.equals(other.memberPersistentId)) || this.sendWelcomeEmail != other.sendWelcomeEmail || this.role != other.role && !this.role.equals((Object)other.role));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MemberAddArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberAddArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("member_email");
            StoneSerializers.string().serialize(value.memberEmail, g);
            g.writeFieldName("member_given_name");
            StoneSerializers.string().serialize(value.memberGivenName, g);
            g.writeFieldName("member_surname");
            StoneSerializers.string().serialize(value.memberSurname, g);
            if (value.memberExternalId != null) {
                g.writeFieldName("member_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberExternalId, g);
            }
            if (value.memberPersistentId != null) {
                g.writeFieldName("member_persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.memberPersistentId, g);
            }
            g.writeFieldName("send_welcome_email");
            StoneSerializers.boolean_().serialize((Boolean)value.sendWelcomeEmail, g);
            g.writeFieldName("role");
            AdminTier.Serializer.INSTANCE.serialize(value.role, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MemberAddArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AdminTier f_role;
            Boolean f_sendWelcomeEmail;
            String f_memberPersistentId;
            String f_memberExternalId;
            String f_memberSurname;
            String f_memberGivenName;
            String f_memberEmail;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_memberEmail = null;
                f_memberGivenName = null;
                f_memberSurname = null;
                f_memberExternalId = null;
                f_memberPersistentId = null;
                f_sendWelcomeEmail = true;
                f_role = AdminTier.MEMBER_ONLY;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("member_email".equals(field)) {
                        f_memberEmail = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_given_name".equals(field)) {
                        f_memberGivenName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_surname".equals(field)) {
                        f_memberSurname = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("member_external_id".equals(field)) {
                        f_memberExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("member_persistent_id".equals(field)) {
                        f_memberPersistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("send_welcome_email".equals(field)) {
                        f_sendWelcomeEmail = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("role".equals(field)) {
                        f_role = AdminTier.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_memberEmail == null) {
                    throw new JsonParseException(p, "Required field \"member_email\" missing.");
                }
                if (f_memberGivenName == null) {
                    throw new JsonParseException(p, "Required field \"member_given_name\" missing.");
                }
                if (f_memberSurname == null) {
                    throw new JsonParseException(p, "Required field \"member_surname\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MemberAddArg value = new MemberAddArg(f_memberEmail, f_memberGivenName, f_memberSurname, f_memberExternalId, f_memberPersistentId, f_sendWelcomeEmail, f_role);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String memberEmail;
        protected final String memberGivenName;
        protected final String memberSurname;
        protected String memberExternalId;
        protected String memberPersistentId;
        protected boolean sendWelcomeEmail;
        protected AdminTier role;

        protected Builder(String memberEmail, String memberGivenName, String memberSurname) {
            if (memberEmail == null) {
                throw new IllegalArgumentException("Required value for 'memberEmail' is null");
            }
            if (memberEmail.length() > 255) {
                throw new IllegalArgumentException("String 'memberEmail' is longer than 255");
            }
            if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", memberEmail)) {
                throw new IllegalArgumentException("String 'memberEmail' does not match pattern");
            }
            this.memberEmail = memberEmail;
            if (memberGivenName == null) {
                throw new IllegalArgumentException("Required value for 'memberGivenName' is null");
            }
            if (memberGivenName.length() < 1) {
                throw new IllegalArgumentException("String 'memberGivenName' is shorter than 1");
            }
            if (memberGivenName.length() > 100) {
                throw new IllegalArgumentException("String 'memberGivenName' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", memberGivenName)) {
                throw new IllegalArgumentException("String 'memberGivenName' does not match pattern");
            }
            this.memberGivenName = memberGivenName;
            if (memberSurname == null) {
                throw new IllegalArgumentException("Required value for 'memberSurname' is null");
            }
            if (memberSurname.length() < 1) {
                throw new IllegalArgumentException("String 'memberSurname' is shorter than 1");
            }
            if (memberSurname.length() > 100) {
                throw new IllegalArgumentException("String 'memberSurname' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", memberSurname)) {
                throw new IllegalArgumentException("String 'memberSurname' does not match pattern");
            }
            this.memberSurname = memberSurname;
            this.memberExternalId = null;
            this.memberPersistentId = null;
            this.sendWelcomeEmail = true;
            this.role = AdminTier.MEMBER_ONLY;
        }

        public Builder withMemberExternalId(String memberExternalId) {
            if (memberExternalId != null && memberExternalId.length() > 64) {
                throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
            }
            this.memberExternalId = memberExternalId;
            return this;
        }

        public Builder withMemberPersistentId(String memberPersistentId) {
            this.memberPersistentId = memberPersistentId;
            return this;
        }

        public Builder withSendWelcomeEmail(Boolean sendWelcomeEmail) {
            this.sendWelcomeEmail = sendWelcomeEmail != null ? sendWelcomeEmail : true;
            return this;
        }

        public Builder withRole(AdminTier role) {
            this.role = role != null ? role : AdminTier.MEMBER_ONLY;
            return this;
        }

        public MemberAddArg build() {
            return new MemberAddArg(this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.memberPersistentId, this.sendWelcomeEmail, this.role);
        }
    }
}

