/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public final class LinkExpiry {
    public static final LinkExpiry REMOVE_EXPIRY = new LinkExpiry(Tag.REMOVE_EXPIRY, null);
    public static final LinkExpiry OTHER = new LinkExpiry(Tag.OTHER, null);
    private final Tag _tag;
    private final Date setExpiryValue;

    private LinkExpiry(Tag _tag, Date setExpiryValue) {
        this._tag = _tag;
        this.setExpiryValue = setExpiryValue;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isRemoveExpiry() {
        return this._tag == Tag.REMOVE_EXPIRY;
    }

    public boolean isSetExpiry() {
        return this._tag == Tag.SET_EXPIRY;
    }

    public static LinkExpiry setExpiry(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkExpiry(Tag.SET_EXPIRY, value);
    }

    public Date getSetExpiryValue() {
        if (this._tag != Tag.SET_EXPIRY) {
            throw new IllegalStateException("Invalid tag: required Tag.SET_EXPIRY, but was Tag." + this._tag.name());
        }
        return this.setExpiryValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.setExpiryValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LinkExpiry) {
            LinkExpiry other = (LinkExpiry)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case REMOVE_EXPIRY: {
                    return true;
                }
                case SET_EXPIRY: {
                    return this.setExpiryValue == other.setExpiryValue || this.setExpiryValue.equals(other.setExpiryValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<LinkExpiry> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkExpiry value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case REMOVE_EXPIRY: {
                    g.writeString("remove_expiry");
                    break;
                }
                case SET_EXPIRY: {
                    g.writeStartObject();
                    this.writeTag("set_expiry", g);
                    g.writeFieldName("set_expiry");
                    StoneSerializers.timestamp().serialize(value.setExpiryValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LinkExpiry deserialize(JsonParser p) throws IOException, JsonParseException {
            LinkExpiry value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("remove_expiry".equals(tag)) {
                value = REMOVE_EXPIRY;
            } else if ("set_expiry".equals(tag)) {
                Date fieldValue = null;
                Serializer.expectField("set_expiry", p);
                fieldValue = StoneSerializers.timestamp().deserialize(p);
                value = LinkExpiry.setExpiry(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        REMOVE_EXPIRY,
        SET_EXPIRY,
        OTHER;

    }
}

