/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Job;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListJobsByStatusResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Job> jobs;
    private String nextPageToken;

    public List<Job> getJobs() {
        if (this.jobs == null) {
            this.jobs = new ListWithAutoConstructFlag();
            this.jobs.setAutoConstruct(true);
        }
        return this.jobs;
    }

    public void setJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
            return;
        }
        ListWithAutoConstructFlag jobsCopy = new ListWithAutoConstructFlag(jobs.size());
        jobsCopy.addAll(jobs);
        this.jobs = jobsCopy;
    }

    public ListJobsByStatusResult withJobs(Job ... jobs) {
        if (this.getJobs() == null) {
            this.setJobs(new ArrayList<Job>(jobs.length));
        }
        for (Job value : jobs) {
            this.getJobs().add(value);
        }
        return this;
    }

    public ListJobsByStatusResult withJobs(Collection<Job> jobs) {
        if (jobs == null) {
            this.jobs = null;
        } else {
            ListWithAutoConstructFlag jobsCopy = new ListWithAutoConstructFlag(jobs.size());
            jobsCopy.addAll(jobs);
            this.jobs = jobsCopy;
        }
        return this;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public ListJobsByStatusResult withNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobs() != null) {
            sb.append("Jobs: " + this.getJobs() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobs() == null ? 0 : this.getJobs().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByStatusResult)) {
            return false;
        }
        ListJobsByStatusResult other = (ListJobsByStatusResult)obj;
        if (other.getJobs() == null ^ this.getJobs() == null) {
            return false;
        }
        if (other.getJobs() != null && !other.getJobs().equals(this.getJobs())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public ListJobsByStatusResult clone() {
        try {
            return (ListJobsByStatusResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

