/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudsearchdomain.model.Bucket;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BucketInfo
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Bucket> buckets;

    public List<Bucket> getBuckets() {
        if (this.buckets == null) {
            this.buckets = new ListWithAutoConstructFlag();
            this.buckets.setAutoConstruct(true);
        }
        return this.buckets;
    }

    public void setBuckets(Collection<Bucket> buckets) {
        if (buckets == null) {
            this.buckets = null;
            return;
        }
        ListWithAutoConstructFlag bucketsCopy = new ListWithAutoConstructFlag(buckets.size());
        bucketsCopy.addAll(buckets);
        this.buckets = bucketsCopy;
    }

    public BucketInfo withBuckets(Bucket ... buckets) {
        if (this.getBuckets() == null) {
            this.setBuckets(new ArrayList<Bucket>(buckets.length));
        }
        for (Bucket value : buckets) {
            this.getBuckets().add(value);
        }
        return this;
    }

    public BucketInfo withBuckets(Collection<Bucket> buckets) {
        if (buckets == null) {
            this.buckets = null;
        } else {
            ListWithAutoConstructFlag bucketsCopy = new ListWithAutoConstructFlag(buckets.size());
            bucketsCopy.addAll(buckets);
            this.buckets = bucketsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBuckets() != null) {
            sb.append("Buckets: " + this.getBuckets());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBuckets() == null ? 0 : this.getBuckets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketInfo)) {
            return false;
        }
        BucketInfo other = (BucketInfo)obj;
        if (other.getBuckets() == null ^ this.getBuckets() == null) {
            return false;
        }
        return other.getBuckets() == null || other.getBuckets().equals(this.getBuckets());
    }

    public BucketInfo clone() {
        try {
            return (BucketInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

