/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionItem;
import com.hazelcast.collection.set.SetService;
import com.hazelcast.collection.txn.AbstractTransactionalCollectionProxy;
import com.hazelcast.collection.txn.CollectionReserveAddOperation;
import com.hazelcast.collection.txn.CollectionTransactionLog;
import com.hazelcast.collection.txn.CollectionTxnAddOperation;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;

public class TransactionalSetProxy<E>
extends AbstractTransactionalCollectionProxy<SetService, E>
implements TransactionalSet<E> {
    private final HashSet<CollectionItem> set = new HashSet();

    public TransactionalSetProxy(String name, TransactionSupport tx, NodeEngine nodeEngine, SetService service) {
        super(name, tx, nodeEngine, service);
    }

    @Override
    public boolean add(E e) {
        this.checkTransactionState();
        this.throwExceptionIfNull(e);
        NodeEngine nodeEngine = this.getNodeEngine();
        Data value = nodeEngine.toData(e);
        if (!this.getCollection().add(new CollectionItem(-1L, value))) {
            return false;
        }
        CollectionReserveAddOperation operation = new CollectionReserveAddOperation(this.name, this.tx.getTxnId(), value);
        try {
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition(this.getServiceName(), operation, this.partitionId);
            Long itemId = (Long)f.get();
            if (itemId != null) {
                if (!this.itemIdSet.add(itemId)) {
                    throw new TransactionException("Duplicate itemId: " + itemId);
                }
                CollectionTxnAddOperation op = new CollectionTxnAddOperation(this.name, itemId, value);
                this.tx.addTransactionLog(new CollectionTransactionLog(itemId, this.name, this.partitionId, this.getServiceName(), this.tx.getTxnId(), op));
                return true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:setService";
    }

    @Override
    protected Collection<CollectionItem> getCollection() {
        return this.set;
    }
}

