/*
 * User attributes:
 * com.4psa.voipnow/enabled = true
 * com.4psa.voipnow/mainExtension = ID=NUMBER
 * com.4psa.voipnow/extensionN = NUMBER=NAME (N = [1..])
 */

/**
 * Returns the currently selected contacts.
 * @type Array
 * @return An array of contact IDs as used by OXCache.newRequest()
 */
function getContacts() {
    if (currentpath2[1] == "cards") return contactsSelection2.getSelected();
    if (contactGrid) return contactGrid.selection.getSelected();
    if (typeof contactDetailId == "object") return [contactDetailId];
    return [{ folder_id: activefolder, id: contactDetailId }];
}

// Calling
var phoneFields = ["telephone_ip", "telephone_business1", "telephone_business2",
                   "telephone_callback", "telephone_car", "telephone_company",
                   "telephone_home1", "telephone_home2", "cellular_telephone1",
                   "cellular_telephone2", "telephone_other", "telephone_isdn",
                   "telephone_pager", "telephone_primary", "telephone_radio",
                   "telephone_telex", "telephone_ttytdd",
                   "telephone_assistant"];
var phoneLabels = [
    //#. telephone_ip
    _("IP phone"),
    //#. telephone_business1
    _("Business"),
    //#. telephone_business2
    _("Business 2"),
    //#. telephone_callback
    _("Callback"),
    //#. telephone_car
    _("Car phone"),
    //#. telephone_company
    _("Company"),
    //#. telephone_home1
    _("Private"),
    //#. telephone_home2
    _("Private 2"),
    //#. cellular_telephone1
    _("Mobile"),
    //#. cellular_telephone2
    _("Mobile 2"),
    //#. telephone_other
    _("Other"),
    //#. telephone_isdn
    _("ISDN"),
    //#. telephone_pager
    _("Pager"),
    //#. telephone_primary
    _("Primary"),
    //#. telephone_radio
    _("Radio"),
    //#. telephone_telex
    _("Telex"),
    //#. telephone_ttytdd
    _("TTY/TDD"),
    //#. telephone_assistant
    _("Assistant")
];
var userURI = (function() {
    var cols = new Array(phoneFields.length);
    for (var i = 0; i < phoneFields.length; i++) {
        cols[i] = OXContactMapping.stringmapping[phoneFields[i]];
    }
    phoneFields.push("display_name");
    phoneFields.push("internal_userid");
    return AjaxRoot + "/user?action=list&columns=" + cols.join() +
        "&com.4psa.voipnow=*&session=";
})();

//----------------------------------------------

/*
 * Lightbox-based dialog. Shows contact name, phone numbers, a dial box as well as a console.
 */
function VoipCallDialog() {

	this.contact = null;
	
	this.lightbox = newnode("div", {
		position: "fixed", 
		top: "50%", left: "0px", width: "100%", zIndex: 65000,
		display: "none"
	});
	// semi-transparent overlay
	this.lightboxOverlay = newnode("div", {
		position: "fixed", backgroundColor: "black",
		filter: "alpha(opacity=50)", opacity: 0.5,
		top: "0px", right: "0px", bottom: "0px", left: "0px", zIndex: 1,
		display: "none"
	});
	// popup
	this.lightboxPopup = newnode("div", {
		position: "relative",
		width: "400px", height: "30em", margin: "-15em auto", zIndex: 2, border: "1px solid #555",
		MozBorderRadius: "10px", MozBoxShadow: "1px 1px 5px black", fontSize: "10pt",
		webkitBorderRadius: "10px", webkitBoxShadow: "1px 1px 5px black"
	}, { className: "background-color-content" });
	this.lightbox.appendChild(this.lightboxPopup);
	// callee
	this.callee = newnode("div", { 
		backgroundColor: "white", padding: "1em",
		fontSize: "14pt", fontWeight: "normal", color: "black", 
		borderBottom: "1px solid #aaa", marginBottom: "0.5em",
		MozBorderRadiusTopleft: "10px", MozBorderRadiusTopright: "10px",
		webkitBorderTopLeftRadius: "10px", webkitBorderTopRightRadius: "10px"
	});
	this.lightboxPopup.appendChild(this.callee);
	// phone book
	this.phoneBook = newnode("div", { 
		fontSize: "10pt", fontWeight: "normal", color: "black", padding: "0px 20px 0px 20px"
	});
	this.lightboxPopup.appendChild(this.phoneBook);
	// dialer
	this.dialer = newnode("div", { 
		fontSize: "10pt", fontWeight: "normal", color: "black", padding: "10px 20px 0px 20px"
	});	
	this.lightboxPopup.appendChild(this.dialer);
	// log
	this.log = newnode("div", { 
		backgroundColor: "white", height: "5em", overflow: "auto",
		fontSize: "9pt", lineHeight: "11pt", fontWeight: "normal", color: "black", 
		margin: "1em 20px 0em 20px", padding: "5px"
	});
	this.lightboxPopup.appendChild(this.log);
	// close button
	this.buttons = newnode("div", { 
		padding: "1em 20px 0em 20px", textAlign: "right"
	});
	this.lightboxPopup.appendChild(this.buttons);
	// add to document
	document.body.appendChild(this.lightbox);
	document.body.appendChild(this.lightboxOverlay);
	// add listeners
	var self = this;
	addDOMEvent(this.lightboxOverlay, "click", function() {
		self.hide();
	});
	
	// paint dialer
	this.paintDialer();
	// paint "close" button
	this.paintButtons();
}

VoipCallDialog.prototype.show = function(contact) {
	// clear
	this.callee.innerHTML = "";
	this.phoneBook.innerHTML = "";
	this.log.innerHTML = "";
	this.box.value = "";
	// contact given?
	if (contact) {
		this.contact = contact;
		// paint callee
		this.paintCallee(contact);
		// paint numbers
		this.paintNumbers(contact);
	} else {
		this.contact = null;
	}
	// show dialog
	this.lightbox.style.display = "block";
	this.lightboxOverlay.style.display = "block";
	this.box.focus();
	// wait for ESC
	var self = this;
	this.escapeHandler = function(e) {
		var key = e.keyCode || e.which;
		if (key == 27) { self.hide(); }
	};
	addDOMEvent(document.body, "keypress", this.escapeHandler);
};

VoipCallDialog.prototype.hide = function() {
	removeDOMEvent(document.body, "keypress", this.escapeHandler);
	this.lightbox.style.display = "none";
	this.lightboxOverlay.style.display = "none";
};

VoipCallDialog.prototype.paintCallee = function(contact) {
	if (contact) {
		var str = "";
		// title?
		if (contact.title) { str += contact.title + " "; }
		var names = [];
		// last name
		if (contact.last_name) { names.push(contact.last_name); }
		// first name
		if (contact.first_name) { names.push(contact.first_name); }
		str += names.join(", ");
		// display name
		if (!str) { str = contact.display_name; }
		if (this.callee.firstChild) {
            this.callee.firstChild.data = str;
		} else {
            this.callee.appendChild(document.createTextNode(str));
		}
	}
};

VoipCallDialog.prototype.paintNumbers = function(contact) {
	if (contact) {
		// add caption
		var caption = newnode("div", {
			fontWeight: "bold", color: "#555", lineHeight: "2em"
		}, 0, [addTranslated(_("Phone numbers")), newtext(":")]);
		this.phoneBook.appendChild(caption);
		var numbers = newnode("div", {
			height: "8em", overflow: "auto", backgroundColor: "#ddd"
		});
		this.phoneBook.appendChild(numbers);
		// loop through phone numbers
		var i = 0, $l = phoneFields.length - 2, first = true, border = "1px solid #aaa";
		for (; i < $l; i++) {
			var key = phoneFields[i], name = phoneLabels[i], value = contact[key];
			if (value) addNumber(name, value);
		}
		if (contact.unnamedNumbers) {
		    for (var i = 0; i < contact.unnamedNumbers.length; i++) {
		        addNumber(noI18n(""), contact.unnamedNumbers[i]);
		    }
		}
	}
    var self = this;
	function addNumber(name, value) {
        // create div
	    var children = [];
	    if (name) {
	        children.push(addTranslated(name));
	        children.push(newtext(": "));
	    }
	    children.push(newnode("b", 0, 0, [newtext(value)]));
        var div = newnode("div", {
            cursor: "pointer", lineHeight: "2em", backgroundColor: "white",
            borderBottom: border, paddingLeft: "10px"
        }, 0, children);
        // first?
        if (first) { div.style.borderTop = border; first = false; }
        // add listeners
        addDOMEvent(div, "mouseover", function() { div.className = "background-color-PMG-selection-elements"; });
        addDOMEvent(div, "mouseout", function() { div.className = ""; });
        addDOMEvent(div, "click", function() {
            self.box.value = value;
            self.box.focus();
        });
        addDOMEvent(div, "dblclick", function() {
            self.box.value = value;
            self.call();
        });
        numbers.appendChild(div);
    }
};

VoipCallDialog.prototype.paintDialer = function() {
	
	var self = this;
	
	// caption
	var caption = newnode("div", {
		fontWeight: "bold", color: "#555", lineHeight: "2em"
	}, 0, [addTranslated(_("Number to call")), newtext(":")]);
	this.dialer.appendChild(caption);
	
	// text box
	this.box = newnode("input", {
		width: "320px", fontSize: "14pt", fontWeight: "bold", color: "black", paddingLeft: "9px"
	}, { type: "text" });
	this.box.value = "";
	this.dialer.appendChild(this.box);
	// add listener
	
	addDOMEvent(this.box, "keypress", function(e) {
		var key = e.keyCode || e.which;
		if (key == 13) { self.call(); }
	});
	
	// icon
	this.icon = newnode("img", {
		width: "16px", height: "16px", marginLeft: "10px", cursor: "pointer"
	}, { src: urlify("plugins/com.4psa.voipnow/images/call.png") });
	this.dialer.appendChild(this.icon);
	// add listener
	addDOMEvent(this.icon, "click", function() {
		self.call();
	});
};

VoipCallDialog.prototype.paintButtons = function() {
	var self = this;
	// close button
	var button = newnode("input", 0, { type: "button", value: _("Close") });
    register("LanguageChanged", function() { button.value = _("Close"); });
	// add listener
	addDOMEvent(button, "click", function() {
		self.hide();
	});
	// add
	this.buttons.appendChild(button);
};

VoipCallDialog.prototype.call = function() {
	var self = this;
	var number = this.box.value;
	if (number != "") {
		// clear log
		this.log.innerHTML = "";
		// clean up
		number = number.replace(/[^0-9#*+]/g, "");
		var callerId = this.contact ? this.contact.display_name : "";
		var message = _("Connecting to VoIP server...");
		this.log.appendChild(newnode("div", { color: "#333" }, 0, [addTranslated(message)]));
		// talk to server
		active.wait(function(active) {
    		ox.JSON.put(AjaxRoot + "/com.4psa.voipnow?action=newcall&phone=" +
                encodeURIComponent(number) + "&callerid=" + encodeURIComponent(callerId) + 
                "&session=" + session, getPhones(),
                // success
                function() {
                    //#, c-format
    				var message = format(_("Connection established. Please check your SIP client in order to answer the call. Afterwards, the number %s will be automatically called."), number);
    				self.log.appendChild(newnode("div", { color: "#050", fontWeight: "bold" }, 0, [addTranslated(message)]));
    			},
    			// error
    			function(response) {
    				var error = newtext("Unkown error.");
    				if (typeof response == "string") {
    					error = newtext(response);
    				} else if (response && response.error) {
    					error = addTranslated(formatError(response));
    				}
    				self.log.appendChild(newnode("div", { color: "#800", fontWeight: "bold" }, 0, [error]));
    			}
    		);
		});
	}
};

var callDialog = new VoipCallDialog();

//---------------------------------------------

/*
 * Hook. Called for each contact in card view.
 */
register("PAINT_CONTACT", function(e) {
	
	try {
		// is contact?
		if (e.contact.distribution_list === null) {
			
			// create image
			var img = newnode("img", { cursor: "pointer" },
			    { src: urlify("plugins/com.4psa.voipnow/images/call.png") });
			// add listener
			addDOMEvent(img, "click", function() {
				// ensure necessary data (phone data might be missing)
				var collection = { objects: [e.contact], columns: phoneFields };
		        OXCache.newRequest(null, "contacts", collection, null, function(data) {
		        	var contact = data.objects[0];
		        	callDialog.show(contact);
		        	// hide potential hover
		        	if (e.hover) {
		        		e.hover.enable(); // resets hover (includes hide)
		        	}
		        });
			});
 
			// view
			switch (e.view) {
			
			case "card":
				// get card & first child
				var card = e.node.firstChild, first = card.firstChild;
				// adjust image
				img.align = "absmiddle";
				img.className = "cardHeaderIcons";
				first.appendChild(img);
				break;
				
			case "hover":
				// get target node (jquery would be great here)
				var target = e.node.childNodes[1].firstChild.firstChild.childNodes[1].firstChild;
				var div = newnode("div", { paddingRight: "3px" }, { className: "cardHoverIconRight" }, [img]);
				target.insertBefore(div, target.firstChild || null);
				break;
			}
		}
	}
	catch(exc) { }
});

// ---------------------------------------------

// The menu

var callHistoryButtons = [];

function createGlobalTab() {
    var section = new ox.gui.PanelMenuSection(_("VoipNow"));
    
    var callButton = new ox.gui.MenuItem({
        title: _("Call"),
        icons: ["plugins/com.4psa.voipnow/images/call.png",
                "plugins/com.4psa.voipnow/images/call_d.png"],
        pathPrefix: "",
        action: callButtonAction
    });
    register("OX_SELECTED_ITEMS_CHANGED", updateMenu);
    register("OX_Switched", updateMenu);
    function updateMenu() {
        callButton.setVisible(activemodule == "contacts");
        callButton.setEnabled(menucountselected == 1);
    }
    section.add(callButton);
    
    section.add(new ox.gui.MenuItem({
        title: _("Fax"),
        icons: ["plugins/com.4psa.voipnow/images/fax.png",
                "plugins/com.4psa.voipnow/images/fax_d.png"],
        pathPrefix: "",
        action: faxButtonAction
    }));
    
    var callHistoryButton = new ox.gui.MenuItem({
        title: _("Call history"),
        icons: ["img/dummy.gif", "img/dummy.gif"],
        action: function() {
            triggerEvent("OX_Switch_View", "com.4psa.voipnow.callhistory");
            return true;
        }
    });
    callHistoryButtons.push(callHistoryButton);
    section.add(callHistoryButton);
    
    var locationMenu = new ox.gui.MenuItem({
        title: _("My location"),
        action: function() {
            locations.wait(function(locations) {
                locationMenu.removeChildren();
                for (var i in locations) {
                    locationMenu.add(new ox.gui.MenuItem({
                        title: noI18n(locations[i].name),
                        action: (function(id) { return function() {
                            active.update(id);
                            return true;
                        }; })(i)
                    }));
                }
                locationMenu.validate();
            });
        }
    });
    section.add(locationMenu);
    
    locations.register(function(locations, join) {
        locationMenu.removeChildren();
        for (var i in locations) {
            locationMenu.add(new ox.gui.MenuItem({
                title: noI18n(locations[i].name),
                action: (function(id) {
                    return function() {
                        active.update(id);
                        return true;
                    };
                })(i)
            }));
        }
        active.update(active.value, join.add());
        config.modules["com.4psa.voipnow"].gui.locations = locations;
    });
    
    var tab = new ox.gui.PanelMenu("", _("VoipNow"));
    tab.add(section);
    return tab;
}

function callButtonAction() {
    var collection = { objects: getContacts(), columns: phoneFields };
    OXCache.newRequest(null, "contacts", collection, null,
        function(data) {
            var contact = data.objects[0];
            var uid = contact.internal_userid;
            if (uid) {
                ox.JSON.put(AjaxRoot + "/user?action=list&columns=1" + 
                    "&com.4psa.voipnow=mainExtension&session=" + session,
                    [contact.internal_userid],
                    function(data) {
                        var ext = data.data[0][1];
                        ext = ext && /^(?:\d+=)?(.*)$/.exec(ext)[1];
                        if (ext) newcall(ext); else popup();
                    });
            } else {
                popup();
            }
            function popup() {
                callDialog.show(contact);
            }
            function newcall(number) {
                active.wait(function(active) {
                    ox.JSON.put(AjaxRoot +
                        "/com.4psa.voipnow?action=newcall&phone=" +
                        encodeURIComponent(number.replace(/[^0-9#*+]/g, "")) +
                        "&callerid=" +
                        encodeURIComponent(contact.display_name) +
                        "&session=" + session, getPhones(), emptyFunction);
                });
            }
        });
}

// Sending faxes

var faxFields = ["fax_business", "fax_home", "fax_other"];
function faxButtonAction() {
    switch (activemodule) {
        case "contacts":
            var collection = { objects: getContacts(), columns: faxFields };
            OXCache.newRequest(null, "contacts", collection, null,
                function(data) {
                    var numbers = [], contacts = [];
                    for (var i = 0; i < data.objects.length; i++) {
                        var contact = data.objects[i];
                        for (var j = 0; j < faxFields.length; j++) {
                            if (contact[faxFields[j]]) {
                                numbers.push(contact[faxFields[j]]);
                                contacts.push(contact);
                                break;
                            }
                        }
                    }
                    if (contacts.length == data.objects.length) {
                        newFax(numbers);
                    } else {
                        if (contacts.length) {
                            ox.Configuration.error(
                                _("Not all selected contacts have an associated fax number."));
                        } else {
                            ox.Configuration.error(
                                ngettext("The selected contact has no associated fax number.",
                                    "The selected contacts have no associated fax number.",
                                    data.objects.length));
                        }
                    }
                });
            break;
        case "infostore":
            var requests = new Array(oLastSelectedInfoObject.length);
            for (var i = 0; i < oLastSelectedInfoObject.length; i++) {
                requests[i] = {
                    module: "infostore", action: "get",
                    folder: oLastSelectedInfoObject[i].folder,
                    id: oLastSelectedInfoObject[i].id
                };
            }
            ox.JSON.put(AjaxRoot + "/multiple?session=" + session, requests,
                function(data) {   
                    var items = new Array(data.length);
                    var allFiles = true;
                    for(var i = 0; i < data.length; data++) {
                        var obj = data[i].data;
                        if (obj.file_size <= 0) allFiles = false;
                        items[i] = {
                            filename: obj.filename,
                            size: obj.file_size,
                            content_type: obj.file_mimetype,
                            id: obj.id
                        };
                    }
                    if (allFiles) newFax(0, items);
                });
            break;
        default:
            newFax();
    }
    return true;
}

function newFax(faxes, attachments) {
    var params = { to: configGetKey("modules")["com.4psa.voipnow"].fax };
    if (faxes) {
        for (var i = 0; i < faxes.length; i++) {
            faxes[i] = faxes[i].replace(/[^0-9#*+]/g, "");
        }
        params.subject = faxes.join(" ");
    }
    ox.api.window.open("newMail.html", { params: params, success: function(w) {
        if (ox.api.window.isEmbedded()) {
            modify(w);
        } else if (IE < 9) {
            w.attachEvent("onload", cb);
        } else {
            addDOMEvent(w, "load", cb);
        }
        function cb() {
            if (IE < 9) {
                w.detachEvent("onload", cb);
            } else {
                removeDOMEvent(w, "load", cb);
            }
            modify(w);
        }
    } });
    function modify(w) {
        if (attachments) w.aInfoMailAttachmentFile = attachments;
        function w$(id) { return w.document.getElementById(id); }
        w.document.title = String(_("Fax"));
        function rapelaceText(node, text) {
            delete w.init.i18n[node.id];
            node.removeChild(node.firstChild);
            node.appendChild(w.newtext(text));
        }
        var tr = w$("subject").parentNode.parentNode;
        rapelaceText(tr.getElementsByTagName("span")[0], String(_("To")));
        var trs = tr.parentNode.childNodes;
        for (var i = 0; i < trs.length; i++) {
            if (trs[i] !== tr && trs[i].nodeType == 1) {
                trs[i].style.display = "none";
            }
        }
        w.MailFunctions.prototype.showAdditionalHeaderField =
            w.MailFunctions.prototype.drawAttachmentPanel;
        var oldSendMessage = w.MailFunctions.prototype.sendMessage;
        w.MailFunctions.prototype.sendMessage = function(param) {
            if (!param) this.getMailValues();
            if (!this.oo.subject) {
                w.setTimeout(function() {
                    w.triggerEvent("OX_New_Error", 4,
                        _("Please specify at least one recipient fax number."));
                }, 0);
                return;
            }
            var a = new w.opener.Array();
            a.push({ content: "", content_type: "TEXT/PLAIN" });
            if (this.oo.attachments[0].content.length) {
                a.push({ content: this.oo.attachments[0].content,
                         content_type: "TEXT/PLAIN" });
            }
            for (var i = 1; i < this.oo.attachments.length; i++) {
                a.push(this.oo.attachments[i]);
            }
            this.oo.attachments = a;
            var Self = this;
            ox.JSON.get(AjaxRoot +
                "/com.4psa.voipnow?action=faxauth&subject=" +
                encodeURIComponent(this.oo.subject) +
                "&session=" + session,
                function(reply) {
                    Self.oo.headers = reply.data;
                    oldSendMessage.call(Self, true);
                });
        };
        var oldInitToolbar = w.ox.gui.initToolBarNewWindowMail;
        w.ox.gui.initToolBarNewWindowMail = function() {
            oldInitToolbar.apply(this, arguments);
            var tab = w.ox.widgets.toolBar.viewControl.
                views["new-mail-menu"].getChildren()[0];
            tab.setTitle(_("Fax"));
            var section = tab.getChildren()[0];
            section.removeChild(section.getChildren()[1]);
            tab.removeChild(tab.getChildren()[2]);
            tab.validate();
        };
    }
}

// My Location
function Updatable() {
    this.callbacks = [];
    this.updates = [];
}
Updatable.prototype.wait = function(callback) {
    if (this.callbacks) {
        this.callbacks.push(callback);
    } else {
        callback(this.value);
    }
};
Updatable.prototype.register = function(callback) {
    this.updates.push(callback);
},
Updatable.prototype.update = function(value, callback) {
    var join = new Join(callback || emptyFunction);
    this.value = value;
    if (this.callbacks) {
        for (var i = 0; i < this.callbacks.length; i++) {
            this.callbacks[i](value);
        }
        this.callbacks = null;
    }
    var f = join.add();
    for (var i = 0; i < this.updates.length; i++) this.updates[i](value, join);
    f();
};
var phones = new Updatable();
var locations = new Updatable(), active = new Updatable();

function getPhones() {
    var phones = [];
    var loc = locations.value[active.value];
    if (loc) {
        for (var i in loc.phones) {
            if (loc.phones[i]) phones.push(i);
        }
    }
    return phones;
}

var oldPhones;
active.register(function(active, join) {
    function equals(a, b) {
        if (typeof a == "object" && typeof b == "object" && a && b) { 
            for (var i in a) if (!(i in b) || !equals(a[i], b[i])) return false;
            for (var i in b) if (!(i in a)) return false;
            return true;
        } else {
            return a == b;
        }
    }
    var newConfig = { active: active, locations: locations.value };
    if (equals(config.modules["com.4psa.voipnow"].gui, newConfig)) {
        config.modules["com.4psa.voipnow"].gui.active = active;
        return;
    }
    config.modules["com.4psa.voipnow"].gui.active = active;
    ox.JSON.put(AjaxRoot + "/config/modules/com.4psa.voipnow/gui?session=" +
        session, newConfig,
        join.add(), join.alt());
    if (!locations.value[active]) return;
    var locPhones = locations.value[active].phones;
    var phones = [];
    for (var i in locPhones) if (locPhones[i]) phones.push(i);
    phones.sort();
    if (!oldPhones || !arraysEqual(phones, oldPhones)) {
        oldPhones = phones;
        ox.JSON.put(AjaxRoot +
            "/com.4psa.voipnow?action=followme&session=" + session, phones,
            join.add(), join.alt());
    }
    function arraysEqual(a, b) {
        if (a.length != b.length) return false;
        for (var i = 0; i < a.length; i++) if (a[i] != b[i]) return false;
        return true;
    }
});
phones.wait(function(defaultPhones) {
    var gui = config.modules["com.4psa.voipnow"].gui;
    if (!gui) gui = config.modules["com.4psa.voipnow"].gui = {};
    if (!gui.active) gui.active = 1;
    if (!gui.locations) gui.locations = { 1: defaultPhones };
    active.value = gui.active;
    locations.update(gui.locations);
});

// Call History

function CallHistory() {
    this.id = 0;
    this.start = this.end = Math.floor(now() / 864e5) * 864e5; // ms/day
    this.data = [];
    // number of calls on the last queried day (which will be queried again)
    this.today = 0;
    /*
     *  The event "Update" fires when new calls are available.
     */  
    this.events = new Events();
    this.callbacks = [];
    var Self = this;
    this.update_cb = function() { Self.update(); };
    this.update();
}

CallHistory.prototype = {
    getData: function(start, end, callback) {
        var Self = this;
        this.updating = true;
        ox.JSON.get(AjaxRoot + "/com.4psa.voipnow?action=callreport&start=" +
            start + "&end=" + end + "&session=" + session, cb);
        function cb(reply) {
            Self.updating = false;
            var calls = reply.data.calls;
            for (var i = 0; i < calls.length; i++) {
                var call = calls[i];
                call.id = ++Self.id;
                call.number = call.flow == "out" ? call.destination
                                                 : call.source;
            }
            callback(calls.reverse());
        }
    },
    update: function(callback) {
        if (callback) this.callbacks.push(callback);
        if (this.updating) return; 
        var Self = this;
        var end = Math.floor(now() / 864e5) * 864e5; // ms/day
        this.getData(this.end, end, cb);
        function cb(calls) {
            Self.data = Self.data.concat(calls.slice(Self.today));
            if (Self.end == end) {
                if (Self.today != calls.length) {
                    Self.today = calls.length;
                    Self.events.trigger("Update");
                }
            } else {
                var i = Self.today;
                while (i < calls.length && calls[i].startDate < end) i++;
                Self.today = calls.length - i;
                Self.end = end;
                Self.events.trigger("Update");
            }
            for (var i = 0; i < Self.callbacks.length; i++) Self.callbacks[i]();
        }
    },
    get: function(days, callback) {
        var Self = this;
        var start = (Math.floor(now() / 864e5) - days + 1) * 864e5; // ms/day
        if (start >= this.start) {
            this.update(callback);
        } else if (this.updating) {
            this.callbacks.push(get_cb);
        } else {
            get_cb();
        }
        function get_cb() {
            Self.data = [];
            Self.start = Self.end = start;
            Self.today = 0;
            Self.update(callback);
        }
    }
};

var history = new CallHistory();
register("OX_Refresh", function() { history.update(); });

// Menu

menulastviews["com.4psa.voipnow.callhistory"] = "com.4psa.voipnow.callhistory";
var menu = new ox.gui.TabMenu({ id: "com.4psa.voipnow.callhistory" });
var filterTab = new ox.gui.PanelMenu(undefined, _("Filter"));
menu.add(filterTab);
ox.widgets.toolBar.viewControl.add(menu);
menu.addListener("widget:togglehover", ox.ToolBarController.resize);

// TODO filter: days

function View(title, history) {
    this.history = history;
    this.flow = 0;
    this.result = 1;
    var Self = this;
    
    var groupID = 0;
    function createMenuSelection(title, names, values, callback) {
        var section = new ox.gui.PanelMenuSection(title);
        var group = "com.4psa.voipnow." + groupID++;
        for (var i = 0; i < names.length; i++) {
            section.add(new ox.gui.MenuItem({
                title: names[i],
                behavior: "radio",
                group: group,
                action: (function(value) {
                    return function() { callback(value); };
                })(values[i])
            }));
        }
        section.getChildren()[0].setChecked(true);
        filterTab.add(section);
    }
    createMenuSelection(_("Status"),
        [_("Missed"), _("Taken"), _("All")], [1, 0, 2],
        function(result) {
            Self.result = result;
            Self.update();
        });
    createMenuSelection(_("Calls"),
        [_("Incoming"), _("Outgoing"), _("All")], [0, 1, 2],
        function(flow) {
            Self.flow = flow;
            Self.update();
        });
    
    registerView("com.4psa.voipnow.callhistory", function() {
        showNode("modules");
        if (!Self.initialized && Self.init) Self.init();
        ox.Configuration.View.i18n.callback = function() {
            return expectI18n(title);
        };
        ox.Configuration.View.i18n.update();
        ox.Configuration.View.i18n.enable();
        $("modules.content").appendChild(Self.content);
        temporary.configuration.showToolbar(menu);
    }, function() {
        ox.Configuration.View.current = Self;
        Self.enter();
    }, function() {
        Self.leave();
        ox.Configuration.View.current = null;
    }, function() {
        $("modules.content").removeChild(Self.content);
        ox.Configuration.View.i18n.disable();
        hideNode("modules");
    }, function() {
        Self.leave();
        Self.enter();
    }
    );
    changeDisplay("com.4psa.voipnow.callhistory", "menu_nothing");
    this.update_cb = function() { Self.update(); };
}

View.prototype = {
    init: function() {
        var list = this.list = new LiveGrid([
            {
                text: noI18n(""),
                width: "26px",
                sortable: true,
                id: "flow",
                clear: function(div) {
                    var src = getFullImgSrc("img/dummy.gif");
                    if (div.firstChild) {
                        div.firstChild.src = src;
                    } else {
                        div.appendChild(newnode("img",
                            { verticalAlign: "middle" }, { src: src }));
                    }
                },
                set: function(div, data) {
                    var src = urlify("plugins/com.4psa.voipnow/images/" +
                        (data.flow == "in" ? "incoming.png"
                                           : "outgoing.png"));
                    if (div.firstChild) {
                        div.firstChild.src = src;
                    } else {
                        div.appendChild(newnode("img",
                            { verticalAlign: "middle" }, { src: src }));
                    }
                    div.parentNode.parentNode.style.color = 
                        data.answerDate > 0 ? "" : "maroon";
                }
            },
            {
                text: _("Number"),
                style: { fontWeight: "bold" },
                index: "number",
                width: "10em",
                sortable: true,
                id: "number",
                clear: LiveGrid.makeClear(""),
                set: LiveGrid.defaultSet
            },
            {
                text: _("Time"),
                index: "startDate",
                width: "10em",
                sortable: true,
                id: "startDate",
                clear: LiveGrid.makeClear(""),
                set: LiveGrid.dateSetTime
            },
            {
                text: _("Duration"),
                index: "duration",
                sortable: true,
                id: "duration",
                clear: LiveGrid.makeClear(""),
                set: function(div, data) {
                    data = Number(data);
                    var d = new Date(data * 1000);
                    var text;
                    if (data <= 0) text = "";
                    //#. Abbreviation for '%d seconds'
                    //#, c-format
                    else if (data < 60) text = format(_("%d s"), data);
                    else if (data < 3600) text = formatDateTime("m:ss", d);
                    else if (data < 864e5) text = formatDateTime("H:mm:ss", d);
                    else text = getInterval(d);
                    LiveGrid.defaultSet(div, text);
                }
            },
        ], new Selection());
        list.sort = LiveGrid.localSort;
        list.sort_id = "startDate";
        list.sort_order = "desc";
        list.events.register("Activated", function(ids) {
            if (!ids.length) return;
            var numbers = [];
            list.storage.newIterate(ids, emptyFunction,
                function(i, call) { numbers.push(call.number); },
                function() {
                    callDialog.show({ display_name: numbers.join(", "),
                                      unnamedNumbers: numbers });
                });
        });
        var list_parent = newnode("div", {
            position: "absolute", top: "1.6em", bottom: 0, overflow: "auto",
            width: "100%"
        });
        this.content = newnode("div", {
            position: "absolute", left: 0, top: 0, right: 0, bottom: 0,
            overflow: "hidden"
        }, 0, [list.getHeader(), list_parent]);
        list.getTable(list_parent);
        this.initialized = true;
    },
    enter: function() {
        var Self = this;
        Self.history.events.register("Update", Self.update_cb);
        this.history.get(10, function() {
            oldMissedCalls = missedCalls;
            setMissedCalls(0);
        });
    },
    leave: function() {
        this.history.events.unregister("Update", this.update_cb);
    },
    resize: function() {
    },
    update: function() {
        var storage = new Storage(0, [], 0, 0, 0, 0,
            function(x) { return x.id; });
        var all = this.history.data, filtered = [];
        for (var i = 0; i < all.length; i++) {
            var call = all[i];
            if (   Number(call.flow != "out") != this.flow
                && Number(call.answerDate > 0) != this.result)
            {
                filtered.push(call);
            }
        }
        storage.append(filtered);
        this.list.enable(storage);
        this.list.sort(this.list.sort_id, this.list.sort_order);
    }
};

var callHistory = new View(_("Call history"), history);

function setMissedCalls(missed) {
    for (var i = 0; i < callHistoryButtons.length; i++) {
        callHistoryButtons[i].setIcon(missed ? "img/mail/email_priohigh.gif"
                                      : "img/dummy.gif");
    }
}

var oldMissedCalls = 0, missedCalls = 0;
history.events.register("Update", function() {
    missedCalls = 0;
    for (var i = history.data.length - 1; i >= 0; i--) {
        if (history.data[i].startDate < history.end) break;
        if (!(history.data[i].answerDate > 0)) missedCalls++;
    }
    setMissedCalls(missedCalls > oldMissedCalls);
});

var allModules = ["toolbar-portal", "toolbar-mail", "toolbar-calendar",
                  "toolbar-contacts", "toolbar-tasks", "toolbar-infostore",
                  "toolbar-messaging", "com.4psa.voipnow.callhistory"];
for (var i = 0; i < allModules.length; i++) {
    var view = ox.widgets.toolBar.viewControl.views[allModules[i]];
    if (view) view.add(createGlobalTab());
}

// Icons in mail lists
if (temporary.lists.mail) {
    temporary.lists.mail.addIcon({
        name: ["headers/X-voipnow-email-type"],
        width: "16px",
        isVisible: function(mail) {
            return Boolean(mail.headers && mail.headers["X-voipnow-email-type"]);
        },
        getIcon: function(mail) {
            switch (mail.headers["X-voipnow-email-type"]) {
                case "voicemail":
                    return "/plugins/com.4psa.voipnow/images/voicemail.png";
                case "fax":
                    return "/plugins/com.4psa.voipnow/images/fax.png";
                default:
                    return "img/dummy.gif";
            }
        }
    });
}

// Configuration
new ox.Configuration.InnerNode(
    "configuration/com.4psa.voipnow", _("VoipNow"));
var node = new ox.Configuration.LeafNode(
    "configuration/com.4psa.voipnow/phones", _("Phones"));
var page = new ox.Configuration.VSplit(node, _("VoipNow phone configuration"),
                                       0.2);

var internal = new ox.Configuration.Group(_("Internal phones"));
var external = new ox.Configuration.Group(_("External phones"));
function updatePhones() {
    var defaultPhones = { name: String(_("Default location")), phones: {} };
    ox.JSON.put(userURI + session, [configGetKey("identifier")], handleUser);
    var userdata, mainExtension;
    function handleUser(data) {
        userdata = data.data[0];
        var extensions = userdata[phoneFields.length - 2];
        var indices = [];
        for (var i in extensions) {
            var match = /^com.4psa.voipnow\/extension(\d+)$/.exec(i);
            if (match) indices.push(Number(match[1]));
        }
        indices.sort();
        var prefix = "com.4psa.voipnow/extension";
        for (var i = 0; i < indices.length; i++) {
            var ext = /^(.*?)=(.*)$/.exec(extensions[prefix + indices[i]]);
            internal.addWidget(new ox.UI.CheckBox(noI18n(ext[2])), ext[1]);
            defaultPhones.phones[ext[1]] = true;
        }
        mainExtension = /^(\d+)=(.*)$/.exec(
            extensions["com.4psa.voipnow/mainExtension"]);
        ox.JSON.get(AjaxRoot + "/com.4psa.voipnow?action=publicnums&session=" +
            session, handlePublicNums);
    }
    function handlePublicNums(data) {
        var publicNumbers = {};
        publicNumbers[mainExtension[2]] = true;
        data = data.data;
        for (var i = 0; i < data.length; i++) {
            publicNumbers[data[i]] = true;
        }
        for (var i = 0; i < phoneFields.length - 2; i++) {
            if (userdata[i] && !(userdata[i] in publicNumbers)) {
                external.addWidget(new ox.UI.CheckBox(format(
                    //#. external phone label
                    //#. %1$s is the phone number
                    //#. %2$s is the field name in the contact
                    //#, c-format
                    _("%1$s (%2$s)"), phoneLabels[i],
                    noI18n(userdata[i]))), userdata[i]);
                defaultPhones.phones[userdata[i]] = false;
            }
        }
        phones.update(defaultPhones);
    }
}
updatePhones();

var storage;
function saveLocations(callback) {
    var locs = {};
    storage.newIterate(storage.ids, emptyFunction, function(i, loc) {
        var loc2 = {};
        for (var i in loc) if (i != "id") loc2[i] = loc[i];
        locs[loc.id] = loc2;
    }, function() { locations.update(locs, callback); });
}

page.init = function() {
    page.list = new LiveGrid([
        {
            text: _("Location"),
            index: "name",
            clear: LiveGrid.makeClear(""),
            set: LiveGrid.defaultSet
        }
    ], new Selection());
    var name = new ox.UI.Input(_("Name"));
    page.addWidget(name, "name");
    phones.wait(function() {
        var sharedGroup = {
            get: function(data, value) {
                if (!data.phones) data.phones = {};
                for (var i in value) data.phones[i] = value[i];
            },
            set: function(data) { return data.phones; }
        };
        page.addWidget(internal, sharedGroup);
        page.addWidget(external, sharedGroup);
    });
    page.enableList = function() {
        // TODO: update phones on enter
        locations.wait(function(locations) {
            var data = [];
            var id = 0;
            for (var i in locations) {
                var loc = locations[i];
                data.push({ id: ++id, name: loc.name, phones: loc.phones });
            }
            storage = new Storage(0, [], 0, 0, 0, 0,
                function(location) { return location.id; });
            storage.append(data);
            page.list.enable(storage);
            if (!page.list.selection.count) page.list.selection.click(0);
        });
    };
    page.load = function(cont) {
        storage.newIterate(page.list.selection.getSelected(), emptyFunction,
            function(i, data) { cont(data); });
    };
    page.save = function(data, cont) {
        if (!("id" in data)) {
            data.id = storage.ids.length + 1;
            storage.append([data]);
        } else {
            storage.localUpdate([data.id], function(i, old) { return data; });
        }
        saveLocations(function() {
            ox.Configuration.info(_("Your settings have been saved."));
            cont();
        });
    };
    
    page.toolbar = temporary.configuration.newToolbar(_("Locations"),
        [temporary.configuration.saveButton, {
            title: _("Locations"),
            buttons: [{
                title: _("New"),
                action: function() {
                    page.addNew({ name: _("New location"),
                                  phones: phones.value.phones });
                }
            }, {
                title: _("Delete"),
                icons: ["img/menu/delete.gif", "img/menu/delete_d.gif"],
                action: confirmDelete
            }]
        }]);
    var deleteButton = page.toolbar.getChildren()[0].getChildren()[1].
        getChildren()[1];
    function confirmDelete() {
        var count = page.list.selection.count;
        if (!count) return;
        newConfirm(
            ngettext("Delete location", "Delete locations", count),
            ngettext("Are you sure you want to delete the selected location?",
                "Are you sure you want to delete the selected locations?",
                count),
            AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
    }
    function handleDelete() {
        page.list.deleteIDs(page.list.selection.getSelected());
        saveLocations(emptyFunction);
    }
    register("OX_SELECTED_ITEMS_CHANGED", function() {
        var count = page.list.selection.count;
        deleteButton.setEnabled(count > 0 && storage.ids.length > count);
    });
    
};