
# norootforbuild

Name:           open-xchange-usm
BuildArch:	noarch
#!BuildIgnore: post-build-checks
BuildRequires:  unzip, open-xchange-server == 6.20.8.0
%if 0%{?suse_version} && 0%{?sles_version} < 11
%if %{?suse_version} <= 1010
# SLES10
BuildRequires:  java-1_5_0-ibm >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-devel >= 1.5.0_sr9
BuildRequires:  java-1_5_0-ibm-alsa >= 1.5.0_sr9
BuildRequires:  update-alternatives
%endif
%if %{?suse_version} >= 1100
BuildRequires:  java-sdk-openjdk
%endif
%if %{?suse_version} > 1010 && %{?suse_version} < 1100
BuildRequires:  java-sdk-1.5.0-sun
%endif
%endif
%if 0%{?sles_version} >= 11
# SLES11 or higher
BuildRequires:  java-1_6_0-ibm-devel
%endif

%if 0%{?rhel_version}
# libgcj seems to be installed whether we want or not and libgcj needs cairo
BuildRequires:  java-sdk-sun cairo
%endif
%if 0%{?fedora_version}
%if %{?fedora_version} > 8
BuildRequires:  java-1.6.0-openjdk-devel saxon
%endif
%if %{?fedora_version} >= 15
BuildRequires:  xerces-j2
%endif
%endif
%if 0%{?centos_version}
BuildRequires:  java-1.6.0-openjdk-devel
%endif
Version:	6.20.8.0
%define		ox_release 0
Release:	%{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
License:        GNU General Public License (GPL)
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
#URL:            
Source:         %{name}_%{version}.orig.tar.gz
Summary:        The Open-Xchange Server USM Bundle
Requires:	open-xchange == 6.20.8.0
#

#----------------------------------------------------------------------
%package -n     open-xchange-syncml
Group:          Applications/Productivity
Summary:        The Open-Xchange Server SyncML Bundle
Requires:       open-xchange-usm

%description -n open-xchange-syncml
The Open-Xchange Server SyncML Bundle

Authors:
--------
    Open-Xchange

%description
The Open-Xchange Server USM Bundle

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build


%install
export NO_BRP_CHECK_BYTECODE_VERSION=true

make DESTDIR=%{buildroot} install
find %{buildroot}/opt/open-xchange/bundles -maxdepth 1 -type f -printf "%p\n" > usm.files
find %{buildroot}/opt/open-xchange/etc/groupware/osgi/bundle.d -maxdepth 1 -type f -printf "%p\n" >> usm.files
perl -pi -e 's;%{buildroot};;' usm.files
make DESTDIR=%{buildroot} install-syncml

%clean
%{__rm} -rf %{buildroot}


%post

if [ ${1:-0} -eq 2 ]; then
   # only when updating
   . /opt/open-xchange/etc/oxfunctions.sh

   # prevent bash from expanding, see bug 13316
   GLOBIGNORE='*'

   # SoftwareChange_Request-1040
   # SoftwareChange_Request-1056 overrides all values with 0
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/groupware/usm_json.properties
   if ! ox_exists_property com.openexchange.usm.json.access_check.test_interval $pfile; then
       #ox_set_property com.openexchange.usm.json.access_check.test_interval 60000 $pfile
       ox_set_property com.openexchange.usm.json.access_check.test_interval 0 $pfile
   fi
   if ! ox_exists_property com.openexchange.usm.json.access_check.max_accesses $pfile; then
       #ox_set_property com.openexchange.usm.json.access_check.max_accesses 10 $pfile
       ox_set_property com.openexchange.usm.json.access_check.max_accesses 0 $pfile
   fi
   if ! ox_exists_property com.openexchange.usm.json.access_check.refusal_interval $pfile; then
       #ox_set_property com.openexchange.usm.json.access_check.refusal_interval 600000 $pfile
       ox_set_property com.openexchange.usm.json.access_check.refusal_interval 0 $pfile
   fi

   # SoftwareChange_Request-1032
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/groupware/usm.properties
   if ! ox_exists_property com.openexchange.usm.force_new_sync_key_on_empty_sync $pfile; then
       ox_set_property com.openexchange.usm.force_new_sync_key_on_empty_sync false $pfile
   fi

   # SoftwareChange_Request-539
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/groupware/usm.properties
   if ! ox_exists_property com.openexchange.usm.session.sync.cache.time_limit.complete $pfile; then
      ox_set_property com.openexchange.usm.session.sync.cache.time_limit.complete 60000 $pfile
   fi
   if ! ox_exists_property com.openexchange.usm.session.sync.cache.time_limit.incomplete $pfile; then
      ox_set_property com.openexchange.usm.session.sync.cache.time_limit.incomplete 1200000 $pfile
   fi

   # SoftwareChange_Request-367
   # -----------------------------------------------------------------------
   pfile=/opt/open-xchange/etc/groupware/usm_json.properties
   if ! ox_exists_property com.openexchange.usm.json.sync.limit.objects $pfile; then
      ox_set_property com.openexchange.usm.json.sync.limit.objects 0 $pfile
   fi
   if ! ox_exists_property com.openexchange.usm.json.sync.limit.email_size $pfile; then
      ox_set_property com.openexchange.usm.json.sync.limit.email_size 2097152 $pfile
   fi
   if ! ox_exists_property com.openexchange.usm.json.sync.limit.pim_attachment_count $pfile; then
      ox_set_property com.openexchange.usm.json.sync.limit.pim_attachment_count 5 $pfile
   fi
fi


%files -f usm.files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles
%dir /opt/open-xchange/etc/groupware/osgi/bundle.d
%dir /opt/open-xchange/etc/admindaemon/osgi/bundle.d
%dir /opt/open-xchange/etc/groupware
%dir /opt/open-xchange/etc/admindaemon
/opt/open-xchange/etc/admindaemon/osgi/bundle.d/*
%config(noreplace) /opt/open-xchange/etc/groupware/usm*.properties
%doc ChangeLog

%files -n open-xchange-syncml
%defattr(-,root,root)
%dir /opt/open-xchange/bundles
%dir /opt/open-xchange/etc/groupware
%dir /opt/open-xchange/etc/groupware/osgi/bundle.d
/opt/open-xchange/etc/groupware/osgi/bundle.d/*syncml*.ini
/opt/open-xchange/bundles/*syncml*.jar
%config(noreplace) /opt/open-xchange/etc/groupware/syncml.properties

%changelog
* Mon Sep 10 2012 - ldo@microdoc.de
 - Bug 22944 - NPE when creating a profile
* Fri Sep 07 2012 - ldo@microdoc.de
 - Bug 22837 - no GAL lookup possible on Android 4
* Mon Sep 03 2012 - ldo@microdoc.de
 - Bug 22663 - report conflicts on resources as error when editing appointments
* Thu Aug 23 2012 - ldo@microdoc.de
 - Bug 22642 - UUID already mapped by server error - client uses UUID reserved for server on change
* Wed Aug 22 2012 - ldo@microdoc.de
 - Bug 22798 - Email in Contacts - wrong mapping on Android phones
* Tue Aug 21 2012 - ldo@microdoc.de
 - Bug 22818 - Mails do not have field modified_by
* Tue Aug 21 2012 - ldo@microdoc.de
 - Bug 22737 - Added Error Status 15 (UID already exists on server)
* Mon Aug 20 2012 - ldo@microdoc.de
 - Bug 21773 - update confirmation status on external participants
* Fri Aug 17 2012 - ldo@microdoc.de
 - Bug 22272 - Mails with German Umlaute get messed on Android 4.0.3
* Tue Aug 14 2012 - ldo@microdoc.de
 - Bug 21638 - Conflicting change on field "modified_by" after move operation from client
* Mon Aug 13 2012 - ldo@microdoc.de
 - Bug 22741 - Disable the ping request limit for all protocols except EAS
* Mon Aug 13 2012 - ldo@microdoc.de
 - Bug 20268 - extra step on move appointments removed - it is not needed anymore because the server is not changing fields on move
* Wed Aug 08 2012 - ldo@microdoc.de
 - Bug 22138 - added series_timezone and series_start_date to meeting_request/meeting_cancelation field
* Tue Aug 07 2012 - ldo@microdoc.de
 - Bug 22716 - DataObjects (in DataSets) are equal only if the uuids are equal
* Fri Aug 03 2012 - ldo@microdoc.de
 - Bug 22324 - conflicting delete_exceptions and change_exceptions: same date
* Wed Jul 25 2012 - afe@microdoc.de
 - Bug 22671 - EAS: Contacts2-tag-table was missing an entry ("IMAddress3")
* Wed Jul 18 2012 - afe@microdoc.de
 - Bug 22329 - Delete appointment on client (and send new MeetingRequest) if participant status was reset by the OX server
* Tue Jul 17 2012 - afe@microdoc.de
 - Bug 21723/22328 - Removed change introduced for bug 21723, since the original behavior is actually the desired one. This also removes the unwanted side effect introduced with the change 
* Mon Jul 16 2012 - afe@microdoc.de
 - Bug 22488 - USM/JSON: Correctly set attachments for new exceptions to appointment series that already have attachments
* Mon Jul 16 2012 - afe@microdoc.de
 - Bug 22485 - USM/JSON: Add missing attachments list to meeting_requests
* Fri Jul 13 2012 - afe@microdoc.de
 - Increased default value of the number of allowed unnecessary requests from 40 to 80 (within in 2 minutes) before a client is temporarily denied access   
* Thu Jul 12 2012 - afe@microdoc.de
 - Bug 22488 - USM sometimes reported the wrong error code if a folder for synchronization was not found
* Thu Jul 05 2012 - ldo@microdoc.de
 - Bug 22347 - References and In-Reply-To Headers should be set in mails sent via eas. 
* Mon Jun 18 2012 - ldo@microdoc.de
 - Bug 22000 - Find object in default calendar or tasks folder - setConfirmationStatus for tasks
* Fri Jun 15 2012 - ldo@microdoc.de
 - Bug 22000 - Call action=confrim for tasks if the field "users" has been modified by the client
* Fri Jun 15 2012 - ldo@microdoc.de
 - Bug 21536 - Send change_exception as delete_exception if the user has deleted one occurrence in a foreign series app. on the server
* Thu Jun 14 2012 - ldo@microdoc.de
 - Bug 21955 - NPE when trying to import an appointment from ics attachment on the iPhone
* Tue Jun 12 2012 - ldo@microdoc.de
 - Bug 22000 - changed setConfirmationStatus command to work also for Tasks 
* Tue Jun 12 2012 - ldo@microdoc.de
 - Bug 21723 - Canceled appointments should not be displayed in shared folders
* Mon Jun 11 2012 - ldo@microdoc.de
 - Bug 22140 - DOS-Shield is disabled, because of blocking clients with big folder hierarchy during normal work 
* Mon Jun 11 2012 - ldo@microdoc.de
 - Bug 21858 - reply from android gets duplicated quote intro line
* Mon Jun 11 2012 - ldo@microdoc.de
 - Bug 22209 - add field email address to resources
* Tue Jun 05 2012 - ldo@microdoc.de
 - Bug 22253 - NPE at MailAttachment.equals
* Mon Jun 04 2012 - ldo@microdoc.de
 - Bug 21599 - Field UID should be unique for series exceptions when the series is not visible to the user
* Mon Jun 04 2012 - ldo@microdoc.de
 - Bug 22013 - Lots of warnings: Duplicate property on server start
* Fri Jun 01 2012 - ldo@microdoc.de
 - Bug 22141 - eMail priority swapped on Android device when receiving mail
* Fri Jun 01 2012 - afe@microdoc.de
 - Bug 22223 - From-Header in sent mails contained extra backslashes in user display name
* Thu May 31 2012 - afe@microdoc.de
 - Bug 22122 - Added method to allow protocols to invalidate the USM cache for OX data, added multi-step update in JSON protocol for multiple updates in series and exceptions
* Thu May 31 2012 - ldo@microdoc.de
 - Bug 21738 - HTC Phones do not accept foreign organizer for appointments
* Wed May 30 2012 - ldo@microdoc.de
 - Bug 21756 - NPE at MappingApplicationDataToContentTypeData.transformFromString
* Wed May 30 2012 - afe@microdoc.de
 - Bug 18176 - EAS: Use correct mapping for BusyStatus<->shown_as for both MeetingRequests and Appointments (the EAS values differ for those 2 types)
* Tue May 29 2012 - ldo@microdoc.de
 - Bug 22081 - Error code IMAP-1016 can be returned from server when IMAP is temporary unreachable
* Fri May 25 2012 - afe@microdoc.de
 - Bug 22140 - Fixed problem in detecting old SyncKeys, adjusted default values for test and block intervals and number of requests required to block access
* Fri May 25 2012 - afe@microdoc.de
 - Bug 22206 - New mechanism to temporarily prevent access for clients that behave badly (i.e. send too many unnecessary synchronizations)
* Thu May 24 2012 - afe@microdoc.de
 - Bug 22164 - An unwanted side effect of the change for bug 21587 caused for some client creations to be repeatedly detected as server changes, which might cause endless synchronizations if too many of those creations occurred in 1 folder
* Tue May 22 2012 - ldo@microdoc.de
 - Bug 21951 - Return error status code 14 on folder deletion/change failed on server due to insufficient permissions
* Tue May 22 2012 - ldo@microdoc.de
 - Bug 21938 - Return the folder uuid as "not found" if the client tries to invalidate objects from a non existing folder
* Mon May 21 2012 - afe@microdoc.de
 - Bug 22140 - Introduced new mechanism that detects clients that behave badly (too many unnecessary synchronizations) and temporarily refuses access to them (see config property com.openexchange.usm.json.access_check.test_interval for more information) 
* Mon May 21 2012 - ldo@microdoc.de
 - Bug 22136 - usage of Html2TextConverter.html2text replaced with com.openexchange.html.HTMLService.html2text
* Wed May 16 2012 - ldo@microdoc.de
 - Bug 21435 - Include attachments in a forwarded mail via EAS command SmartForward
* Mon May 14 2012 - ldo@microdoc.de
 - Removed counter for usage of old sync keys per session (F_usedOldSK)
* Mon May 14 2012 - afe@microdoc.de
 - Bug 21587 - Optimization to use same SyncKey can be deactivated (new server config property com.openexchange.usm.force_new_sync_key_on_empty_sync)
* Fri May 11 2012 - ldo@microdoc.de
 - Bug 22110 - Allow arbitrary order of tags CollectionId and SyncKey in GetItemEstimate
* Fri May 11 2012 - afe@microdoc.de
 - Bug 21587 - Optional extra protocol information was not checked when testing for changes to avoid unnecessary updates in USMDataStorage
 - Bug 22117 - Ignore empty OX result (if appointment wasn't previously created) when trying to delete an appointment based on an external deletion
* Thu May 10 2012 - afe@microdoc.de
 - Bug 22088 - Fixed problems in dummy invitation mail handling: dummy mail changes are now only reported if GetChanges is set by the client, the base sync state is now used instead of the newest 
* Wed May 09 2012 - afe@microdoc.de
 - Bug 21860 - Allow duplicate email creation, handle special cases where sync was partially performed, log warning if client tries to create an email it should already know (i.e. it is using a SyncState in which the email was already present)
* Wed May 09 2012 - ldo@microdoc.de
 - Bug 21932 - eMail Address gets corrupted when adding a contact via EAS on Android to the address book
* Wed May 09 2012 - afe@microdoc.de
 - Bug 21945 - Changed method to remove unused syncstates in DB to avoid large SQL statements
* Tue May 08 2012 - afe@microdoc.de
 - Bug 21587 - Fixed problem in test case, fixed problem if initial slow sync is performed on empty folder
* Fri May 04 2012 - ldo@microdoc.de
 - Bug 22049 - email address empty in OX after email change on IOS 5
* Fri May 04 2012 - afe@microdoc.de
 - Bug 21587 - Fixed problem in SyncState storage optimization, now all modified states will correctly trigger a new storage
* Fri Apr 27 2012 - ldo@microdoc.de
 - Bug 21587 - Do not increment the syncKey when no changes are reported/received
* Tue Apr 24 2012 - ldo@microdoc.de
 - Bug 20911 - bug fix for 20911 removed - it is not needed anymore because of changed strategy at the client
* Fri Apr 20 2012 - ldo@microdoc.de
 - Bug 20911 - move items besides conflicts between client and server
* Wed Apr 18 2012 - dsu@microdoc.de
 - Bug 21435 - Forwarded/replied (form Samsung Galaxy and HTC) plain text and html mails should be contain now the newly added text.
	 know issues:
 	-the html reply is not formatted well, but no text is lost. (HTC)
	-the reply to an email with attachment will not include the attachment. There is a workaround to solve this issue, 
	but it's time consuming for implementation. The attachments are not included when reply to an email -> see 
	http://oxpedia.org/index.php?title=HTTP_API#Reply.2FForward_a_mail.  
* Wed Apr 18 2012 - ldo@microdoc.de
 - Bug 20991 - Read server changes after client modification (move) on a folder and return them in the response to the move
* Wed Apr 18 2012 - dsu@microdoc.de
 - Bug 21857 - The wrong mail header was fixed. 
* Thu Apr 05 2012 - ldo@microdoc.de
 - Bug 21256 - inbox should not be polled if it is not been initially synchronized yet. 
* Wed Apr 04 2012 - ldo@microdoc.de
 - Bug 21740 - orphan instance upsync changes (main) serial
* Mon Apr 02 2012 - ldo@microdoc.de
 - Bug 21636 - Added meeting_cancelation field for emails about canceled appointments - added rdate property
* Mon Apr 02 2012 - ldo@microdoc.de
 - Bug 21587 - Added persistent session field "F_usedOldSK" as counter for usage of old sync keys per session
* Wed Mar 28 2012 - ldo@microdoc.de
 - Bug 21636 - Added meeting_cancelation field for emails about canceled appointments
* Mon Mar 26 2012 - ldo@microdoc.de
 - Bug 21448, 21741 - Duplicate appointment created when accepting twice - remove the invitation mail if app was accepted in another client 
* Thu Mar 22 2012 - ldo@microdoc.de
 - Bug 21587 - Make UPDATE in USMDataStorage instead of DELETE/INSERT if the folder state has not changed but only the sync key. 
* Mon Mar 12 2012 - ldo@microdoc.de
 - Bug 21500 - java.lang.IllegalArgumentException: DataObjects of different folders in SyncUpdateHandler
* Fri Mar 09 2012 - ldo@microdoc.de
 - Bug 21514 - Endless sync after creating app in a shared folder which got invisible in meantime
* Thu Mar 08 2012 - ldo@microdoc.de
 - Bug 21690 - Accepting team-appointment on iPhone deletes it for all other participants - do not remove participants if the client doesn't send the Attendees tag
* Wed Mar 07 2012 - afe@microdoc.de
 - Bug 20300 - Implemented handling of external invitation followed by external cancellation without intermediate accept of the client
* Mon Mar 05 2012 - ldo@microdoc.de
 - Bug 21681 - NPE at removeDummyInvitationMailForAcceptedAppointments 
* Fri Mar 02 2012 - ldo@microdoc.de
 - Bug 21448 - Duplicate appointment created when accepting twice - remove the invitation mail if app was accepted in another client
* Thu Mar 01 2012 - ldo@microdoc.de
 - Bug 21448 - Duplicate appointment created when accepting twice - do not report the new appointment until the invitation mail is present
* Mon Feb 27 2012 - ldo@microdoc.de
 - Bug 21105 - Entries in contact fields vanish on mobile phone using Nokia E72 to sync with OX
* Mon Feb 27 2012 - afe@microdoc.de
 - Bug 20884, 21587 - Limit number of direct ping responses for modified folders (after 3 pings, folders will be marked synchronized even if no sync has been performed)
* Fri Feb 24 2012 - ldo@microdoc.de
 - Bug 20300 - GlobalObjId in external meeting requests - use UTF-8 encoding
* Fri Feb 24 2012 - ldo@microdoc.de
 - Bug 21605 - Replying to emails via EAS with HTC Desire S / Desire HD result in a server error 503 Mail can not be sent
* Thu Feb 23 2012 - ldo@microdoc.de
 - Bug 21394 - Appointments created in the past get duplicated on the device after the appointment gets accepted in the gui - send change after accept
* Thu Feb 23 2012 - ldo@microdoc.de
 - Bug 21628 - ICS attachments are not shown via EAS - test show ics attachments always (also for meeting requests) 
* Thu Feb 23 2012 - afe@microdoc.de
 - Bug 20462 - Added logging of bad folder hierarchies (at level WARNING) including session and cyclic folder IDs  
* Wed Feb 22 2012 - ldo@microdoc.de
 - Bug 21269 - Reply HTML mails with inline text creates junk content on Android - (replies were readable only in GUI after the previous fix)
* Wed Feb 22 2012 - afe@microdoc.de
 - Bug 20462 - Fix for possible endless loop in sorting of folder hierarchy if folder hierarchy contains a loop (i.e. F1 has F2 as parent and F2 has F1 as parent) 
* Wed Feb 22 2012 - ldo@microdoc.de
 - Bug 21394 - Appointments created in the past get duplicated on the device after the appointment gets accepted in the gui 
* Tue Feb 21 2012 - ldo@microdoc.de
 - Bug 21269 - Reply HTML mails with inline text creates junk content on Android - set the real encoding header
* Mon Feb 20 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations - globalObjId coding - test sign 0x82 removed
* Fri Feb 17 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations - report the external organizer in meeting requests
 - Bug 20300 - External Invitations - don't change the organizer on calendar sync
 - Bug 20300 - External Invitations - don't require response on meeting cancelation
 - Bug 20300 - External Invitations - create globalObjId in meetingRequests with vCal-Uid prefix  + null bytes
 - Bug 20300 - External Invitations - for internal invitation the organizer should still be the current user
* Thu Feb 16 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations in EAS; request, update, cancelation
 - Bug 20300 - Delete the invitation mail after the user has responded
 - Bug 20300 - Send correct calendar id on meeting response
 - Bug 20300 - Generate "cancel" meeting request
* Wed Feb 15 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations in EAS; Part I - meeting response - read attachments mail field from server; resolve uid 
* Tue Feb 14 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations in EAS; Part I - implemented meeting requests (new meetings) - add organizer to meeting request
 - Bug 20300 - External Invitations in EAS; Part I - implemented meeting requests (new meetings) - meeting response
* Mon Feb 13 2012 - ldo@microdoc.de
 - Bug 21407 - Workaround for 21072 fixed. this fixes also bug 21407 and 21415
* Fri Feb 10 2012 - ldo@microdoc.de
 - Bug 20300 - External Invitations in EAS; Part I - implemented meeting requests (new meetings)
* Mon Feb 06 2012 - ldo@microdoc.de
 - Bug 21324 - Stop EAS Servlet activation if no journal (logging) can be created 
* Fri Jan 27 2012 - ldo@microdoc.de
 - Bug 20805 - Implement new fields 227 organizerId, 228 principal, 229 principalID  in USM.
* Thu Jan 26 2012 - ldo@microdoc.de
 - Bug 21364 -  Third instant messenger address lost during synchronization
* Wed Jan 25 2012 - ldo@microdoc.de
 - Bug 21341 - null ping INTERNAL_ERROR - java.lang.ArrayIndexOutOfBoundsException in USMJSONServlet
* Wed Jan 25 2012 - ldo@microdoc.de
 - Bug 21351 - errorOnDuplicateName should not be active for EAS users
* Tue Jan 24 2012 - ldo@microdoc.de
 - Bug 21326 - NPE in USMJSONServlet
* Fri Jan 20 2012 - ldo@microdoc.de
 - Bug 21291 - Unable to synchronize EAS folder if folder selection is active and property sync_all_folders = email 
* Fri Jan 20 2012 - ldo@microdoc.de
 - Bug 21072 - Exceptions from a series appointment aren't synced to IOS (when not creator of the app)
* Thu Jan 19 2012 - ldo@microdoc.de
 - Bug 21223 - Make folder tree parameter "tree=" configurable
* Tue Jan 17 2012 - ldo@microdoc.de
 - Bug 21142 - Do not report email folders as deleted on IMAP down
* Fri Jan 13 2012 - ldo@microdoc.de
 - Bug 20613 - Added parameter errorOnDuplicateName to GET /ajax/folders?action=list
* Thu Jan 12 2012 - ldo@microdoc.de
 - Bug 21173 - StringIndexOutOfBoundsException in MimeMailBuilder.formatReceived
* Thu Jan 12 2012 - ldo@microdoc.de
 - Bug 21166 - Client sends UTC time in local_time param on login
* Thu Jan 12 2012 - ldo@microdoc.de
 - Removed syncid from result in SetConfirmationStatus because it can not be used by the client
* Tue Jan 10 2012 - ldo@microdoc.de
 - Bug 21147 - NPE when the IMAP server is stopped
* Mon Jan 09 2012 - ldo@microdoc.de
 - Bug 21117 - StringIndexOutOfBoundsException in MimeMailBuilder.formatReceived
* Fri Dec 23 2011 - ldo@microdoc.de
 - Bug 20954 - do not add pim attachments to the result if no data is present
* Wed Dec 21 2011 - ldo@microdoc.de
 - Bug 20872 - added new cache configuration for the UUID cache: USMUUIDCache
* Wed Dec 21 2011 - ldo@microdoc.de
 - Bug 19123 - added field UID to tasks
* Wed Dec 21 2011 - ldo@microdoc.de
 - Bug 20779 - Downsync to OL changed the status of an appointment - handling for "orphan instances"
* Tue Dec 20 2011 - ldo@microdoc.de
 - Bug 21031 - USM Error: java.lang.StringIndexOutOfBoundsException
* Tue Dec 20 2011 - ldo@microdoc.de
 - Bug 20911 - invitations from external must be removed two times to get finally deleted - SetConfirmationStatus returns syncid
* Fri Dec 16 2011 - ldo@microdoc.de
 - Bug 19827 - added additional address fields
* Thu Dec 15 2011 - ldo@microdoc.de
 - Bug 20971 - [L3] Editing draft mails not possible after mail has been saved - ping/pong on color_label
* Thu Dec 15 2011 - ldo@microdoc.de
 - Bug 20974 - USM error with "Undelivered Mail Returned to Sender" - NPE when formatting received header
* Fri Dec 09 2011 - ldo@microdoc.de
 - Retry requests to server up to 10 times if the server has returned an error from category: 4,5,6 or 11.
* Thu Dec 08 2011 - ldo@microdoc.de
 - Bug 20950 - Wrong client date/time causes an USM error: bad sessionid - new parameter "local_time" on login introduced. 
* Wed Dec 07 2011 - ldo@microdoc.de
 - Bug 20895 - enable inline forwarded messages - fix for android phones
* Tue Dec 06 2011 - ldo@microdoc.de
 - Bug 20895 - enable inline forwarded messages from devices
* Mon Dec 05 2011 - ldo@microdoc.de
 - Bug 20842 - Appointment series -  deletion of just one app does not get synchronized 
* Fri Dec 02 2011 - ldo@microdoc.de
 - Bug 20900 - html mails not shown on devices
* Fri Dec 02 2011 - ldo@microdoc.de
 - Look for the meeting request appointment in the default calendar folder first, and if not found look in all folders
* Fri Dec 02 2011 - ldo@microdoc.de
 - Bug 20519 - HTTP client of USM should not follow HTTP 302 redirect responses
* Thu Dec 01 2011 - ldo@microdoc.de
 - Set timezone to UTC when converting meeting requests from external users
* Wed Nov 30 2011 - ldo@microdoc.de
 - Bug 20885 - illegal null in ping result
* Wed Nov 30 2011 - ldo@microdoc.de
 - Bug 20745 - declined appointments are still available on the device
* Tue Nov 29 2011 - ldo@microdoc.de
 - Bug 20696 - Special characters not recognized for password authentication - use iso-8859-1 for iOS
* Mon Nov 28 2011 - ldo@microdoc.de
 - Bug 20388 - added internal max. WindowSize for emails
* Fri Nov 25 2011 - ldo@microdoc.de
 - Bug 20854 - "unparseable reply or missing field" 0x800d1000 error during sync of public contacts folder - text/html; charset="UTF-8" not recognized as valid header
* Fri Nov 25 2011 - ldo@microdoc.de
 - Bug 20825 - filter out system folders from ping result
* Fri Nov 25 2011 - ldo@microdoc.de
 - Bug 20850 - com.openexchange.usm.datatypes.contacts.Image incompatible with java.lang.Number
* Thu Nov 24 2011 - ldo@microdoc.de
 - Bug 20849 - NullPointerException with USM-Build 4505
* Thu Nov 24 2011 - ldo@microdoc.de
 - Poll the inbox in USM/JSON after a ping from client if the last saved sync state for the inbox is larger than a configured interval
* Wed Nov 23 2011 - ldo@microdoc.de
 - Bug #20847 - USM JSON mixes client IP addresses due to multithreading issue
* Tue Nov 22 2011 - ldo@microdoc.de
 - Bug #20191 - Mail header of received mails changed on IMAP-server after answering in Outlook - merge the x-original-headers with header
* Fri Nov 18 2011 - ldo@microdoc.de
 - Bug 19471 - Invitation mails accepted with Thunderbird can't be understood with Outlook2010 + OXTender - introduced field method_reply
* Thu Nov 17 2011 - ldo@microdoc.de
 - Bug 19471 - Invitation mails accepted with Thunderbird can't be understood with Outlook2010 + OXTender
* Thu Nov 10 2011 - ldo@microdoc.de
 - Bug 20760 - Problem when replying/forwarding messages from Samsung Androind phones
* Wed Nov 09 2011 - ldo@microdoc.de
 - Bug #19715 - Add default email address to getConfiguration call (USM/JSON)
* Tue Nov 08 2011 - ldo@microdoc.de
 - Bug #20085 - High CPU-load caused by SlowContentSyncer when syncing contact folder
* Mon Nov 07 2011 - ldo@microdoc.de
 - Bug #20320 - add meeting_update/meeting_cancelation field to invitations from external mail servers
* Thu Nov 03 2011 - ldo@microdoc.de
 - Bug #20706 - USM should send custom HTTP headers to the OX server
* Mon Oct 24 2011 - ldo@microdoc.de
 - Bug #20465 - Mail isn't pushed to client using imapidle
* Mon Oct 24 2011 - ldo@microdoc.de
 - Bug #20189 - Folder inconsistencies after repeated try to move a folder below public folders
* Thu Oct 20 2011 - ldo@microdoc.de
 - Bug #20612 - USM error: Extra information for new object could not be read from OX server - check for missing sequence and uid in the meeting request object
* Wed Oct 19 2011 - ldo@microdoc.de
 - Bug #20268 - conflicts on update after move of appointments
* Wed Oct 19 2011 - ldo@microdoc.de
 - Bug #20612 - USM error: Extra information for new object could not be read from OX server
* Tue Oct 18 2011 - afe@microdoc.de
 - Bug #18074 - Use HttpsURL when combining https URL with relative URL
* Fri Oct 14 2011 - ldo@microdoc.de
 - Bug #20320 - add meeting_request field to invitations from external mail servers
* Fri Oct 14 2011 - ldo@microdoc.de
 - Bug #20320 - distinguish  between meeting_request and meeting_update in invitations from external mail servers
* Tue Oct 11 2011 - ldo@microdoc.de
 - Bug #20449 - meeting_request/meeting_update: change_exceptions are reported as delete_exceptions
* Mon Oct 10 2011 - ldo@microdoc.de
 - Bug #19662 - OLOX2 doesn't handle S/MIME signed (encrypted) mails correctly
* Wed Oct 05 2011 - ldo@microdoc.de
 - Bug #20508 - NPE in OXJSONAccessImpl
* Thu Sep 29 2011 - ldo@microdoc.de
 - Bug #20392 - EAS Logins come with localhost IP address 
* Thu Sep 29 2011 - ldo@microdoc.de
 - Bug #20392 - EAS Logins come with localhost IP address 
* Thu Sep 22 2011 - ldo@microdoc.de
 - Bug #20085 - Temporary fix : ignoring client data on slow sync
* Thu Sep 22 2011 - ldo@microdoc.de
 - EAS: Bug #20387 - mail body not visible for certain mails on Android
* Wed Sep 21 2011 - ldo@microdoc.de
 - EAS: Bug #20252 - Original Email in Forward via EAS is empty
 - EAS: Bug #19517 - forwarded mails contain no body (at least on Android)
* Mon Sep 19 2011 - ldo@microdoc.de
 - Bug #20280 - Moving a subfolder tree of mailfolders with OLOX - added error code 13 when the folder does not exist on the server
* Fri Sep 16 2011 - ldo@microdoc.de
 - Bug #19662: OLOX2 doesn't handle S/MIME signed (encrypted) mails correctly
* Thu Sep 15 2011 - ldo@microdoc.de
 - Bug #20280 - Moving a subfolder tree of mailfolders with OLOX - added error code 13 when the folder does not exist on the server
* Mon Sep 12 2011 - ldo@microdoc.de
 - Added logging to investigate bug 20047
 - Added possibility to read leaf nodes in the OX user configuration
* Mon Aug 29 2011 - ldo@microdoc.de
 - Bug #20205 - Error code when creating folders with too long ids. Server folders with too long ids are removed from synchronization.
* Mon Aug 29 2011 - afe@microdoc.de
 - EAS: Bug #20108 - Fix for possible concurrent modification issue
* Fri Aug 26 2011 - ldo@microdoc.de
 - Bug #20085 - High CPU-load caused by SlowContentSyncer when syncing contact folder
* Thu Aug 25 2011 - ldo@microdoc.de
 - EAS: Bug #19946 - Mail subfolders not synced with Mail For Exchange 3.0 
* Wed Aug 24 2011 - ldo@microdoc.de
 - Bugfix #20164 - added unsorted array type
* Mon Aug 22 2011 - ldo@microdoc.de
 - Possible fix for bug 19946
* Fri Aug 12 2011 - ldo@microdoc.de
 - Bugfix #20086 - Before calling a JSONResult.get<Type>()-Method, check first the JSONResult's Type. 
* Fri Aug 12 2011 - choeger@open-xchange.com
 - Bugfix #20087 - [L3] Communication between USM and OX breaks down when
   com.openexchange.forceHTTPS=true
* Fri Aug 05 2011 - ldo@microdoc.de
 - Bugfix #20031 - USM does not interpret RemoteEvent with module EMAIL and folderId 1 correctly
* Thu Aug 04 2011 - ldo@microdoc.de
 - Code cleanup 
* Fri Jul 29 2011 - ldo@microdoc.de
 - Bugfix #19964 - Added logging of the OX Result where unexpected OX Result causes an error. 
* Fri Jul 29 2011 - ldo@microdoc.de
 - Refactoring: usage of DataobjectSet when possible instead of Array to avoid linear searches
* Thu Jul 28 2011 - afe@microdoc.de
 - EAS: Bug #19954 - Applied workaround for "birthday" of contacts also to "anniversary" of contacts
* Wed Jul 27 2011 - afe@microdoc.de
 - Bugfix #19962 - Adjusted OX-Event-Listener code to correctly handle new CommonEvents with email folder IDs instead of DataObjects as folder references
* Mon Jul 18 2011 - afe@microdoc.de
 - EAS: Bug #19552 - Added new value "email" to "com.openexchange.usm.eas.sync_all_folders" that synchronizes all email folders. This is also the new default setting  
* Fri Jul 15 2011 - ldo@microdoc.de
 - Bug #18013 - do not send modifications to client if only filtered out fields have been modified
* Thu Jul 14 2011 - afe@microdoc.de
 - Small internal performance optimization in JSON SyncCommandHandler
* Wed Jul 13 2011 - ldo@microdoc.de
 - Refactoring: usage of DataobjectSet when possible instead of Array to avoid linear searches
* Wed Jul 13 2011 - afe@microdoc.de
 - EAS: Bug #19696 - Enhanced error reporting to client if reading the mail source fails in the OX server
* Tue Jul 12 2011 - ldo@microdoc.de
 - Bug #18013: (reduce ping/pong) do not send recurrence_id to the client and empty delete_exceptions list (only when the delete_exceptions list has really been cleared)
* Tue Jul 12 2011 - afe@microdoc.de
 - EAS: Bugfix #19639 - Simultaneous sync of simulated meeting request and (filtered out) OX meeting request mail could cause the simulated request to be sent twice
* Tue Jul 12 2011 - afe@microdoc.de
 - Bug #18013: undo of delete_exceptions filtering: change_exceptions are reported as delete_exceptions if they are outside of the sync interval
* Fri Jul 08 2011 - afe@microdoc.de
 - Changed code to ensure UTF-8 for byte[]<->String conversions in test classes and logging of communication data
* Fri Jul 08 2011 - afe@microdoc.de
 - Bugfix #19517 - Correctly handle multipart mails when forwarding/replying to an email
* Wed Jul 06 2011 - ldo@microdoc.de
 - Bugfix #19523 - EAS: Removed emails remain in INBOX on phone (Android)
* Tue Jul 05 2011 - afe@microdoc.de
 - Bugfix #19689 - Fixed error reporting problem "Result from OX server is a String, expected String"
* Tue Jul 05 2011 - afe@microdoc.de
 - Bug #19693: Make sure that on a failed merge of create/delete the new sync state contains the same data as the old sync state
 - Bug #19693: Ensure that duplicate UUIDs sent from the client are detected at JSON protocol level
* Thu Jun 30 2011 - ldo@microdoc.de
 - Bugfix #19517 - EAS: forwarded mails on Android contain no body - possible fix
* Wed Jun 29 2011 - ldo@microdoc.de
 - Bugfix #19517 - EAS: forwarded mails on Android contain no body - possible fix
* Wed Jun 29 2011 - afe@microdoc.de
 - Bug #19638: Avoid infinite recursion when reporting an error for a merge of a delete/create sent from client
* Tue Jun 21 2011 - ldo@microdoc.de
 - Bugfix #19504 - Assistant Telephone field not synced correctly 
* Mon Jun 20 2011 - ldo@microdoc.de
 - Bugfix #19508 - [L3] NPE at com.openexchange.usm.datatypes.tasks.calendar.ParticipantIdentifier.equals(ParticipantIdentifier.java:155
* Fri Jun 10 2011 - ldo@microdoc.de
 - Bug #18760: duplicate app creation after deletion
* Fri Jun 10 2011 - ldo@microdoc.de
 - Bug #19445: added field "meting_update" and "task_update" to corresponding mails
* Thu Jun 09 2011 - ldo@microdoc.de
 - Bug #19446: extend configuration possibilities for synchronized fields (added "all_except")
* Wed Jun 08 2011 - ldo@microdoc.de
 - Bug #19444: add counter to USM response for object lists
* Tue Jun 07 2011 - afe@microdoc.de
 - USM/JSON: Do not send "delete_exceptions" for simple appointments
* Tue Jun 07 2011 - ldo@microdoc.de
 - Bugfix #19427: email folder name collision not detected
* Mon Jun 06 2011 - afe@microdoc.de
 - Removed unnecessary package requirements
* Mon May 30 2011 - afe@microdoc.de
 - Bugfix #19381 - Possible workaround for sending mail with encoded attachments in some java environments: Directly specifying DataSource instead of content
* Thu May 26 2011 - afe@microdoc.de
 - Added unique name "USM-OX-HttpConnectionCloser" to background thread that closes idle HTTP connections after their timeout has been reached 
* Thu May 26 2011 - afe@microdoc.de
 - Bugfix #18931 - OX-IDs were not correctly remapped when simultaneously moving multiple email folders combined with changes to those folders 
* Thu May 26 2011 - afe@microdoc.de
 - Bugfix #18174 - Added new ErrorStatusCode 12 (PARENT_FOLDER_NOT_FOUND) for failed folder creations where the parent is no longer accessible
* Wed May 25 2011 - afe@microdoc.de
 - Added PSF-files for use with SubVersive-plugin, added launch to start OX-server with USM
* Mon May 23 2011 - afe@microdoc.de
 - Bugfix #18616 - Make sure to report missing folders as individual errors for moveItems after a session hasn't been used for some time
* Mon May 16 2011 - afe@microdoc.de
 - Expanded sync test cases to also test for correct propagation of custom protocol information between sync states
* Mon May 16 2011 - afe@microdoc.de
 - Bugfix - EAS: Adjusted code that filters out OX invitation mails: Now the system no longer tries to read a freshly deleted invitation mail
* Mon May 16 2011 - afe@microdoc.de
 - Bugfix 19025 (partial): Fixed possible race condition on OX session renewal for multiple concurrent client requests in 1 USM session
* Thu May 12 2011 - afe@microdoc.de
 - Bugfix #19203 - EAS: Adjusted algorithm to ignore meeting-response-emails to allow for 1 text/plain attachment (note of appointment) and still ignore the email
 - Bugfix #19221 - EAS: USM checks now if a "Date"-header is present in mails sent by clients and automatically adds one if it is missing
* Wed May 11 2011 - choeger@open-xchange.com
 - Bugfix #19098 - No build number shown on server startup
* Tue May 10 2011 - afe@microdoc.de
 - Code cleanup & reformatting
* Fri May 06 2011 - afe@microdoc.de
 - Optimized code that checks if an OX folder is still available after an OX error is reported when reading the content of a folder
* Fri May 06 2011 - afe@microdoc.de
 - Optional behavior change for appointment deletions: delete->decline in private/public folder if participant and not organizer
 - Activated option in OLOX2, additionally declined appointments will be filtered (if not in a shared folder)
 - Confirmations will now be changed for the owner of a folder (instead of always the session user)
 - MeetingRequests are only sent if the participant status of the user has not been set
* Thu May 05 2011 - afe@microdoc.de
 - Bugfix #19144 - Limit "unlimited" sync (to start about 274000 BC) to avoid computation problem in OX for appointments and tasks
* Mon May 02 2011 - afe@microdoc.de
 - Bugfix #19090 - EAS: Search applied limit before filtering, causing too few items to be returned
* Mon May 02 2011 - afe@microdoc.de
 - Bugfix #18597 - Added new fields "yomiFirstName", "yomiLastName", "yomiCompany" to Contacts ContentType and to EAS and USM/JSON Contacts synchronization
* Tue Apr 26 2011 - afe@microdoc.de
 - Bugfix #18923 - Added new ErrorStatusCode 11 for failed PIM attachment creations to allow for better client dialogs due to OX server restrictions
 - Bugfix #18923 - Adjusted access methods, added security checks to PIMAttachment(s) objects
* Thu Apr 21 2011 - afe@microdoc.de
 - Bugfix #18966 - EAS: Prefix user name in shared folder titles, added configuration property com.openexchange.usm.eas.shared_folder_user_name_limit
* Wed Apr 20 2011 - afe@microdoc.de
 - Bugfix #18996 - Adjusted com.openexchange.usm.json.sync.timefilter_limit_past and com.openexchange.usm.json.sync.timefilter_limit_future: A value <= 0 now disables the limit
* Wed Apr 20 2011 - afe@microdoc.de
 - Enhanced error output for OX responses that couldn't be parsed or were of an unexpected type, now the expected type is also reported/logged
* Tue Apr 19 2011 - afe@microdoc.de
 - Bugfix #18589 - Provide "folder" parameter when retrieving all occurrences of a series to determine the occurrences that should be deleted
* Mon Apr 04 2011 - afe@microdoc.de
 - Bugfix #18831 - Added new parameter "refresh" to syncUpdate-command
* Thu Mar 31 2011 - afe@microdoc.de
 - Bugfix #18714 - EAS: Report folders as top level folders if they are within folders of a different type (to avoid problems with iPhone)
* Fri Mar 25 2011 - afe@microdoc.de
 - Bugfix #18707 - Changed error generation to provide OX error data in field "oxError"
* Fri Mar 25 2011 - afe@microdoc.de
 - Bugfix #18731 - Changed search for meeting_request appointment to only search default calendar folder instead of using all appointments of the user
* Wed Mar 23 2011 - afe@microdoc.de
 - Bugfix #18303 - Fixed problem in MimeMailBuilder: server locale was used for fallback generation of mail date headers (now english locale will be used)
* Tue Mar 22 2011 - afe@microdoc.de
 - Bugfix #18712 - EAS: Enhanced handling of "alarm" field to allow correct synchronization of public and shared calendar folders
* Tue Mar 22 2011 - afe@microdoc.de
 - Bugfix #18642 - EAS: Handle MeetingResponse(decline) differently to avoid deletion of appointments, no more special handling of deletions after decline required
* Mon Mar 21 2011 - afe@microdoc.de
 - Bugfix #18712 - EAS: Disabled synchronization of global address book as normal contacts folder
* Mon Mar 21 2011 - afe@microdoc.de
 - Bugfix #18714 - EAS: Ensure correct sorting of all folder changes when sent to the client
* Fri Mar 18 2011 - afe@microdoc.de
 - Bugfix #18324 (partial) - EAS: (currently disabled) First implementation of algorithm that simulates success for failed client updates (and restores original state in next sync)
* Thu Mar 17 2011 - afe@microdoc.de
 - Bugfix #18433 - Enhanced reporting of error status codes for individual object failures due to OX server problems (e.g. PIM attachment could not be retrieved)
* Thu Mar 17 2011 - afe@microdoc.de
 - Bugfix #18595 - USM now accepts empty mail creations from clients
* Thu Mar 17 2011 - afe@microdoc.de
 - Bugfix #18687 - Fixed problem with internal sync field if setConfiguration is called with "all" parameter
* Tue Mar 15 2011 - afe@microdoc.de
 - Bugfix #18176 - EAS: Disabled MeetingRequests for TouchWiz and plain Android (not HTC/Sense) devices
* Fri Mar 11 2011 - afe@microdoc.de
 - Bugfix #18494 - added new ResponseStatusCode 14 (unknown UID), adjusted setConfirmationStatusHandler accordingly, updated protocol version reported to client
* Fri Mar 11 2011 - afe@microdoc.de
 - Bugfix #18324 (partial) - EAS: For iPhone, all appointment have the own user as organizer to avoid special unwanted behavior in iPhone
* Wed Mar 09 2011 - afe@microdoc.de
 - Bugfix #18549 - EAS: filter illegal characters in mail body
* Wed Mar 09 2011 - afe@microdoc.de
 - Enabled "users" field for tasks synchronization
* Wed Mar 02 2011 - afe@microdoc.de
 - Added more information to error logging of moveItems commands that failed due to unknown SyncIDs
* Wed Mar 02 2011 - afe@microdoc.de
 - Bugfix #18495 - EAS: change OX configuration info of "modules/com.openexchange.usm.eas/module"
* Tue Mar 01 2011 - afe@microdoc.de
 - Added javax.activation to list of required packages of usm.json
* Mon Feb 28 2011 - afe@microdoc.de
 - Bugfix #18422 - Added new response code if a folder is no longer present in the OX server and a sync of the folder hierarchy should be performed, modified folder content-type to throw FolderNotFoundException if a folder cannot be read in the OX server
* Mon Feb 28 2011 - afe@microdoc.de
 - Bugfix #18467,18434 - Optimized internal structure of MimeMailBuilder, removed activation.jar from usm.json-bundle
* Fri Feb 25 2011 - afe@microdoc.de
 - Bugfix #18434 - MimeMailBuilder was too strict, some valid email structures could be rejected when sending an email
 - mail-1.4.2.jar (javax.mail) removed from usm.json-bundle to avoid class loader problems, javax.mail must now be provided by the system (and is by the OX common bundle)
* Fri Feb 25 2011 - afe@microdoc.de
 - Bugfix #18430 - To allow updates on existing mails with illegal mail addresses, the MimeMailBuilder now uses a simple composition algorithm as fallback
* Wed Feb 23 2011 - afe@microdoc.de
 - Bugfix #18420 - Added missing ChangeState modification for duplicate client creation of emails
 - Made MimeMailBuilder more tolerant to strange data sent by clients
* Mon Feb 21 2011 - afe@microdoc.de
 - Bugfix #18074 - Removed decoding of "image1_url" provided by the OX server when accessing URL to retrieve the contact image data
* Mon Feb 21 2011 - afe@microdoc.de
 - Bugfix #18390 - EAS: Allow MeetingRequest email from device to contain both a text/calendar and an application/ms-tnef attachment to be ignored (additional email will be sent by OX server)
* Thu Feb 17 2011 - afe@microdoc.de
 - Bugfix #18240 - EAS: Fixed typo in mail header mapping, streamlined mapping code
* Fri Feb 11 2011 - afe@microdoc.de
 - Bugfix #18215 - Switched order of "Responses" and "Comands" in the server response to a Sync-command
* Fri Feb 11 2011 - afe@microdoc.de
 - Bugfix #18185 - Executing a sync of the folder hierarchy in a new session before syncing groups and resources removed sync states for those special "folders"
* Fri Feb 11 2011 - afe@microdoc.de
 - Bugfix #18322 - Added new API method to allow for customized sync states to be retained in sync mechanism (instead of the one provided to the sync mechanism)
* Thu Feb 10 2011 - afe@microdoc.de
 - New property "com.openexchange.usm.eas.sync_all_folders" (experimental): synchronize complete OX folder hierarchy
 - Added code to allow for more customized folder hierarchy retrieval
* Wed Feb 09 2011 - afe@microdoc.de
 - Bug #18218 - EAS: treat empty notes and only-whitespace notes as equal to avoid OX updates on MeetingResponses
* Tue Feb 08 2011 - tse@microdoc.de
 - Bug #17355 - added code to the background cleanup task to check for the existence of table "USMSession" before operating on it
* Tue Feb 08 2011 - afe@microdoc.de
 - Bug #18185 - Added logging of SyncID changes for all sync commands
* Mon Feb 07 2011 - afe@microdoc.de
 - Bug #18050 - EAS: modified removal of time part sent by devices for birthdays to work correctly with dates before 1/1/1970
* Wed Feb 02 2011 - tse@microdoc.de
 - Bug #17225 - the folder owner information got lost when depositing objects in the USM cache; this resulted in unmodified UUIDs for elements in foreign shared folders
* Fri Jan 28 2011 - tse@microdoc.de
 - Bug #18160 - foreign folder titles sent by the client are now ignored
* Thu Jan 27 2011 - tse@microdoc.de
 - Bug #18160 - added check to avoid duplicate prefixing of shared foreign folders
* Wed Jan 26 2011 - afe@microdoc.de
 - Bug #16697 - EAS: cellular_phone1 and cellular_phone2 will be mapped to MobilePhoneNumber (first non-empty field is used) 
* Tue Jan 25 2011 - afe@microdoc.de
 - Bug #17770 - Added code to remove fake invitation mails if the appointment has been accepted in OX, adjusted algorithm for handling changes to attendee status
* Mon Jan 24 2011 - afe@microdoc.de
 - Bugfix #18027 - Added new property "com.openexchange.usm.eas.meeting_request_emulation_enabled" to allow switching back to old MeetingRequest behavior
* Fri Jan 21 2011 - afe@microdoc.de
 - Bug #17899 - change_exceptions could be reported as duplicate delete_exceptions
* Thu Jan 20 2011 - tse@microdoc.de
 - Bug #18001 - USM/JSON-call "setConfirmationStatus": parameterlist changed to sessionid, uid, confirmation, confirmmessage; tasks are no longer supported
* Thu Jan 20 2011 - tse@microdoc.de
 - Bugfix #17979 - MoveItemsHandler did not consider OX server errors
* Thu Jan 20 2011 - afe@microdoc.de
 - Bugfix #17947 - Adding a time value of 23:59:59 to the until-date reported to client devices to make sure last appointment at until date is included
* Wed Jan 19 2011 - afe@microdoc.de
 - Bug #17899 - change_exceptions and delete_exceptions are only used in appointments
* Tue Jan 18 2011 - tse@microdoc.de
 - Bugfix #17240 - For shared foreign folders, the folder owner's user name will be used as prefix for the folder name
* Tue Jan 18 2011 - afe@microdoc.de
 - Bug #17899 - change_exceptions outside the sync interval or not visible to the user are reported as delete_exceptions
* Mon Jan 17 2011 - tse@microdoc.de
 - Bugfix #17910 - When transforming a series into an appointment, the field "recurrence_type" will be sent to the OX server instead of the field "occurrences"
* Mon Jan 17 2011 - afe@microdoc.de
 - Bug #17999 - Added code that detects simultaneous deletion and creation of the same appointment (identified by the uid) by the client and merges them internally to a change
* Fri Jan 14 2011 - tse@microdoc.de
 - Bugfix #18001 - New USM/JSON-call "setConfirmationStatus" to confirm/decline appointments and tasks
* Thu Jan 13 2011 - afe@microdoc.de
 - Bug #17639 - Added new errorStatus for failed client operations to report missing permissions, also report complete object for failed client operations
 - Changed handling of failed folder deletions (will not be reported as temporary failure since the OX server also reports fatal errors in the same way)
* Wed Jan 12 2011 - afe@microdoc.de
 - Bugfix #17903 - element read rights will be checked before reading implicit server changes for creations, errors while reading implicit server changes will be ignored (logged at level debug)
* Tue Jan 11 2011 - afe@microdoc.de
 - Bugfix #16860 - Creations/changes of exceptions to series were executed without "ignore_conflicts" set, causing them to fail if they overlapped with another appointment
* Mon Jan 10 2011 - tse@microdoc.de
 - Bug #17916 - changed type of field "id" in ResourceContentType from Number to String
* Mon Jan 10 2011 - tse@microdoc.de
 - Bugfix #17940 - Fixed NullPointerException for unknown image formats
* Wed Jan 05 2011 - tse@microdoc.de
 - Bugfix #17881 - Accepted new appointments are now synced to the device as "added" instead of "changed"
* Thu Dec 16 2010 - tse@microdoc.de
 - Bugfix - When a re-login and re-try is performed because of an expired session, then the wrong sessionid had been used
* Thu Dec 16 2010 - afe@microdoc.de
 - Bugfix - new time frame filter for OLOX triggered bug: Unlimited number of mails in a limited time frame was not handled correctly (no mails were reported)
* Thu Dec 16 2010 - afe@microdoc.de
 - Bugfix - new caching system must remove cached server data if client operations are requested
* Thu Dec 16 2010 - afe@microdoc.de
 - Enhancement - Added new USM/JSON command locateObjects to determine parent folders of specified objects
* Tue Dec 14 2010 - afe@microdoc.de
 - Enhancement - added caching system for OX server data for repeated syncs on same folder, added 2 server config properties to configure caching system
* Fri Dec 10 2010 - afe@microdoc.de
 - Bugfix #17736 - Changed matching method for HTC/Sense to match a broader range, including HTC Desire HD
* Fri Dec 10 2010 - tse@microdoc.de
 - Bugfix #17745 - Introduced config properties "com.openexchange.usm.json.sync.timefilter_limit_past" and "com.openexchange.usm.json.sync.timefilter_limit_future" to filter appointments and mails by time
* Thu Dec 09 2010 - afe@microdoc.de
 - Bugfix #17516 - Workaround for Nokia bug: yearly all day series may have day_in_month set 1 day early if timezone is GMT+X, day_in_month is increased if timezone indicates that it is wrong
* Thu Dec 09 2010 - afe@microdoc.de
 - Small performance optimizations for MeetingRequests
* Wed Dec 08 2010 - afe@microdoc.de
 - Bugfix #17558 - Fix for time shifting on exceptions to all-day-series for Nokia devices
* Tue Dec 07 2010 - tse@microdoc.de
 - Bugfix #17564 - Adjusted MoveItemsHandler to produce an errorStatus 7 when unknown UUIDs create a non-fatal error
* Tue Dec 07 2010 - afe@microdoc.de
 - Bugfix - Fixed NPE in SyncML error recovery code
* Tue Dec 07 2010 - afe@microdoc.de
 - Added receive mechanism for multi-part sync messages from client
* Fri Nov 19 2010 - afe@microdoc.de
 - Bugfix #17592 - Consecutive EAS client creations could be accidentally detected as duplicate creations 
* Wed Nov 17 2010 - afe@microdoc.de
 - Bugfix #17564 - Adjusted MoveItemsHandler so that unknown UUIDs do not create fatal errors unless configuration option is set
* Tue Nov 16 2010 - afe@microdoc.de
 - Bugfix #17355 - Added copies of old UpdateTasks in new UpdateTaskV2 format with correct dependencies, updated CreateUSMTablesService
* Tue Nov 16 2010 - afe@microdoc.de
 - Bugfix #17534 - logout OX session if corresponding USM session is removed from memory
* Fri Nov 12 2010 - afe@microdoc.de
 - Bugfix #17495 - Return status code DATABASE_ERROR for USMSQLExceptions
* Mon Nov 08 2010 - afe@microdoc.de
 - Bugfix #17365 - Changed start and due date for tasks to use utc date (OX server can't handle time in those fields)
* Fri Nov 05 2010 - afe@microdoc.de
 - Bugfix #17404 - Changed code to determine which occurrence to delete on client deletes
* Wed Nov 03 2010 - afe@microdoc.de
 - Bugfix #17217 - Adjusted PreferencesItemServices & USM, now uses "active" instead of "module" to check user access rights
* Tue Nov 02 2010 - afe@microdoc.de
 - Bugfix #17366 - For server deletions, send DELETE instead of SOFTDELETE to fix problems in HTC/Sense clients
* Tue Nov 02 2010 - afe@microdoc.de
 - Bugfix #17401 - Added missing table "easUIDMapping" to background task implemented for enhancement #17127
* Tue Nov 02 2010 - afe@microdoc.de
 - Bugfix #16548 - recurrence_type: null value is treated as 0, 0 is default value
* Thu Oct 28 2010 - afe@microdoc.de
 - Bugfix #17369 - Changed Fetch sub command so that any truncation requested by the client is ignored
* Mon Oct 25 2010 - afe@microdoc.de
 - Bugfix #17270 - If no text/plain body is found, use text/html and convert to text/plain, if neither is present, report empty body
* Mon Oct 25 2010 - afe@microdoc.de
 - Bugfix #17220 - Changed EAS representation of weekly from daily with only 1 weekday selected to weekly (equal in EAS) to fix HTC Desire client problem
* Fri Oct 22 2010 - afe@microdoc.de
 - Bugfix #17327 - Added workaround for special required handling of deletion of "alarm" value in appointments
* Thu Oct 21 2010 - afe@microdoc.de
 - Bugfix #17321 - Activated new MeetingRequest algorithm for all devices except Nokia, added some fine-tuning to avoid problems with WinMob-devices
* Tue Oct 19 2010 - afe@microdoc.de
 - Changed logging of SyncML request and response content from INFO to DEBUG(FINE)
* Tue Oct 19 2010 - afe@microdoc.de
 - Moved logging of SyncML content from loglevel DEBUG to an external file
 - Added configuration property com.openexchange.usm.syncml.debug_log to specify external log file
 - Added debug logging of execution time and executed OX calls for SyncML
* Mon Oct 18 2010 - afe@microdoc.de
 - Bug #17257 - Added new config property "com.openexchange.usm.json.sync.fatal_uuid_errors" to treat uuid errors optionally as non-fatal (non-fatal is now default) 
* Mon Oct 18 2010 - afe@microdoc.de
 - Bugfix - Fix for bug #17150 introduced a possible NPE
* Thu Oct 14 2010 - afe@microdoc.de
 - Bugfix #17243 - Ignore(automatically remove) RECENT-flag in flags field for emails
* Thu Oct 14 2010 - afe@microdoc.de
 - Bugfix #17258 - Execute client deletes before creations, treat OX conflict reports on appointments no longer as temporary (reporting an error to the client instead of retrying the operation)
* Wed Oct 13 2010 - afe@microdoc.de
 - Updated modified UUID generation to only modify UUIDs for shared (type=shared) folders, leaving (common) original UUID intact for public folders
* Tue Oct 12 2010 - afe@microdoc.de
 - Bugfix #17192 - Abort complex changes to emails (sync error for that email) if the user hasn't enough rights to create and delete emails in the folder
* Tue Oct 12 2010 - afe@microdoc.de
 - Bugfix #17131 - Use new method provided by OX CommonEvent to determine all affected folders of all users for events sent from OX 
* Mon Oct 11 2010 - afe@microdoc.de
 - Bugfix #17226 - Added security checks to avoid NPE
* Mon Oct 11 2010 - afe@microdoc.de
 - Bugfix #17225 - Correctly store unmodified UUID for objects created in foreign folders
* Fri Oct 08 2010 - ldo@microdoc.de
 - Bugfix #17190 - task_request field added to new task emails
* Fri Oct 08 2010 - afe@microdoc.de
 - Bugfix #17181 - If an appointment is created by a client due to a meeting request, the automatic deletion of that appointment (since it's a duplicate to an already existing appointment) may not reported directly if the limit is set to 0
* Fri Oct 08 2010 - afe@microdoc.de
 - Bugfix #17190 - Added workaround for HTC/Sense-Android-Device to handle empty Categories lists sent from client device
* Fri Oct 08 2010 - afe@microdoc.de
 - Bugfix #17210 - Added mapping from "priority" to "Importance" to account for different ranges, send special email folder types for all non-IMEI-devices
* Thu Oct 07 2010 - afe@microdoc.de
 - Added workaround for HTC/Sense-Android-Device to avoid Exception in client code (which causes synchronization to fail)
* Thu Oct 07 2010 - ldo@microdoc.de
 - Bugfix #17150 - use modified UUIDs (uuid xor ox user id) for objects in not own folders
* Wed Oct 06 2010 - afe@microdoc.de
 - Bugfix #16866 - Modified behavior for fetch command on emails
 - Bugfix - Adjusted GetAttachments command to retrieve correct attachment information
* Mon Oct 04 2010 - ldo@microdoc.de
 - Bugfix #17092 - color_label should be updated in a separate update call when external mail fields are changed
* Mon Oct 04 2010 - ldo@microdoc.de
 - Bugfix #17100 - on conflict resolution USE_SERVER_DELETE_OVER_CHANGE server errors when trying to read the deleted mail should be ignored
* Fri Oct 01 2010 - ldo@microdoc.de
 - Bugfix #17047 - Confirmations for internal users should be made by using the confirm HTTP call
* Fri Oct 01 2010 - ldo@microdoc.de
 - Bugfix #17118 - Parent_uuid should be added to series exceptions only if the series is known to the client
* Fri Oct 01 2010 - afe@microdoc.de
 - Enhancement #17127 - persistent session data is automatically removed after a configurable time (default: 60 days) of inactivity
* Thu Sep 30 2010 - choeger@open-xchange.com
 - Bugfix #17084 - USM/EAS is installed, loaded but not available
* Thu Sep 30 2010 - ldo@microdoc.de
 - Bugfix #14654 - content of the generated invitation mail is the app. note
* Thu Sep 30 2010 - afe@microdoc.de
 - Bugfix #16892 - Added code to check for deletions outside of sync range (those will not be reported to the client device if it's not an iPhone)
* Wed Sep 29 2010 - afe@microdoc.de
 - Bugfix #17040 - Creation of an element with an UUID already in use now creates an error specific for the created object, the sync no longer fails completely
* Wed Sep 29 2010 - afe@microdoc.de
 - Bugfix #17077 - Added security checks to avoid NPE with incorrectly set recurrence_id field on client updates of series with exceptions
* Wed Sep 29 2010 - ldo@microdoc.de
 - Bugfix #14654 - invitation are sent just for the default calendar folder;  content of the generated invitation mail is the app. note
* Wed Sep 29 2010 - afe@microdoc.de
 - Bugfix #16839 - DB table structures used case-insensitive text columns, leading to problems with email folder IDs
* Tue Sep 28 2010 - ldo@microdoc.de
 - Bugfix #14654 - reactivated
* Mon Sep 27 2010 - afe@microdoc.de
 - Changed error handling so that more errors are reported for individual objects, not as a global error that causes the sync to fail completely
* Wed Sep 22 2010 - afe@microdoc.de
 - Bugfix #16816 - Added server config option to enable(default) or disable URL redirecting
* Wed Sep 22 2010 - ldo@microdoc.de
 - Change_exceptions and delete_exceptions should not be reported to client for Series Exceptions
* Wed Sep 22 2010 - afe@microdoc.de
 - Bugfix #16854 - Added code to adjust for bad command-sub-path sent by client
* Tue Sep 21 2010 - ldo@microdoc.de
 - Bug #16877 - initial sync of GAL very slow - optimization: do not make getAllAttachments call for every new contact
* Tue Sep 21 2010 - afe@microdoc.de
 - Bugfix #16871 - Correctly escape special characters in From-header of newly sent mail
* Wed Sep 15 2010 - ldo@microdoc.de
 - Bugfix #16864 - NPE in ContentSyncerSupport
* Mon Sep 13 2010 - ldo@microdoc.de
 - Bugfix #14654 - US 3364 - part 1 - send invitations just once, save the emails in db
* Fri Sep 10 2010 - ldo@microdoc.de
 - Bugfix #14654 - GlobalObjId in MeetingRequest and UID tags in Appointment contain the uid of the appointment
* Fri Sep 10 2010 - ldo@microdoc.de
 - Bugfix #16827 - missing usm and eas permissions are logged at info level.
* Fri Sep 10 2010 - ldo@microdoc.de
 - Bugfix #16842 - server response with error field and category 13 should not be treated as error
* Wed Sep 08 2010 - ldo@microdoc.de
 - Bugfix #16823 - contact details removed at the phone are not synchronized
* Tue Sep 07 2010 - ldo@microdoc.de
 - Bugfix #16817 - conflicts when many change exceptions are created as modification to the series
* Mon Sep 06 2010 - ldo@microdoc.de
 - Bugfix #16768 - duplicate attachment on creating change_exception from outlook
* Mon Sep 06 2010 - ldo@microdoc.de
 - Bugfix #16816 - incorrect server url reported when synchronizing with syncml
* Fri Sep 03 2010 - ldo@microdoc.de
 - Bugfix #16806 - new change_exception: error UUID already mapped
* Thu Sep 02 2010 - ldo@microdoc.de
 - Possible bug fix #16781
* Thu Sep 02 2010 - ldo@microdoc.de
 - Possible bug fix #16781(2)
* Tue Aug 31 2010 - ldo@microdoc.de
 - Bugfix #16779 - NPE when inserting attachments in sync result
* Mon Aug 30 2010 - ldo@microdoc.de
 - Bugfix #16752 - NPE when creating Series with Exceptions
* Thu Aug 26 2010 - afe@microdoc.de
 - Disabled ContentTypeTransferHandler tests to avoid strange build problem in SLES10/IBM-JDK environment
* Tue Aug 24 2010 - afe@microdoc.de
 - Adjustment due to bug #14948 - urldecode image url sent by OX server
* Tue Aug 24 2010 - afe@microdoc.de
 - Bugfix #16726 - Sorting enhancement used unsupported method in DataObjectSet
* Mon Aug 23 2010 - afe@microdoc.de
 - Added optional custom sorting of server changes (for use if not all changes should be reported at once)
 - Added custom sorting of server changes (for use if not all changes should be reported at once), newest elements first, contacts alphabetically by display_name
* Mon Aug 23 2010 - afe@microdoc.de
 - Added field "context_id" to server response of GetConfiguration-call
* Mon Aug 23 2010 - ldo@microdoc.de
 - Bugfix #16695 - Added field "parent_uuid" to appointment exception modifications
* Mon Aug 23 2010 - afe@microdoc.de
 - Added buddy class loading to USM session bundle to allow for deserialization of custom protocol classes
* Mon Aug 23 2010 - ldo@microdoc.de
 - Added new USM-JSON call invalidateObjects
* Thu Aug 19 2010 - afe@microdoc.de
 - Workaround bug #16566 - Use different algorithm for determining request URL
* Thu Aug 19 2010 - afe@microdoc.de
 - Bugfix #15526 - Added buddy registration in UUIDMappingImpl for com.openexchange.caching
* Thu Aug 19 2010 - afe@microdoc.de
 - Unified determination of special devices
* Wed Aug 18 2010 - ldo@microdoc.de
 - Possible Bugfix #16451(3) - Reset dates on reading AllDayEvent tag 
* Wed Aug 18 2010 - afe@microdoc.de
 - Bug #16566 - Added debug logging and message to client if MIME mail source can not be read
* Tue Aug 17 2010 - ldo@microdoc.de
 - special mail folders on OX server should be sent as normal mail folders to devices (eas
* Tue Aug 17 2010 - afe@microdoc.de
 - Bugfix #16621, 16674 - Different algorithm for TimeZone determination/matching, modify date/time from client to use 00:00:00 UTC time for all day appointments and birthdays
* Tue Aug 17 2010 - ldo@microdoc.de
 - Bugfix #16594 - change_exceptions should be added to the result only if the exceptions objects are know to the usm or the change_exceptions list is empty
* Mon Aug 16 2010 - afe@microdoc.de
 - Bugfix #16671 - Detect duplicate client creations based on provided client id
* Fri Aug 13 2010 - afe@microdoc.de
 - Added usm_syncml.properties file for configuration properties of the SyncML module
* Thu Aug 12 2010 - afe@microdoc.de
 - Bugfix - On reload of a bundle the old custom properties are from a different class loader and need to be reinitialized
* Thu Aug 12 2010 - afe@microdoc.de
 - Test for Bug 16676 - Extended DataObjectFilter to also allow filtering of result, added filter for email sizes and no. of attachments on PIM objects
* Thu Aug 12 2010 - afe@microdoc.de
 - Bugfix #16676 - Added size and attachment count filtering, added configuration parameters for json protocol
* Wed Aug 11 2010 - afe@microdoc.de
 - Added new configuration parameter com.openexchange.usm.json.sync.max_limit for USM/JSON-protocol
* Tue Aug 10 2010 - afe@microdoc.de
 - Bugfix #16659 - Session in memory not invalidated after deleted in DB, leads to DB errors when writing to other tables
* Tue Aug 10 2010 - afe@microdoc.de
 - Bugfix #14887 - Changed OX access code to follow redirects by hand instead of using now invalid HttpMethod option
* Wed Aug 04 2010 - afe@microdoc.de
 - Possible Bugfix #16451(2) - Reenabled timezone for whole-day appointments
* Tue Aug 03 2010 - ldo@microdoc.de
 - Bugfix #16636 - if MIMEdata option is set from client, server should send the MIME source for emails  
* Mon Aug 02 2010 - ldo@microdoc.de
 - Added usm and json version and build number to the login response
* Mon Aug 02 2010 - choeger@open-xchange.com
 - Bugfix #16619 - USM package contains unnecessary bundle
* Wed Jul 28 2010 - afe@microdoc.de
 - Bugfix #16552 - Timezone from client that can be parsed, but not matched to a standard Timezone will be mapped to GMT instead
* Tue Jul 27 2010 - ldo@microdoc.de
 - send immediate changes after client creation to all protocols except EAS
 - send commands tag only if commands are really present 
* Tue Jul 27 2010 - afe@microdoc.de
 - Bugfix #16551 - Client used UUID reserved for server generated UUIDs
* Mon Jul 26 2010 - afe@microdoc.de
 - Bugfix #16569 - Added more detailed error message if sync failed due to conflicts
* Mon Jul 26 2010 - afe@microdoc.de
 - Bugfix #16527 - DateReceived for emails was sent in wrong format to EAS clients, causing problems with MailForExchange
* Thu Jul 22 2010 - ldo@microdoc.de
 - Bugfix #16401 - Do not send deleted exceptions in the deleted list in case of series (main attribute) modification
* Fri Jul 16 2010 - ldo@microdoc.de
 - Bugfix #16469 - Send error info mail to the client when invalid mail found on server
* Thu Jul 15 2010 - ldo@microdoc.de
 - Bugfix #16489 - Interface must not send stack traces to any client.
* Wed Jul 14 2010 - ldo@microdoc.de
 - Bugfix #16487 - Appointment exceptions have new uuid on each change from outlook. Added methods for remapping ox id to new uuid.
* Tue Jul 13 2010 - ldo@microdoc.de
 - Bugfix #16336 - timezone with same rules from clients should not overwrite timezone on server
* Mon Jul 12 2010 - ldo@microdoc.de
 - Bugfix #16438 - filter out empty contacts from the synchronization on mobile devices
* Wed Jul 07 2010 - afe@microdoc.de
 - Possible Bugfix #16451 - timezone of whole-day appointments is always sent as GMT, whole-day appointments are sent as ending 23:59:59 earlier (i.e. a single day appointment lasts only 1 second)
* Tue Jul 06 2010 - afe@microdoc.de
 - USMJSONServlet allows extra data (after ";") after the content-type
 - resolveIDs: Added specific error for bad UUIDs, optimized object lookup
* Mon Jul 05 2010 - afe@microdoc.de
 - Bugfix #16304 - Made old storeSyncState method available (deprecated) in case different bundle versions are in use
* Mon Jul 05 2010 - afe@microdoc.de
 - Bugfix #16450 - Enabled bugfix #15567 for all devices, not only iPhone
* Fri Jul 02 2010 - ldo@microdoc.de
 - New command: Retrieve OX Ids
* Fri Jul 02 2010 - afe@microdoc.de
 - Bugfix #16304 - Enhanced storage mechanism to allow to make sure to keep last used sync state also for complex operations
* Fri Jul 02 2010 - afe@microdoc.de
 - Bugfix #16407 - If an error occurs while reading headers and attachment data of a mail, those fields are reported as if empty
* Wed Jun 30 2010 - ldo@microdoc.de
 - bugfix #16414 - "days" should not be set to default value 127 when not sent by server
* Wed Jun 30 2010 - afe@microdoc.de
 - Added extended debug logging for bug 16304
* Tue Jun 29 2010 - afe@microdoc.de
 - Bugfix #16300 - Various optimizations regarding PIM attachments handling, some other small optimizations
* Tue Jun 29 2010 - ldo@microdoc.de
 - Bugfix #16336 - On Delete send status SUCCESS if the object is not found
* Tue Jun 29 2010 - afe@microdoc.de
 - Changed StringDataType so that null and "" are treated as equal (internally storing null for efficiency)
* Tue Jun 29 2010 - afe@microdoc.de
 - Changed use of StringDataType: Use constant instead of new instantiation for efficiency
* Mon Jun 28 2010 - ldo@microdoc.de
 - Bugfix #16403 - error from server on creating attachments should be reported to client
* Fri Jun 25 2010 - ldo@microdoc.de
 - bugfix #16392 - Saving emails in Drafts not possible (syncUpdate)
* Fri Jun 25 2010 - afe@microdoc.de
 - Optimized matching of contacts, added more detailed weighting to fields
* Fri Jun 25 2010 - afe@microdoc.de
 - Bugfix #16356 - Decode HTML-encoded characters from original mail in SmartForward/SmartReply
* Thu Jun 24 2010 - ldo@microdoc.de
 - bugfix #16388 - Attachments reduplicate when moving an appointment from one folder into another
* Thu Jun 24 2010 - afe@microdoc.de
 - Added matching of contacts based on identical/similar fields for slow sync
* Wed Jun 23 2010 - ldo@microdoc.de
 - bugfix #16377 - upsynced Folder reported as "created" in Downsync
* Tue Jun 22 2010 - ldo@microdoc.de
 - when client creates appointment with existing uid, the creation should be transformed to modification, or the uid in the client object should be changed 
* Mon Jun 21 2010 - ldo@microdoc.de
 - Bugfix #13960 - get server default changes after client creation and report them as modification to the client
* Mon Jun 21 2010 - ldo@microdoc.de
 - Bugfix #16297 - when getting resources, return error to client when resource not reachable or the server returned error page
* Fri Jun 18 2010 - ldo@microdoc.de
 - Bugfix #16352 - Attachments on appointment exceptions are not created when the exception is new to the server
* Thu Jun 17 2010 - ldo@microdoc.de
 - Bugfix #16343 - HTML response from server should not be searched for json regex pattern.
* Tue Jun 15 2010 - choeger@open-xchange.com
 - Bugfix #16329 - Missing dependency check at USM leads to non-working
   ActiveSync when updating with expired OXAE license; added version dependency
   to open-xchange
* Mon Jun 14 2010 - ldo@microdoc.de
 - Bug 16312 - implemented new script to build eas separately from usm
* Mon Jun 14 2010 - ldo@microdoc.de
 - Bugfix #16230 - NPE on change_exception with no recurrence_id set
* Mon Jun 14 2010 - afe@microdoc.de
 - Bugfix #16300 - Improve performance of syncs with many new objects
* Thu Jun 10 2010 - afe@microdoc.de
 - Added debug-logging of USM-JSON-requests with used time and number of OX-calls,similar to logging for EAS 
* Thu Jun 10 2010 - afe@microdoc.de
 - Bugfix: error in deserialization prevented correct setting of UUID from cached data for old serialized states 
* Thu Jun 10 2010 - afe@microdoc.de
 - Optimized uuid cache further: instead of String a simplified UUID is used as a key (reducing the cache key data to 128 bit and avoiding String operations when generating the key)
* Thu Jun 10 2010 - afe@microdoc.de
 - Fixed possible NPE when deleting objects
* Tue Jun 08 2010 - ldo@microdoc.de
 - Bugfix #16274 - null should not be sent to the server for boolean data types
* Tue Jun 08 2010 - ldo@microdoc.de
 - 2 PimAttachments objects are equal if both have empty attachments list. 
* Mon Jun 07 2010 - ldo@microdoc.de
 - Bugfix #16265 - Invalid attachment data should result in error with status 8
* Fri Jun 04 2010 - ldo@microdoc.de
 - Bugfix #16243 - check if the new folder tree implementation is installed before initializing a json session. (config: /modules/folder/tree) 
* Wed Jun 02 2010 - ldo@microdoc.de
 - Bugfix #16197 - attachments for client PIM Objects which still doesn't exist on server should not be read from server
* Wed Jun 02 2010 - afe@microdoc.de
 - Bugfix #16197(2) - attachments for client PIM Objects which still don't exist on server should not be read from server
* Tue Jun 01 2010 - ldo@microdoc.de
 - Allow emails without content-type and body
* Mon May 31 2010 - ldo@microdoc.de
 - Bugfix #16225 - simple data type should use JSONObject.NULL instead of null 
* Fri May 28 2010 - ldo@microdoc.de
 - Bugfix #13960 - get server defeult changes after client creation and report them as modification to the client
* Fri May 28 2010 - afe@microdoc.de
 - Added code to prevent multiple wrapping of exceptions which hides details of the original error 
* Fri May 28 2010 - afe@microdoc.de
 - Bugfix #16219 - birthdays are transferred as numbers
* Thu May 27 2010 - afe@microdoc.de
 - Bug #16170 - Disabled added feature for bug #15965
* Thu May 27 2010 - ldo@microdoc.de
 - Stack Trace in error message on Internal Error 
* Thu May 27 2010 - afe@microdoc.de
 - Reactivated folder access check before content is read 
* Thu May 27 2010 - ldo@microdoc.de
 - Bugfix #15060 Disallow changes to appointments shortly after a meetingresponse was received.
* Wed May 26 2010 - ldo@microdoc.de
 - Bugfix #16192 - Users are read from the user interface instead of GAL
* Wed May 26 2010 - ldo@microdoc.de
 - Bugfix #16195 - NPE on deleting PIM Attachments
* Tue May 25 2010 - ldo@microdoc.de
 - Bugfix #16028 - When renaming/moving email folder the ids of its subfolders should also be changed 
* Tue May 25 2010 - afe@microdoc.de
 - Disabled folder access check before content is read 
* Fri May 21 2010 - afe@microdoc.de
 - Bugfix #15799 - add all headers containing date/time JSONobjects correctly to sent mail
* Thu May 20 2010 - afe@microdoc.de
 - Modified ErrorStatusCode computation to match OX implementation of permission flags
* Wed May 19 2010 - afe@microdoc.de
 - Bugfix #16143 - Unhandled exceptions are now always logged with their stacktrace, JSONObjects are logged in formatted format for severe errors (OX,DB,Internal) if no exception is available 
* Wed May 19 2010 - afe@microdoc.de
 - Bugfix #16144 - ID field of "Groups" ContentType was not of data type String as expected by the USM
 - Bugfix #15965(10) - If properties of a folder are changed, the USM marks this folder as "needs to be synchronized" (which is normally done automatically since OX sends an event for that folder)
 - Bugfix #16131 - Use String instead of OXObjectID for cache keys to avoid deserialization problems for distributed caches
* Tue May 18 2010 - afe@microdoc.de
 - Bugfix - sorting of folders with null ids created NPE
 - Optimized sorting of folders
* Tue May 18 2010 - afe@microdoc.de
 - Bugfix #16142 - Folder read permissions are now checked before the folder content is read
 - Bugfix #16143 - If an exception is encapsulated in a JSONObject, that JSONObject is logged as a formatted String to provide a readable stacktrace
 - Added exception class name and exception message (if any) to errorDetails object
* Mon May 17 2010 - afe@microdoc.de
 - Bugfix #16113 - Creating multiple mails leads to error
* Wed May 12 2010 - afe@microdoc.de
 - Bugfix - incomplete sync (more server updates available) caused folders to be marked as synchronized
* Tue May 11 2010 - afe@microdoc.de
 - Bug #16084 - Possible workaround: EAS doesn't send empty Attachments-Tag any more
* Mon May 10 2010 - ldo@microdoc.de
 - "errors" in MoveItems should be JSONObject
* Fri May 07 2010 - afe@microdoc.de
 - Bugfix: Fixed error caused by incomplete handling of MeetingRequests for appointments that are already deleted
* Thu May 06 2010 - ldo@microdoc.de
 - Bugfix #16052 - Exception on moving a mail folder - not able to update cache
* Thu May 06 2010 - afe@microdoc.de
 - Bugfix #15515 - EAS Client iPhone doesn't display iso-8859-1x encoded mail bodies correctly
* Wed May 05 2010 - ldo@microdoc.de
 - Bugfix #16034 - DataObject should be included in the error message
* Wed May 05 2010 - afe@microdoc.de
 - Simplified configuration retrieval by adding convenience method to USM Session
 - Added access check for usm json access (dummy implementation in ox preferences module for now)
* Wed May 05 2010 - ldo@microdoc.de
 - Bugfix #16032 - For Move "Create Object" rights should be available in the destination folder, not "Write/Modify" rights
* Tue May 04 2010 - ldo@microdoc.de
 - Bugfix #16029 - created_by field doesn't exist in mail objects
* Tue May 04 2010 - afe@microdoc.de
 - Bugfix #16002 - faster discovery of changes in usm/eas access rights of an user
* Mon May 03 2010 - ldo@microdoc.de
 - Bugfix #15989 - Exception on reporting immediate server modification to a client creation
* Fri Apr 30 2010 - afe@microdoc.de
 - Bugfix #16005 - Appointment exceptions are not synced if series is not known to user
* Thu Apr 29 2010 - ldo@microdoc.de
 - MoveItems returns 7 new Error Status Codes for each not moved object
* Thu Apr 29 2010 - ldo@microdoc.de
 - MeetingRequest: parent Folder can not be determined - get all appointments from the server, and search for the one in the meeting request
* Thu Apr 29 2010 - ldo@microdoc.de
 - Bugfix #15990 - Changes in Exception to Series Appointments should be reported to client
* Tue Apr 27 2010 - ldo@microdoc.de
 - MoveItems returns 4 new Response Status Codes: 13 - dest. doesn't exist, 14 - source doesn't exist, 15 - dest. no permiss., 16 - source no permiss.
* Tue Apr 27 2010 - ldo@microdoc.de
 - Bugfix #15890 - created mail folders should have the same uuid on the same syncid and different http-sessionid
* Mon Apr 26 2010 - ldo@microdoc.de
 - Bugfix #15567 - mails have wrong timestamp on iphone - local time instead of UTC sent in DateReceived
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15911 - "number_of_attachments" should not be sent to server because it is set automatically from server
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15925  - Errors in MoveItems command should contain uuid and the error JSONObject
* Thu Apr 22 2010 - ldo@microdoc.de
 - Bugfix #15909 - Create change and delete exceptions to series appointments in one update call 
* Wed Apr 21 2010 - ldo@microdoc.de
 - Distribution member list has display_name field instead of first_name and last_name
* Tue Apr 13 2010 - ldo@microdoc.de
 - Bugfix #15802 - parameter "force" used on saving emails in inbox
* Wed Apr 07 2010 - ldo@microdoc.de
 - Bugfix #15798 - All multipart message types should be supported 
* Tue Mar 30 2010 - ldo@microdoc.de
 - Meeting Request enabled 
* Mon Mar 29 2010 - ldo@microdoc.de
 - QoutedInternetAddress class from server is used to build addresses in the JSON to MIME conversion
* Thu Mar 25 2010 - ldo@microdoc.de
 - Bugfix #15676 ConfirmindParticipant should overwrite equals
* Wed Mar 24 2010 - ldo@microdoc.de
 - Bugfix #15560 mails marked as deleted as should be filtered out for the EAS protocol
* Wed Mar 24 2010 - ldo@microdoc.de
 - Bugfix #15661 - On rename of email folders from Client the new ID of the folder should be saved in the DB 
* Tue Mar 23 2010 - ldo@microdoc.de
 - Bugfix #15425 - Sending the Appointment Note as Body in a Meeting Request mail
* Tue Mar 23 2010 - ldo@microdoc.de
 - Bugfix #15425 - workaround activated just for iPhone
* Tue Mar 23 2010 - ldo@microdoc.de
 - Whole-day appointment exceptions should be sent in local time  
* Mon Mar 22 2010 - ldo@microdoc.de
 - When the user has no read rights on a folder, the sync system should set this folder as empty
* Fri Mar 19 2010 - ldo@microdoc.de
 - Distribution List Member UUID from client should be mapped to OX-id 
* Thu Mar 18 2010 - ldo@microdoc.de
 - Bugfix #15622 - Start/End time for Whole-day appointments should not be sent in UTC
* Thu Mar 18 2010 - ldo@microdoc.de
 - Usage of mail.mime.ContentType and mail.mime.ContentDisposition classes from server
* Thu Mar 18 2010 - ldo@microdoc.de
 - Distribution List Member should have a UUID 
* Wed Mar 17 2010 - ldo@microdoc.de
 - Bug #15608 - Error on editing Mails from Client - editing of 2 mails at once
* Tue Mar 16 2010 - ldo@microdoc.de
 - Bug #15613: Non-ASCII characters in Mail Subject show up on server as ?
* Tue Mar 16 2010 - ldo@microdoc.de
 - Bug #15609 - On moving Mails Inbox - Trash sync reports the email twice as deleted
* Mon Mar 15 2010 - ldo@microdoc.de
 - All mail headers received from Client should be sent to the server in the MIME-Mail
* Mon Mar 15 2010 - ldo@microdoc.de
 - Content-Type params should be a quoted String in case they contain empty spaces
* Mon Mar 15 2010 - ldo@microdoc.de
 - ContactDistributionMember doesn't always have user_id 
* Fri Mar 12 2010 - ldo@microdoc.de
 - Params for header "content-type" made optional
 - Address headers (as defined in Spez.) and simple headers: "thread-thopic", "thread-index", "importance" added
 - Text - Body (text/plain) should not be expected as Base64 encoded if "content-transfer-encoding": "base64" is not set
* Thu Mar 11 2010 - ldo@microdoc.de
 - On Status 4 (Internal Error) the StackTrace should be sent to the Client
* Wed Mar 10 2010 - ldo@microdoc.de
 - Occurrences (222) field in Tasks should be synchronized 
* Wed Mar 10 2010 - ldo@microdoc.de
 - PIMAttachments deletion: on delete is not always the lastModifiedOfNewestAttachmentUTC changed, but sometimes only the number_of_attachments field
 - PIMAttachments deletion: when all attachments are deleted on the server, the field lastModifiedOfAttachmentUTC is reset to null 
* Wed Mar 10 2010 - ldo@microdoc.de
 - SyncUpdate: creation of new mails in syncUpdate should be possible
* Tue Mar 09 2010 - ldo@microdoc.de
 - PingHandler: context_uuid should be handled differently as other folder-uuids
* Mon Mar 08 2010 - ldo@microdoc.de
 - EAS Mail Attachments - attachments should be sent in the Change result
* Tue Mar 02 2010 - ldo@microdoc.de
 - UUIDs for Emails - do not send random UUIDs if the Email has already been synchronized
* Mon Mar 01 2010 - ldo@microdoc.de
 - USM, EAS Preferences Item Service
* Mon Mar 01 2010 - afe@microdoc.de
 - Bugfix #15510: Fixed off-by-1 error in conversion of serialized data
* Mon Mar 01 2010 - ldo@microdoc.de
 - EAS Mail Attachments
* Fri Feb 26 2010 - ldo@microdoc.de
 - "All" option added to SetConfiguration command - Documentation
* Thu Feb 25 2010 - ldo@microdoc.de
 - Meeting Request disabled
* Thu Feb 25 2010 - ldo@microdoc.de
 - "All" option added to SetConfiguration command
* Wed Feb 24 2010 - ldo@microdoc.de
 - Index of Attachments field in Contacts should be calculated relatively to Image fields
* Tue Feb 23 2010 - ldo@microdoc.de
 - double usage of error codes removed
 - pim attachments and exceptions code can be skipped for groups and resources
* Tue Feb 23 2010 - ldo@microdoc.de
 - Elements of Content Type Dummy Folders should not be removed from cache on syncUpdate on the Folder Hierarchy
* Tue Feb 23 2010 - afe@microdoc.de
 - Changed MoveItemsHandler to report conflicts like SyncInit and SyncUpdate
* Tue Feb 23 2010 - ldo@microdoc.de
 - Added field "timezone" to Calendar
* Mon Feb 22 2010 - ldo@microdoc.de
 - use user's timezone - just for AllDay Events
* Fri Feb 19 2010 - ldo@microdoc.de
 - US4158: Use timezone=UTC parameter in all OX-Calls
* Thu Feb 18 2010 - ldo@microdoc.de
 - DataTypes for complex Objects should return a default value in case the JSON value is NULL
* Thu Feb 18 2010 - ldo@microdoc.de
 - JSON_API_Definition document changed
* Wed Feb 17 2010 - ldo@microdoc.de
 - allowed_modules parameter in all OX-folder-calls is created from the currently (in the current session) supported content types 
* Wed Feb 17 2010 - ldo@microdoc.de
 - Resources (read only) implementation
* Wed Feb 17 2010 - ldo@microdoc.de
 - For Unsupported Content Operations the error details should not contain a stacktrace
* Mon Feb 15 2010 - afe@microdoc.de
 - tree-parameter is no longer sent on OX-folder calls if the value is empty
* Fri Feb 12 2010 - ldo@microdoc.de
 - Meeting Request: send the folder uuid in the meeting_request object
* Fri Feb 12 2010 - ldo@microdoc.de
 - Groups and Resources (read only) implementation
* Fri Feb 12 2010 - afe@microdoc.de
 - Added new parameter allowed_modules to OX-folder-calls, disabled temporary OX-folder2-calls
* Thu Feb 11 2010 - ldo@microdoc.de
 - Added new fields to Appointments (uid, organizer, sequence, confirmations)
* Wed Feb 10 2010 - afe@microdoc.de
 - Fixed problem in TaskContentType compatibility code that prevented correct deserialization of all fields 
* Wed Feb 10 2010 - ldo@microdoc.de
 - Fixed problem in limiting the sync results which caused series to be sent without their exceptions and empty results when trying to send exceptions to unknown series
* Wed Feb 10 2010 - ldo@microdoc.de
 - PIM Attachments: attachments should not be requested from server when the "attachments" field is not set for synchronization
* Tue Feb 09 2010 - ldo@microdoc.de
 - PIM Attachments: removed the effect of false server modification on syncUpdate caused of wrong timestamp received on create and delete attachments 
* Mon Feb 08 2010 - ldo@microdoc.de
 - PIM Attachments: lastModifiedOfAttachments field available on server - made according changes
 - Meeting Requests: first implementation; meeting_request field is set on reading meeting request emails
* Mon Feb 08 2010 - ldo@microdoc.de
 - PIM Attachments for Appointment Exceptions
* Thu Feb 04 2010 - afe@microdoc.de
 - Modified parsing of limit parameter to allow for limit 0
* Thu Feb 04 2010 - ldo@microdoc.de
 - Repeated folder creation calls with same syncId should be ignored
* Wed Feb 03 2010 - ldo@microdoc.de
 - PIMAttachments handling
 - Refactored creating of appointment exceptions (too many sync states were saved) 
* Wed Feb 03 2010 - ldo@microdoc.de
 - JSON_API_Definition document changed: added PIM Attachments. 
* Tue Feb 02 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Mon Feb 01 2010 - afe@microdoc.de
 - Added parameters to OX login call to identify the USM, sub-protocol and session
* Mon Feb 01 2010 - afe@microdoc.de
 - Added check when reading which fields to synchronize from DB to avoid invalid fields due to changes in ContentTypes
* Mon Feb 01 2010 - afe@microdoc.de
 - Bugfix #15268: Added workaround for incomplete Nokia N900 (and possibly Android) authorization
* Fri Jan 29 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Fri Jan 29 2010 - afe@microdoc.de
 - Removed invalid tasks field 'project_id', added code that allows deserialization of old SyncState data
* Fri Jan 29 2010 - afe@microdoc.de
 - Fixed problem in contact-image-generation
* Fri Jan 29 2010 - ldo@microdoc.de
 - changed the json tests for tasks to fit the new tasks content type (field project_id removed)
* Thu Jan 28 2010 - afe@microdoc.de
 - Made TransferHandlers more tolerable regarding numbers sent from OX: Now also Strings that can be parsed to doubles are allowed
* Wed Jan 27 2010 - afe@microdoc.de
 - Bugfix #15270: Fixed SQL constraint error that could occur if too many new session were created at once
* Tue Jan 26 2010 - afe@microdoc.de
 - Enhanced automatic test client support classes
* Mon Jan 25 2010 - ldo@microdoc.de
 - PIMAttachments handling
* Tue Jan 19 2010 - afe@microdoc.de
 - Changed birthday field from date to number so that no conversion from/to user timezone for OX data is performed
 - Changed mapping for birthday field so that parsing of date is correctly performed
* Tue Jan 19 2010 - ldo@microdoc.de
 - Added methods for creating/retrieving/deleting PIM Attachments on the OX Server
* Tue Jan 19 2010 - ldo@microdoc.de
 - Bug #15142: workaround enabled for all devices except iPhone
* Mon Jan 18 2010 - ldo@microdoc.de
 - Bug #15142 - Previously created exception is reset when creating another exception on Nokia Devices
* Fri Jan 15 2010 - ldo@microdoc.de
 - Unsupported folders should not be returned in the ping result as changed.
* Fri Jan 15 2010 - ldo@microdoc.de
 - ping properties renamed
 - JSONArray method usage removed because it is not available in the OX json implementation
* Fri Jan 15 2010 - afe@microdoc.de
 - Extended deserialization mechanism to allow migration from old serialized data to current format
 - Added objects for PIM attachment management and basic fields for future communication with OX server
 - Streamlined code for ContentTypes by implementing common abstract base classes for ContentTypes and their service wrappers
* Thu Jan 14 2010 - ldo@microdoc.de
 - Ping Command Implementation
* Tue Jan 12 2010 - afe@microdoc.de
 - Added userid to response of login and getConfiguration commands, added JSON-API-specification documents to SVN repository
* Tue Jan 12 2010 - ldo@microdoc.de
 - Bug #15142 - Previously created exception is reset when creating another exception on Nokia Devices
* Tue Jan 12 2010 - ldo@microdoc.de
 - Bug #15157 - Contact field mapping switched for "E-Mail" fields
* Tue Jan 12 2010 - afe@microdoc.de
 - Bugfix: SendMail with multi-line From-Header caused request to be aborted
* Mon Jan 11 2010 - ldo@microdoc.de
 - Bug #15154 - New contacts are not synchronized to the server
* Fri Dec 18 2009 - ldo@microdoc.de
 - Deleting contact images
* Fri Dec 18 2009 - afe@microdoc.de
 - Changed behavior of MeetingRequest: Only sent if header "X-Open-Xchange-Type: New" is present and if user hasn't set his status yet
* Thu Dec 17 2009 - ldo@microdoc.de
 - Mails on slow sync - handle different conflict resolution scenarios for structured mail objects
* Wed Dec 16 2009 - afe@microdoc.de
 - Optimized some internal code
* Tue Dec 15 2009 - ldo@microdoc.de
 - When changing email body, first create the new email, and than delete the old one on the server
* Tue Dec 15 2009 - afe@microdoc.de
 - Optimized internal class for NestedMail-property storage
* Tue Dec 15 2009 - ldo@microdoc.de
 - Refactoring: changes as suggested from FindBugs
* Tue Dec 15 2009 - afe@microdoc.de
 - Bug #15072: Added workaround for WinMob problem with empty categories
* Tue Dec 15 2009 - ldo@microdoc.de
 - MimeMailBuilder should be able to convert messages with attachment as returned form OX Server
* Fri Dec 11 2009 - ldo@microdoc.de
 - Client should not be able to send objects in a Sync command from a folder different than the one currently synchronized  
* Fri Dec 11 2009 - ldo@microdoc.de
 - ConflictingChangeException should be thrown when OX returns error because of Edit Conflict
* Thu Dec 10 2009 - ldo@microdoc.de
 - Harddelete for Mails used in the USM_JSON
 - MoveItems should return Conflicting errors (as exception) in case of conflicts between client and server 
* Thu Dec 10 2009 - afe@microdoc.de
 - US3853: Added new version parameter and result to login command
* Wed Dec 09 2009 - afe@microdoc.de
 - Added new parameter ConflictResolution to sync-methods in Session API to optionally specify the ConflictResolution for a specific sync-call
* Wed Dec 09 2009 - ldo@microdoc.de
 - Send all Appointment Exceptions (change and delete) always and in both directions (Client to Server and Server to Client)
* Mon Dec 07 2009 - ldo@microdoc.de
 - Move Items implementation
* Fri Dec 04 2009 - ldo@microdoc.de
 - Added new method to MailContentType to delete email permanently from Server
* Fri Dec 04 2009 - afe@microdoc.de
 - Extended DB access and JMX interface so that now operations can be performed on all OX contexts (if 0 is provided as context)
* Fri Dec 04 2009 - afe@microdoc.de
 - Modified OX-access code so that resource URLs with parameters will now be correctly handled (not URL-encoded again).
* Wed Dec 02 2009 - afe@microdoc.de
 - Extended Session API (getParentFolder(), new TimestampMismatchException), added constant for "no limit on reported server changes"
 - Changed behavior of Incremental- and SlowContentSyncer: An error during server updates no longer aborts the sync, but is stored and reported back in the SyncResult. The Sync is completed successfully even if errors during updates occurred
 - Updated EAS methods to use modified SessionAPI
* Tue Dec 01 2009 - afe@microdoc.de
 - Added constant to Session API for no limit on SyncResult size
 - Added code to SlowContentSyncer and IncrementalContentSyncer to handle UUID matches and repeated creations from clients
* Fri Nov 27 2009 - afe@microdoc.de
 - Bugfix #14994: Changed Fetch-command so that now complete MIME body is returned regardless of MIMETruncation, and if no MIMESupport is enabled, the complete body is returned regardless of Truncation
* Thu Nov 26 2009 - ldo@microdoc.de
 - Configuration for the email fields which need to be synchronized 
* Thu Nov 26 2009 - ldo@microdoc.de
 - Retrieve the email as Structured JSON Object from server
* Wed Nov 25 2009 - afe@microdoc.de
 - Added code to session management and SlowContentSyncer to detect uuid conflicts for slow syncs
* Wed Nov 25 2009 - ldo@microdoc.de
 - Handling of Client mail creations as StructuredJSONMailObject
* Wed Nov 25 2009 - afe@microdoc.de
 - Bugfix #14983: Added missing tables to CreateTableService
* Tue Nov 24 2009 - afe@microdoc.de
 - Add start_date only for full_time appointment series, never add delete_exceptions on updates
* Tue Nov 24 2009 - afe@microdoc.de
 - Bug #14970: Workaround for WinMob crashes: Only write body tag for email if the body is not empty
* Tue Nov 24 2009 - afe@microdoc.de
 - UUID database storage activated
* Tue Nov 24 2009 - afe@microdoc.de
 - Fixed problem where picture data was not sent on server updates for contacts
* Mon Nov 23 2009 - afe@microdoc.de
 - Added temporary workaround for Bug #14952 to avoid NPE in OX server code
* Fri Nov 20 2009 - ldo@microdoc.de
 - Exception from Series - creating, modifying and deleting from the JSON API 
* Fri Nov 20 2009 - afe@microdoc.de
 - Removed unnecessary recurrence_id for appointment calls to the OX server 
* Fri Nov 20 2009 - ldo@microdoc.de
 - Comparator for Folder Hierarchy 
* Thu Nov 19 2009 - afe@microdoc.de
 - Fixed problem in unnecessary field removal which caused too many fields to be removed for new exceptions
* Thu Nov 19 2009 - afe@microdoc.de
 - Fixed problem with client changes on series exceptions that were moved to a different date
* Thu Nov 19 2009 - afe@microdoc.de
 - Added workaround for endless yearly series (clients may automatically limit until-times that the server sent)
* Wed Nov 18 2009 - afe@microdoc.de
 - Added new field 316 (standard_folder_type) to FolderContentType
* Wed Nov 18 2009 - afe@microdoc.de
 - Removed unnecessary request body fields for updates on appointment series
* Wed Nov 18 2009 - afe@microdoc.de
 - Added UpdateTask with version 93 that clears all cache tables
* Tue Nov 17 2009 - ldo@microdoc.de
 - workaround : remove all exceptions which do not have recurrence_date_position in order to avoid sending illegal data to devices
* Tue Nov 17 2009 - choeger@open-xchange.com
 - Bugfix #14882:  USM svn revision not shown in logfile
* Tue Nov 17 2009 - afe@microdoc.de
 - Removed package reference to com.openexchange.push in the EventListener
* Tue Nov 17 2009 - afe@microdoc.de
 - Changed OXJSONAccessImpl: HTTP redirects for OX access (up to 10 levels) are followed, an INFO message is logged every 5 minutes as long as redirects are active
* Mon Nov 16 2009 - afe@microdoc.de
 - Bugfix #14639 - Added optional authentication for OPTIONS command
* Mon Nov 16 2009 - afe@microdoc.de
 - Bugfix #14854: Modified OXEventListener so that delete events that do not use DataObjects do not cause ClassCastExceptions
* Mon Nov 16 2009 - afe@microdoc.de
 - Changed Headers data type so that correct JSONArray of Strings is generated for headers with multiple values
* Mon Nov 16 2009 - ibr@microdoc.de
 - Bugfix #14853: set explicitly the WBXML codepage (the namespace) in CategoriesOperationXmlType to avoid the exception by implicitly change of codepage with multiple possibilities
* Fri Nov 13 2009 - afe@microdoc.de
 - Added getContextUUID() method to USM Session API
* Thu Nov 12 2009 - afe@microdoc.de
 - Modified deserialization error handling: Errors are caught at low level and bad sync states are reported as not available
* Thu Nov 12 2009 - ibr@microdoc.de
 - Change the class Header for multiple headers from Map<String, String> to Map<String, String[]>, change tests
* Thu Nov 12 2009 - ibr@microdoc.de
 - Change  NestedMail for filename field, from Map<ContentTypeField, Object> to Map<String, Object>
* Wed Nov 11 2009 - ldo@microdoc.de
 - Bugfix #14644 - Remove deprecated fields (links 591)
* Tue Nov 10 2009 - ldo@microdoc.de
 - Virtual folders - Folder.Tree persistent session field; tree parameter in all OX requests to the folder module 
* Tue Nov 10 2009 - afe@microdoc.de
 - Added JMX interface for SessionManager that allows monitoring the active sessions and monitoring/changing configuration parameters and persistent session properties 
* Tue Nov 10 2009 - afe@microdoc.de
 - Added simple logging of EAS session activity (first and last access time) in the database
 - Added session-specific debug logging to standard log mechanism (can be enabled via the session JMX interface)
* Tue Nov 10 2009 - ldo@microdoc.de
 - Bugfix #14644 - Remove deprecated fields (number_of_links  103; after_complete   304)
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated fetch test
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated send email test
* Thu Nov 05 2009 - ldo@microdoc.de
 - Automated tests 
* Thu Nov 05 2009 - ldo@microdoc.de
 - Bugfix #13979 - Appointment participants are always added as external participants
* Wed Nov 04 2009 - afe@microdoc.de
 - Added projects for release-packages and automated test classes
* Wed Nov 04 2009 - ldo@microdoc.de
 - Automated delete test
* Tue Nov 03 2009 - ibr@microdoc.de
 - Change by MailContentTypeTransferHandlerImpl: method getMailAttachment
* Tue Nov 03 2009 - ldo@microdoc.de
 - Delete objects from UUID mapping table on receiving delete event from the OX server
* Fri Oct 30 2009 - ldo@microdoc.de
 - Added update task for the tables used in UUID management
* Thu Oct 29 2009 - afe@microdoc.de
 - Added configuration property com.openexchange.usm.eas.meeting_request_enabled
 - Disabled persistent storage of EAS UID fields in the DB
* Wed Oct 28 2009 - afe@microdoc.de
 - Bugfix #14729 - Modified USMOXDeleteListener so that no DeleteFailedException is thrown if USM tables do not exist
* Mon Oct 26 2009 - afe@microdoc.de
 - Bugfix #14663 - Sync for series with exceptions could fail because wrong time filter was used when determining all occurrences of the series (only temporary workaround for now)
* Fri Oct 23 2009 - afe@microdoc.de
 - Added new Exception for deserialization errors to improve logged information in case DB inconsistency occurs
* Tue Oct 20 2009 - afe@microdoc.de
 - Bugfix #14680 - large appointment body causes invalid "BodySize" tag to be written (only valid for Mail and Tasks)
* Mon Oct 19 2009 - afe@microdoc.de
 - Added code to enable sync system to read in sync states from DB in old format (in case the UpdateTask was not executed) 
* Fri Oct 16 2009 - ldo@microdoc.de
 - bug fix 14661 - "days" should not be set for yearly appointment 
* Wed Oct 14 2009 - afe@microdoc.de
 - Added code to make sure HttpStatus 401 is returned if authentication fails
* Tue Oct 13 2009 - afe@microdoc.de
 - Added method to DataType to check for default value
* Fri Oct 09 2009 - afe@microdoc.de
 - Added UpdateTask that completely empties all USM cache tables (required for changed cache storage with UUIDs)
* Thu Oct 08 2009 - afe@microdoc.de
 - Modified UUID mapping and test to allow global UUIDs
* Thu Oct 08 2009 - afe@microdoc.de
 - Modified EAS code to work with global UUID mapping
* Wed Oct 07 2009 - afe@microdoc.de
 - Added new FolderNotFoundException that is thrown if a given folderid can not be mapped to an OX folder
 - Added findFolder method to Session
 - Changed limit to generate DB map entry for long folder ids to allow 20 character OX object IDs without extra mapping 
* Wed Oct 07 2009 - afe@microdoc.de
 - Added methods to Session interface to allow UUID mapping, added simple test implementation for uuid mapping
* Tue Oct 06 2009 - ldo@microdoc.de
 - Parameter view = "text" set when getting email as forward/reply
* Tue Oct 06 2009 - ldo@microdoc.de
 - bug fix 14564
* Mon Oct 05 2009 - afe@microdoc.de
 - Split internal OX access API login method into login and getConfiguration 
* Tue Sep 29 2009 - afe@microdoc.de
 - Added Session API method that returns view of persistent fields
* Mon Sep 28 2009 - afe@microdoc.de
 - Bugfix #14589, #14575: Fixed hashCode()/equals() problem with ContentTypes on J9 JVMs
* Mon Sep 28 2009 - afe@microdoc.de
 - Bugfix #14598: Changed X-header USM version to match that of OX head
 - Bugfix #14598: Changed X-header EAS version to match that of OX head
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14575: Added code to ensure that content type filters are always set and no NPE is thrown
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14569: Improved conversion from/to binary timezone structure, added fallback to simple TimeZone if conversion is not possible
* Fri Sep 25 2009 - afe@microdoc.de
 - Bugfix #14573: Modified UpdateTask to correctly work with partially installed sequences
* Wed Sep 23 2009 - afe@microdoc.de
 - Bugfix #14552: Removed unnecessary debug logging of a stacktrace in case an EAS device does not send all required parameters
* Tue Sep 22 2009 - ldo@microdoc.de
 - end synchronization on logout in USM JSON API
* Tue Sep 22 2009 - ldo@microdoc.de
 - end synchronization on logout in USM JSON API - remove session from internal storage
* Mon Sep 21 2009 - afe@microdoc.de
 - Bugfix #14469: Workaround for internal error on WinMob-devices for mails with empty subject
* Fri Sep 18 2009 - afe@microdoc.de
 - Enhancement: Added possibility to limit the number of mails in a folder for a sync
 - Enhancement: Added property "com.openexchange.usm.eas.mail.limit" to limit mails in folder for sync
 - Bugfix: Fixed possible NPE for simultaneous client and server deletion
* Thu Sep 17 2009 - ldo@microdoc.de
 - Error handling in the USM-JSON API
* Wed Sep 16 2009 - afe@microdoc.de
 - Bugfix #14522: Fixed typo in SQL query in USMDeleteListener, ensured correct usage of contextid
* Tue Sep 15 2009 - afe@microdoc.de
 - Bugfix #14509: Possible NPE on changes in calendar entries
* Thu Sep 10 2009 - afe@microdoc.de
 - Added regularly updates of persistent data from DB in case an external change occurs
* Thu Sep 10 2009 - afe@microdoc.de
 - General code cleanup of some internal EAS classes
* Wed Sep 09 2009 - afe@microdoc.de
 - Bugfix #14480: Categories for exceptions in series were not generated correctly
* Tue Sep 08 2009 - afe@microdoc.de
 - Merged USM- and EAS-ChangeLog into global ChangeLog
* Mon Sep 07 2009 - afe@microdoc.de
 - Added new config property "com.openexchange.usm.eas.mail.time_limit" that imposes an extra limit for mail synchronization (default value: 3 days)
* Mon Sep 07 2009 - afe@microdoc.de
 - Bugfix #14459: minimized usage time of SQL connection by rearranging code, using read-only connections where possible
* Fri Sep 04 2009 - afe@microdoc.de
 - Bugfix #14448: USM/EAS now always explicitly sets the From:-header when sending an email (overwriting any From:-header specified by the device)
* Thu Sep 03 2009 - ldo@microdoc.de
 - Set the right timestamp when deleting more than one exception 
* Wed Sep 02 2009 - ldo@microdoc.de
 - "days" field should always be sent when updating series
* Wed Sep 02 2009 - ldo@microdoc.de
 - Added relevant fields in appointment which change causes exceptions to be deleted
* Tue Sep 01 2009 - ldo@microdoc.de
 - Bugfix #14416: Nokia: Private flag gets overwritten  
* Tue Sep 01 2009 - ldo@microdoc.de
- Bugfix #14366: Changes on series exceptions are not synchronized   
* Tue Sep 01 2009 - afe@microdoc.de
 - Fixed typo in API method name
* Tue Sep 01 2009 - afe@microdoc.de
 - Fixed typo in API method name
* Tue Sep 01 2009 - choeger@open-xchange.com
 - Bugfix #14408: Changelog is not contained /usr/share/doc/open-xchange-usm
* Mon Aug 31 2009 - afeo@microdoc.de
 - modified new log message to report commands without an USM session or OX calls 
* Fri Aug 28 2009 - ldo@microdoc.de
 - change the time of a series with exceptions should be sent to clients as delete + add  
* Fri Aug 28 2009 - ldo@microdoc.de
 - added special log message for request duration time 
* Fri Aug 28 2009 - afe@microdoc.de
 - Modified the Session-API so that also empty custom SyncStates can be stored (but only syncStates for FolderContent)
* Fri Aug 28 2009 - afe@microdoc.de
 - Added code to collect per-session statistics on how much time is spent in how many OX-calls
* Tue Aug 25 2009 - afe@microdoc.de
 - Changed access check code and default values to reflect new properties as discussed by mail
* Tue Aug 25 2009 - ldo@microdoc.de
 - Bugfix #14371: Ending the series on iPhone when trying to make a change "for all future" occurrences
* Tue Aug 25 2009 - afe@microdoc.de
 - Changed access check code of USM/EAS to use new properties as discussed by mail
* Tue Aug 25 2009 - ldo@microdoc.de
 - Bugfix #14371: Ending the series on iPhone when trying to make a change "for all future" occurrences
* Mon Aug 24 2009 - ldo@microdoc.de
 - Bugfix #14366: We are using the Exception ID for updating exceptions, and not the Master ID
* Mon Aug 24 2009 - ldo@microdoc.de
 - Bugfix #14369: Mapping of BusyStatus corrected
* Fri Aug 21 2009 - afe@microdoc.de
 - Bugfix #14355: Removed optional DayOfWeek parameter for daily series
* Thu Aug 20 2009 - afe@microdoc.de
 - Added new Session API method to allow protocols to store custom sync states if synchronization can only be partially completed
* Thu Aug 20 2009 - ldo@microdoc.de
 - Bugfix #14220: old exceptions should be removed from the response when they are deleted as a result of changint the start time of the series.
* Thu Aug 20 2009 - afe@microdoc.de
 - Bugfix #14191: Added automatic addition of display name to From:-header if only simple email address is present when sending an email
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized
* Wed Aug 19 2009 - afe@microdoc.de
 - Reenabled MeetingRequests due to unresolved problems
 - Added specialized warning log message that is generated instead of default error
   if an I/O error occurs while sending the result of a command to the device (indicating a problem in the device or the network)
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized - deletion of single appointments
* Wed Aug 19 2009 - afe@microdoc.de
 - Bugfix #13999: Suppress invitation emails from iPhone and WinMob devices when creating an appointment
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized
* Wed Aug 19 2009 - afe@microdoc.de
 - Bugfix #14278: using all/list request combo for mail synchronization with timeframe instead of single large all request
* Wed Aug 19 2009 - ldo@microdoc.de
 - Bugfix #14275: Modification of series appointment structure is not synchronized - deletion of single appointments
* Tue Aug 18 2009 - afe@microdoc.de
 - USM ChangeLog created
* Tue Aug 18 2009 - afe@microdoc.de
 - Moved configuration properties for EAS into a new properties file (eas.properties), added new file to build system
 - Changed stand-alone ConfigurationManager so that it reads in all files (*.properties) in the config folder,
   reporting warnings if a property is set multiple times
* Tue Aug 18 2009 - afe@microdoc.de
 - EAS ChangeLog created
* Tue Aug 18 2009 - afe@microdoc.de
 - Completely disabled generation of MeetingRequests
* Wed Jul 01 2009 - choeger@open-xchange.com
 - Bugfix #14041: Debian package contains to many USM bundles
