/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.ox.html.impl;

import java.util.List;

import org.apache.commons.logging.Log;
import org.osgi.service.component.ComponentContext;

import com.openexchange.html.HTMLService;
import com.openexchange.html.Range;
import com.openexchange.usm.journal.Journal;

/**
 * Internal implementation of HTMLService, to be able to start USM locally without running OX Server. 
 * 
 * TODO Please implement other methods if they should be used in usm code. 
 * @author ldo
 *
 */
public class OXHTMLServiceImpl implements HTMLService {

	private Log _journal;

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void activate(ComponentContext context) {
		Journal journal = (Journal) context.locateService(Journal.class.getName());
		_journal = journal.getLog(HTMLService.class);
		_journal.info("USM Mock-up for OX HTML service activated");
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void deactivate(ComponentContext context) {
		_journal.info("USM Mock-up for OX HTML service deactivated");
		_journal = null;
	}

	public String checkBaseTag(String htmlContent, boolean externalImagesAllowed) {
		// TODO Auto-generated method stub
		return null;
	}

	public String dropScriptTagsInHeader(String htmlContent) {
		// TODO Auto-generated method stub
		return null;
	}

	public String filterExternalImages(String htmlContent, boolean[] modified) {
		// TODO Auto-generated method stub
		return null;
	}

	public String filterWhitelist(String htmlContent, String configName) {
		// TODO Auto-generated method stub
		return null;
	}

	public String filterWhitelist(String htmlContent) {
		// TODO Auto-generated method stub
		return null;
	}

	public String formatHrefLinks(String content) {
		// TODO Auto-generated method stub
		return null;
	}

	public String formatURLs(String content, List<Range> links) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getConformHTML(String htmlContent, String charset, boolean replaceUrls) {
		// TODO Auto-generated method stub
		return null;
	}

	public String getConformHTML(String htmlContent, String charset) {
		// TODO Auto-generated method stub
		return null;
	}

	public Character getHTMLEntity(String entity) {
		// TODO Auto-generated method stub
		return null;
	}

	public String html2text(String htmlContent, boolean appendHref) {
		// returns the original content
		return htmlContent;
	}

	public String htmlFormat(String plainText, boolean withQuote, List<Range> ignoreRanges) {
		// TODO Auto-generated method stub
		return null;
	}

	public String htmlFormat(String plainText, boolean withQuote) {
		// TODO Auto-generated method stub
		return null;
	}

	public String htmlFormat(String plainText) {
		// TODO Auto-generated method stub
		return null;
	}

	public String prettyPrint(String htmlContent) {
		// TODO Auto-generated method stub
		return null;
	}

	public String replaceHTMLEntities(String content) {
		// TODO Auto-generated method stub
		return null;
	}

	public String replaceImages(String content, String sessionId) {
		// TODO Auto-generated method stub
		return null;
	}

}
