/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm;

import java.io.*;
import java.sql.*;

import com.openexchange.usm.util.Toolkit;

/**
 * Simple program that can be used to create the HSQL DB tables from scratch using the definitions in the
 * various sub-projects.
 * 
 * @author afe
 *
 */
public class CreateDBTables {
	private static final String BASE_DIR = "..";
	private static final String DB_PATH = BASE_DIR + "/com.openexchange.usm/db";
	private static final String DB_NAME = "hsqldb";
	private static final String DB_EXTENDED_NAME = "hsqldb.";

	/**
	 * @param args
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception {
		deleteAllDBFiles();
		Connection con = connectToDB();
		Statement statement = null;
		try {
			statement = con.createStatement();
			createAllDBTables(statement, (args.length > 0) ? args[0] : "HSQL");
			statement.executeUpdate("shutdown");
		} finally {
			Toolkit.close(statement);
			Toolkit.close(con);
		}
	}

	private static void createAllDBTables(Statement statement, String suffix) throws IOException, SQLException {
		final String realSuffix = "_" + suffix + ".sql";
		final File baseDir = new File(BASE_DIR);
		for (File f : baseDir.listFiles(new FileFilter() {
			public boolean accept(File file) {
				return file.isDirectory() && baseDir.equals(file.getParentFile());
			}
		})) {
			for (File entry : f.listFiles(new FileFilter() {
				public boolean accept(File file) {
					return file.isFile() && file.getName().endsWith(realSuffix);
				}
			})) {
				System.out.println(entry.getCanonicalPath());
				BufferedReader reader = new BufferedReader(new FileReader(entry));
				try {
					for (String line = reader.readLine(); line != null; line = reader.readLine()) {
						System.out.println("   " + line);
						if (line.trim().length() > 0)
							statement.executeUpdate(line);
					}
				} finally {
					Toolkit.close(reader);
				}
			}
		}
	}

	private static Connection connectToDB() throws ClassNotFoundException, SQLException {
		Class.forName("org.hsqldb.jdbcDriver");
		return DriverManager.getConnection("jdbc:hsqldb:file:" + DB_PATH + '/' + DB_NAME, "sa", "");
	}

	private static void deleteAllDBFiles() throws Exception {
		for (File f : new File(DB_PATH).listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return name.startsWith(DB_EXTENDED_NAME);
			}
		})) {
			if (!f.delete())
				throw new Exception("Can't delete old DB file " + f.getCanonicalPath()
						+ ", maybe some program is still accessing it");
		}
	}
}
