/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

import java.io.*;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;

import com.openexchange.usm.syncml.SyncMLConstants;
import com.openexchange.usm.syncml.servlet.WbxmlTransformer;
import com.openexchange.usm.util.Toolkit;

public class SyncMLTestClient {

	//	private static final String _commandContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SyncML xmlns='SYNCML:SYNCML1.0'>"
	//			+ "<SyncHdr><VerDTD>1.0</VerDTD><VerProto>SyncML/1.0</VerProto><SessionID>25</SessionID><MsgID>1</MsgID><Target><LocURI>http://localhost:8080/usm-syncml</LocURI></Target><Source><LocURI>354957030735479</LocURI><LocName>test</LocName></Source><Meta><MaxMsgSize xmlns='syncml:metinf'>20000</MaxMsgSize></Meta></SyncHdr>"
	//			+ "<SyncBody><Put><CmdID>1</CmdID><Meta><Type xmlns='syncml:metinf'>application/vnd.syncml-devinf+xml</Type></Meta><Item><Source><LocURI>./devinf10</LocURI></Source><Data><DevInf xmlns='syncml:devinf'><VerDTD>1.0</VerDTD><Man>Synthesis AG</Man><Mod>SySync Client PocketPC STD</Mod><OEM>Synthesis AG</OEM><FwV>Android/2.1-update1</FwV><SwV>3.4.0.6</SwV><HwV>Android Nexus One</HwV><DevID>354957030735479</DevID><DevTyp>pda</DevTyp><DataStore><SourceRef>./contacts</SourceRef><DisplayName>contacts</DisplayName><MaxGUIDSize>64</MaxGUIDSize><Rx-Pref><CTType>text/vcard</CTType><VerCT>3.0</VerCT></Rx-Pref><Rx><CTType>text/x-vcard</CTType><VerCT>2.1</VerCT></Rx><Tx-Pref><CTType>text/vcard</CTType><VerCT>3.0</VerCT></Tx-Pref><Tx><CTType>text/x-vcard</CTType><VerCT>2.1</VerCT></Tx><SyncCap><SyncType>1</SyncType><SyncType>2</SyncType><SyncType>3</SyncType><SyncType>4</SyncType><SyncType>6</SyncType><SyncType>7</SyncType></SyncCap></DataStore><CTCap><CTType>text/vcard</CTType><PropName>BEGIN</PropName><ValEnum>VCARD</ValEnum><PropName>END</PropName><ValEnum>VCARD</ValEnum><PropName>VERSION</PropName><ValEnum>3.0</ValEnum><PropName>REV</PropName><PropName>N</PropName><PropName>FN</PropName><PropName>NICKNAME</PropName><PropName>CATEGORIES</PropName><PropName>ORG</PropName><PropName>TITLE</PropName><PropName>TEL</PropName><ParamName>TYPE</ParamName><ValEnum>HOME</ValEnum><ValEnum>WORK</ValEnum><ValEnum>VOICE</ValEnum><ValEnum>CELL</ValEnum><ValEnum>FAX</ValEnum><ValEnum>PAGER</ValEnum><ValEnum>PREF</ValEnum><PropName>EMAIL</PropName><ParamName>TYPE</ParamName><ValEnum>HOME</ValEnum><ValEnum>WORK</ValEnum><ValEnum>INTERNET</ValEnum><PropName>URL</PropName><ParamName>TYPE</ParamName><ValEnum>HOME</ValEnum><ValEnum>WORK</ValEnum><ValEnum>PREF</ValEnum><PropName>ADR</PropName><ParamName>TYPE</ParamName><ValEnum>HOME</ValEnum><ValEnum>WORK</ValEnum><PropName>BDAY</PropName><PropName>NOTE</PropName><PropName>PHOTO</PropName><CTType>text/x-vcard</CTType><PropName>BEGIN</PropName><ValEnum>VCARD</ValEnum><PropName>END</PropName><ValEnum>VCARD</ValEnum><PropName>VERSION</PropName><ValEnum>2.1</ValEnum><PropName>REV</PropName><PropName>N</PropName><PropName>FN</PropName><PropName>CATEGORIES</PropName><PropName>ORG</PropName><PropName>TITLE</PropName><PropName>TEL</PropName><ParamName>HOME</ParamName><ParamName>WORK</ParamName><ParamName>VOICE</ParamName><ParamName>CELL</ParamName><ParamName>FAX</ParamName><ParamName>PAGER</ParamName><ParamName>PREF</ParamName><PropName>EMAIL</PropName><ParamName>HOME</ParamName><ParamName>WORK</ParamName><ParamName>INTERNET</ParamName><PropName>URL</PropName><ParamName>HOME</ParamName><ParamName>WORK</ParamName><ParamName>PREF</ParamName><PropName>ADR</PropName><ParamName>HOME</ParamName><ParamName>WORK</ParamName><PropName>BDAY</PropName><PropName>NOTE</PropName><PropName>PHOTO</PropName></CTCap></DevInf></Data></Item></Put><Get><CmdID>2</CmdID><Meta><Type xmlns='syncml:metinf'>application/vnd.syncml-devinf+xml</Type></Meta><Item><Target><LocURI>./devinf10</LocURI></Target></Item></Get><Alert><CmdID>3</CmdID><Data>201</Data><Item><Target><LocURI>contacts</LocURI></Target><Source><LocURI>./contacts</LocURI></Source><Meta><Anchor xmlns='syncml:metinf'><Next>20100504T084226Z</Next></Anchor></Meta></Item></Alert><Final/></SyncBody></SyncML>";

	/**
	 * @param args
	 */

	public static final void main(String[] args) throws Exception {
		//		System.out.println(new String(Base64.encodeBase64("user3:secret".getBytes("UTF-8")), "UTF-8"));
		HttpClient httpclient = new HttpClient();

		for (File f : new File(".").listFiles()) {
			if (f.isFile() && f.getName().endsWith(".syncml"))
				performCall(httpclient, f);
		}
	}

	private static void performCall(HttpClient httpclient, File testFile) throws HttpException, IOException {
		PostMethod httppost = new PostMethod("http://localhost:8080/usm-syncml");
		FileInputStream input = new FileInputStream(testFile);
		try {
			//		ByteArrayInputStream input = new ByteArrayInputStream(_commandContents.getBytes());
			//		httppost.setRequestBody(input);
			InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(input);
			httppost.setRequestEntity(requestEntity);

			httppost.setRequestHeader(new Header("Content-Type", "application/vnd.syncml-xml; charset=\"utf-8\""));

			System.out.println("executing request " + testFile.getName() + " at " + httppost.getURI());

			int statusCode = httpclient.executeMethod(httppost);
			System.out.println("statusCode= " + statusCode);
			//InputStream s = httppost.getResponseBodyAsStream();
			byte[] data = httppost.getResponseBody();
			String xml = new String(data, SyncMLConstants.UTF_8);
			try {
				System.out.println(new WbxmlTransformer().formatXml(xml));
			} catch (Exception e) {
				System.out.println(xml);
			}
			System.out.println("----------------------------------------");
		} finally {
			Toolkit.close(input);
		}
	}
}
