/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.test;

import com.openexchange.usm.syncml.servlet.HexDumper;
import com.openexchange.usm.syncml.servlet.WbxmlTransformer;

public class RequestHistoryPrinter {

	public static byte[] convertHexStringToByteArray(String string) {
		byte[] result = new byte[string.length() >> 1];
		for (int i = 0; i < result.length; i++)
			result[i] = (byte) Integer.parseInt(string.substring(i << 1, (i + 1) << 1), 16);
		return result;
	}

	public static void main(String[] args) throws Exception {
		RequestHistoryPrinter p = new RequestHistoryPrinter();
		//		p.parseDevInf(DevInfComparison.DEV_INFOS);
		p.parse(NokiaN95_Funambol_initial.REQUESTS);
		//		p.parse(Motorola_Funambol.REQUESTS);
		//		p.parse(NokiaN95_1.REQUESTS);
		//		p.parse(NokiaN95_2.REQUESTS);

		//		p.parse(NokiaN95_Funambol.REQUESTS_1);
		//		p.parse(NokiaN95_Funambol.REQUESTS_2);
		//		p.parse(NokiaN95_Funambol.REQUESTS_3);

		//		p.parse(NokiaN95_Funambol.COMPARE);

		//		p.parse(Motorola.REQUESTS);
		//		p.parse(Motorola.REQUESTS_2);

		//		p.parse(Motorola_Funambol.REQUESTS);
		//		p.parse(Motorola_Funambol.REQUESTS_1);
		//		p.parse(Motorola_Funambol.REQUESTS_2);
		//		p.parse(Motorola_Funambol.REQUESTS_3);

	}

	private void parse(String[][] requests) throws Exception {
		WbxmlTransformer transformer = new WbxmlTransformer();
		for (String[] part : requests) {
			if (part[0] != null && part[1] != null) {
				System.out.println(part[0]);
				System.out.println("------------");
				printData(transformer, part[1]);
				System.out.println("------------");
			} else {
				System.out.println("No request, probably response to previous ping request");
				System.out.println("------------");
			}
			if (part[2] != null)
				printData(transformer, part[2]);
			else
				System.out.println("Missing or bad response, no http content encountered");
			System.out.println("------------");
		}
	}

	private void printData(WbxmlTransformer transformer, String part) {
		byte[] data = convertHexStringToByteArray(part);
		try {
			System.out.println(transformer.transformSyncMLWbxmlToXml(data));
		} catch (Exception e) {
			System.out.println(HexDumper.toString(data));
		}
	}

	@SuppressWarnings("unused")
	private void parseDevInf(String[] data) throws Exception {
		WbxmlTransformer transformer = new WbxmlTransformer();
		for (String info : data) {
			byte[] bd = convertHexStringToByteArray(info);
			try {
				System.out.println(transformer.transformSyncMLDevInfWbxmlToXml(bd));
			} catch (Exception e) {
				System.out.println(HexDumper.toString(bd));
			}
			System.out.println("------------");
		}
	}
}
