package com.openexchange.usm.syncml.servlet;

import java.io.*;
import java.security.Principal;
import java.util.*;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.*;

import org.apache.commons.logging.Log;

import com.openexchange.usm.syncml.SyncMLConstants;

/**
 * Special HttpServletRequest that completely reads in the request data and dumps it to
 * the provided DebugWriters. The request data is internally stored and later presented
 * as if they were retrieved from the original HttpServletRequest.
 * 
 * @author afe
 *
 */
public class DebugServletRequest implements HttpServletRequest {
	private final UUID _requestUUID = UUID.randomUUID();

	private final HttpServletRequest _delegate;

	private final ServletInputStream _inputStream;

	public DebugServletRequest(Log log, HttpServletRequest delegate, boolean isWbxml, DebugWriter... writers)
			throws IOException {
		_delegate = delegate;
		ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
		byte[] buffer = new byte[4096];
		InputStream input = delegate.getInputStream();
		for (int c = input.read(buffer); c >= 0; c = input.read(buffer))
			bufferStream.write(buffer, 0, c);
		buffer = bufferStream.toByteArray();
		String data = null;
		try {
			if (isWbxml)
				data = new WbxmlTransformer().transformSyncMLWbxmlToXml(buffer);
			else
				data = new String(buffer, SyncMLConstants.UTF_8);
		} catch (Exception e) {
			data = "No valid XML. HexDump:\n" + HexDumper.toString(buffer);
		}
		for (DebugWriter writer : writers) {
			if (writer != null)
				writer.log(_requestUUID + " --- POST: " + "(" + delegate.getRemoteAddr() + ") " + " ---\n" + data);
		}
		final ByteArrayInputStream bufferInput = new ByteArrayInputStream(buffer);
		_inputStream = new ServletInputStream() {
			@Override
			public int read() throws IOException {
				return bufferInput.read();
			}
		};
	}

	public UUID getRequestUUID() {
		return _requestUUID;
	}

	public Object getAttribute(String arg0) {
		return _delegate.getAttribute(arg0);
	}

	@SuppressWarnings("unchecked")
	public Enumeration getAttributeNames() {
		return _delegate.getAttributeNames();
	}

	public String getAuthType() {
		return _delegate.getAuthType();
	}

	public String getCharacterEncoding() {
		return _delegate.getCharacterEncoding();
	}

	public int getContentLength() {
		return _delegate.getContentLength();
	}

	public String getContentType() {
		return _delegate.getContentType();
	}

	public String getContextPath() {
		return _delegate.getContextPath();
	}

	public Cookie[] getCookies() {
		return _delegate.getCookies();
	}

	public long getDateHeader(String arg0) {
		return _delegate.getDateHeader(arg0);
	}

	public String getHeader(String arg0) {
		return _delegate.getHeader(arg0);
	}

	@SuppressWarnings("unchecked")
	public Enumeration getHeaderNames() {
		return _delegate.getHeaderNames();
	}

	@SuppressWarnings("unchecked")
	public Enumeration getHeaders(String arg0) {
		return _delegate.getHeaders(arg0);
	}

	public ServletInputStream getInputStream() throws IOException {
		return _inputStream;
	}

	public int getIntHeader(String arg0) {
		return _delegate.getIntHeader(arg0);
	}

	public String getLocalAddr() {
		return _delegate.getLocalAddr();
	}

	public Locale getLocale() {
		return _delegate.getLocale();
	}

	@SuppressWarnings("unchecked")
	public Enumeration getLocales() {
		return _delegate.getLocales();
	}

	public String getLocalName() {
		return _delegate.getLocalName();
	}

	public int getLocalPort() {
		return _delegate.getLocalPort();
	}

	public String getMethod() {
		return _delegate.getMethod();
	}

	public String getParameter(String arg0) {
		return _delegate.getParameter(arg0);
	}

	@SuppressWarnings("unchecked")
	public Map getParameterMap() {
		return _delegate.getParameterMap();
	}

	@SuppressWarnings("unchecked")
	public Enumeration getParameterNames() {
		return _delegate.getParameterNames();
	}

	public String[] getParameterValues(String arg0) {
		return _delegate.getParameterValues(arg0);
	}

	public String getPathInfo() {
		return _delegate.getPathInfo();
	}

	public String getPathTranslated() {
		return _delegate.getPathTranslated();
	}

	public String getProtocol() {
		return _delegate.getProtocol();
	}

	public String getQueryString() {
		return _delegate.getQueryString();
	}

	public BufferedReader getReader() throws IOException {
		return _delegate.getReader();
	}

	@SuppressWarnings("deprecation")
	public String getRealPath(String arg0) {
		return _delegate.getRealPath(arg0);
	}

	public String getRemoteAddr() {
		return _delegate.getRemoteAddr();
	}

	public String getRemoteHost() {
		return _delegate.getRemoteHost();
	}

	public int getRemotePort() {
		return _delegate.getRemotePort();
	}

	public String getRemoteUser() {
		return _delegate.getRemoteUser();
	}

	public RequestDispatcher getRequestDispatcher(String arg0) {
		return _delegate.getRequestDispatcher(arg0);
	}

	public String getRequestedSessionId() {
		return _delegate.getRequestedSessionId();
	}

	public String getRequestURI() {
		return _delegate.getRequestURI();
	}

	public StringBuffer getRequestURL() {
		return _delegate.getRequestURL();
	}

	public String getScheme() {
		return _delegate.getScheme();
	}

	public String getServerName() {
		return _delegate.getServerName();
	}

	public int getServerPort() {
		return _delegate.getServerPort();
	}

	public String getServletPath() {
		return _delegate.getServletPath();
	}

	public HttpSession getSession() {
		return _delegate.getSession();
	}

	public HttpSession getSession(boolean arg0) {
		return _delegate.getSession(arg0);
	}

	public Principal getUserPrincipal() {
		return _delegate.getUserPrincipal();
	}

	public boolean isRequestedSessionIdFromCookie() {
		return _delegate.isRequestedSessionIdFromCookie();
	}

	@SuppressWarnings("deprecation")
	public boolean isRequestedSessionIdFromUrl() {
		return _delegate.isRequestedSessionIdFromUrl();
	}

	public boolean isRequestedSessionIdFromURL() {
		return _delegate.isRequestedSessionIdFromURL();
	}

	public boolean isRequestedSessionIdValid() {
		return _delegate.isRequestedSessionIdValid();
	}

	public boolean isSecure() {
		return _delegate.isSecure();
	}

	public boolean isUserInRole(String arg0) {
		return _delegate.isUserInRole(arg0);
	}

	public void removeAttribute(String arg0) {
		_delegate.removeAttribute(arg0);
	}

	public void setAttribute(String arg0, Object arg1) {
		_delegate.setAttribute(arg0, arg1);
	}

	public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
		_delegate.setCharacterEncoding(arg0);
	}
}
