/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.mapping.vcard;

import java.util.ArrayList;
import java.util.List;

import com.openexchange.usm.api.session.DataObject;

public class OrgMapping extends FieldMapping {

	public OrgMapping(String prop, String... oxFields) {
		super(prop, null, null, oxFields);
	}

	@Override
	public Object storeInDataObject(VCardEntry entry, DataObject dataObject, Object object) {
		String[] values = entry.getData();
		dataObject.setFieldContent(_oxFields[0], (values.length > 0) ? values[0] : "");
		dataObject.setFieldContent(_oxFields[1], buildBranches(values));
		dataObject.setFieldContent(_oxFields[2], (values.length > 1) ? values[values.length - 1] : "");
		return null;
	}

	private String buildBranches(String[] values) {
		int len = values.length;
		if (len < 3)
			return "";
		StringBuilder sb = new StringBuilder(128);
		for (int i = 1; i < len - 1; i++) {
			if (i > 1)
				sb.append(',');
			sb.append(values[i]);
		}
		return sb.toString();
	}

	@Override
	public void addToVCard(DataObject object, List<VCardEntry> vcard) {
		List<String> data = new ArrayList<String>();
		data.add(buildStringData(object.getFieldContent(_oxFields[0])));
		for (String s : buildStringData(object.getFieldContent(_oxFields[1])).split(","))
			data.add(s);
		data.add(buildStringData(object.getFieldContent(_oxFields[2])));
		addToVCard(vcard, data);
	}
}
