/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements.xml;

import java.io.IOException;

import org.kxml2.wap.Wbxml;
import org.kxml2.wap.WbxmlParser;
import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.parser.XmlPullParserUtil;

public abstract class XMLPart {

	public static XMLPart readXMLPart(XmlPullParser parser) throws XmlPullParserException, IOException {
		String tag = parser.getName();
		// Skip whitespace, but do not use common utility method, but equivalent that uses nextToken() instead of next()
		parser.nextToken();
		int eventType = parser.getEventType();
		while (eventType == XmlPullParser.TEXT && parser.isWhitespace()) { // skip whitespace
			if (parser.getText().trim().length() > 0)
				break;
			eventType = parser.nextToken();
		}
		switch (eventType) {
			case XmlPullParser.START_TAG:
				ComposedXMLPart result = new ComposedXMLPart(tag, null);
				for (;;) {
					result.add(readXMLPart(parser));
					XmlPullParserUtil.skipWhitespace(parser);
					if (XmlPullParserUtil.isAtEndTag(parser, tag)) {
						XmlPullParserUtil.parseEndTag(parser, tag);
						return result;
					}
				}
			case XmlPullParser.END_TAG:
				XmlPullParserUtil.parseEndTag(parser, tag);
				return new SimpleXMLPart(tag, null, "");
			case XmlPullParser.TEXT:
				String text = parser.getText();
				parser.next();
				XmlPullParserUtil.parseEndTag(parser, tag);
				return new SimpleXMLPart(tag, null, text);
			case Wbxml.EXT_I_0:
				if (parser instanceof WbxmlParser) {
					WbxmlParser p2 = (WbxmlParser) parser;
					if (p2.getWapCode() == Wbxml.OPAQUE) {
						Object o = p2.getWapExtensionData();
						if (o instanceof byte[]) {
							String data = new String((byte[]) o, "UTF-8");
							parser.next();
							XmlPullParserUtil.parseEndTag(parser, tag);
							return new SimpleXMLPart(tag, null, data);
						}
					}
				}
				// Fall through to error
			default:
				throw new XmlPullParserException("Invalid SyncML Meta structure, encountered event type "
						+ parser.getEventType());
		}
	}

	protected final String _tag;
	protected final String _ns;

	protected XMLPart(String tag, String ns) {
		_tag = tag;
		_ns = ns;
	}

	public void write(XmlSerializer serializer) throws IOException {
		serializer.startTag(_ns, _tag);
		writeContent(serializer);
		serializer.endTag(_ns, _tag);
	}

	public String getTag() {
		return _tag;
	}

	public String getNamespace() {
		return _ns;
	}

	@Override
	public String toString() {
		return toString(0);
	}

	protected String getIndent(int indent) {
		StringBuilder sb = new StringBuilder(indent << 1);
		for (int i = 0; i < indent; i++)
			sb.append(' ').append(' ');
		return sb.toString();
	}

	protected String toString(int indent) {
		return getIndent(indent) + '<' + _tag + '>' + getContentForToString(indent) + "</" + _tag + ">\n";
	}

	protected abstract String getContentForToString(int indent);

	public abstract String getXMLData(int pos, String... hierarchy);

	public abstract XMLPart getSubPart(String name);

	public abstract String getValue();

	protected abstract void writeContent(XmlSerializer serializer) throws IOException;
}
