/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.XmlSerializer;

public class ComposedXMLPart extends XMLPart {

	private final List<XMLPart> _subParts = new ArrayList<XMLPart>();

	public ComposedXMLPart(String tag, String ns) {
		super(tag, ns);
	}

	@Override
	protected void writeContent(XmlSerializer serializer) throws IOException {
		for (XMLPart part : _subParts)
			part.write(serializer);
	}

	public List<XMLPart> getSubParts() {
		return _subParts;
	}

	public void add(XMLPart part) {
		_subParts.add(part);
	}

	@Override
	public String getXMLData(int pos, String... hierarchy) {
		if (hierarchy != null && hierarchy.length > pos && _tag.equals(hierarchy[pos])) {
			for (XMLPart part : _subParts) {
				String s = part.getXMLData(pos + 1, hierarchy);
				if (s != null)
					return s;
			}
		}
		return null;
	}

	public void addXMLData(String value, String... hierarchy) {
		ComposedXMLPart current = this;
		for (int i = 0; i < hierarchy.length - 1; i++)
			current = current.getOrAddSubPart(hierarchy[i]);
		current.add(new SimpleXMLPart(hierarchy[hierarchy.length - 1], null, value));
	}

	@Override
	public XMLPart getSubPart(String name) {
		for (XMLPart part : _subParts) {
			if (part.getTag().equals(name))
				return part;
		}
		return null;
	}

	@Override
	public String getValue() {
		return null;
	}

	private ComposedXMLPart getOrAddSubPart(String name) {
		XMLPart part = getSubPart(name);
		if (part instanceof ComposedXMLPart)
			return (ComposedXMLPart) part;
		ComposedXMLPart newPart = new ComposedXMLPart(name, null);
		add(newPart);
		return newPart;
	}

	@Override
	protected String getContentForToString(int indent) {
		if (_subParts.isEmpty())
			return "";
		StringBuilder sb = new StringBuilder("\n");
		for (XMLPart part : _subParts)
			sb.append(part.toString(indent + 1));
		return sb.append(getIndent(indent)).toString();
	}
}
