/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.elements;

import java.io.IOException;
import java.util.*;

import org.xmlpull.v1.*;

import com.openexchange.usm.syncml.elements.xml.XMLPart;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;

public class Meta extends BaseElement {
	public static final String ELEMENT_NAME = "Meta";

	private final List<XMLPart> _content = new ArrayList<XMLPart>();

	public Meta(XMLPart part) {
		_content.add(part);
	}

	public Meta(XMLPart part, XMLPart... parts) {
		_content.add(part);
		for (XMLPart p : parts)
			_content.add(p);
	}

	public Meta(Collection<XMLPart> parts) {
		_content.addAll(parts);
	}

	public Meta(XmlPullParser parser) throws XmlPullParserException, IOException {
		readElementStart(parser);
		XmlPullParserUtil.skipWhitespace(parser);
		while (XmlPullParser.START_TAG == parser.getEventType()) {
			_content.add(XMLPart.readXMLPart(parser));
			XmlPullParserUtil.skipWhitespace(parser);
		}
		readElementEnd(parser);
	}

	public String getElementName() {
		return ELEMENT_NAME;
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		for (XMLPart m : _content)
			m.write(serializer);
	}

	public List<XMLPart> getContent() {
		return _content;
	}

	/**
	 * Convenience method to access stored text in the XML hierarchy. It will return the first text that
	 * is stored in the specified hierarchy. At each depth, the first matching XML tag is used to follow
	 * the hierarchy path. If the specified path can not be followed or if no text is stored for that path
	 * (i.e. only more XML tags), this method returns null.
	 * 
	 * @param hierarchy
	 * @return
	 */
	public String getXMLData(String... hierarchy) {
		for (XMLPart part : _content) {
			String s = part.getXMLData(0, hierarchy);
			if (s != null)
				return s;
		}
		return null;
	}
}
