/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.util.List;

import com.openexchange.usm.syncml.elements.SyncMLElement;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.servlet.SyncMLRequest;

/**
 * TODO Add access methods unique for SyncML (top-level?) commands
 * 
 * @author afe
 *
 */
public interface SyncMLCommand extends SyncMLElement {

	/**
	 * @return true if NoResp has been specified for this SyncML command
	 */
	boolean isNoResp();

	/**
	 * Executes a top-level SyncML command for a given request. ALL errors must be handled within the command.
	 * To make sure that correct results are sent to the client even for completely unexpected RuntimeExceptions/Errors,
	 * the command MUST NOT modify or add anything to the response (or request) before it is completely finished,
	 * i.e. adding the result/status MUST be the FINAL action of the command.
	 * It is guaranteed that the USM session has already been successfully retrieved by the SyncMLRequest when
	 * this method is executed.
	 * 
	 * @param syncMLRequest
	 * @throws SyncMLException 
	 */
	void execute(SyncMLRequest syncMLRequest) throws SyncMLException;

	/**
	 * @return cmdID for this SyncML command
	 */
	String getCmdID();

	/**
	 * sets the 
	 */
	void setCmdID(String cmdID);

	/**
	 * @return List of sub-commands contained within this command, empty list if no sub-commands possible
	 */
	List<SyncMLCommand> getSubCommands();

	/**
	 * 
	 * @return true if this command is either a Sync command or any other command that initiates a Sync (normally, an Alert)
	 */
	boolean isSyncAction();

	//	/**
	//	 * If this command can have a target, and has a target specified, returns the target, in all other cases returns null
	//	 * @return
	//	 */
	//	Target getTarget();
	//
	//	/**
	//	 * If this command can have a source, and has a source specified, returns the target, in all other cases returns null
	//	 * @return
	//	 */
	//	Source getSource();
}
