/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml.commands;

import java.io.IOException;
import java.util.*;
import java.util.Map;

import org.xmlpull.v1.*;

import com.openexchange.usm.api.session.ChangeState;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.syncml.SyncMLBundleErrorCodes;
import com.openexchange.usm.syncml.SyncMLStatusCode;
import com.openexchange.usm.syncml.elements.*;
import com.openexchange.usm.syncml.exceptions.SyncMLException;
import com.openexchange.usm.syncml.parser.XmlPullParserUtil;

public abstract class BaseCommand extends BaseElement implements SyncMLCommand {

	private String _cmdID;

	//	/**
	//	 * Every non-abstract sub-class that uses this constructor MUST read the end-tag of the
	//	 * element on its own (using readElementEnd()).
	//	 * 
	//	 * @param parent
	//	 * @param parser
	//	 * @throws XmlPullParserException
	//	 * @throws IOException
	//	 */
	//	public BaseCommand(SyncMLElement parent, XmlPullParser parser) throws XmlPullParserException, IOException {
	//		super(parent);
	//		readElementStart(parser);
	//		setCmdID(XmlPullParserUtil.readText(parser, SimpleElements.CMD_ID));
	//		_noResp = readNoResp(parser);
	//	}

	public String getCmdID() {
		return _cmdID;
	}

	public void setCmdID(String cmdID) {
		_cmdID = cmdID;
	}

	public List<SyncMLCommand> getSubCommands() {
		return Collections.emptyList();
	}

	public boolean isSyncAction() {
		return false;
	}

	protected boolean readNoResp(XmlPullParser parser) throws XmlPullParserException, IOException {
		return XmlPullParserUtil.readOptionalFlag(parser, SimpleElements.NO_RESP);
	}

	@Override
	protected void writeContent(XmlSerializer serializer, Meta meta) throws IOException {
		XmlPullParserUtil.writeText(serializer, SimpleElements.CMD_ID, _cmdID);
	}

	protected void writeNoResp(XmlSerializer serializer, boolean noResp) throws IOException {
		XmlPullParserUtil.writeOptionalFlag(serializer, SimpleElements.NO_RESP, noResp);
	}

	protected void commandNotImplemented() throws SyncMLException {
		throw new SyncMLException(SyncMLBundleErrorCodes.COMMAND_NOT_IMPLEMENTED, SyncMLStatusCode.COMMAND_FAILED,
				"Command not implemented: " + getElementName());
	}

	protected DataObject findDataObjectByClientID(Map<String, DataObject> clientIDMap, String id)
			throws SyncMLException {
		DataObject o = clientIDMap.get(id);
		if (o == null || o.getChangeState() == ChangeState.UNMODIFIED)
			return o;
		throw new SyncMLException(SyncMLBundleErrorCodes.COMMAND_MULTIPLE_ACTIONS_ON_DATA_OBJECT,
				SyncMLStatusCode.COMMAND_FAILED, "More than one action requested on DataObject with id " + id);
	}
}
