/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.syncml;

public class SyncMLConstants {

	// If set, the SyncML bundle performs some integrity checks regarding the sync data (especially if all client IDs are present)
	public static final boolean PERFORM_INTEGRITY_CHECKS = true;

	// Default value of NoResp-Flag for all commands that do not use explicit settings
	public static final boolean NO_RESP_DEFAULT = false;

	public static final String UTF_8 = "UTF-8";

	public static final String PROTOCOL_NAME = "SyncML";

	public static final String SYNCML_NS = "SYNCML:SYNCML1.0";

	// namespace syncml:metinf

	public static final String NS_SYNCML_METINF = "syncml:metinf";

	public static final String ANCHOR = "Anchor";

	public static final String LAST = "Last";

	public static final String NEXT = "Next";

	public static final String TYPE = "Type";

	public static final String FORMAT = "Format";

	public static final String SYNCML_AUTH_BASIC = "syncml:auth-basic";

	public static final String FORMAT_B64 = "b64";

	public static final String MAX_MSG_SIZE = "MaxMsgSize";

	// namespace: syncml:devinf

	public static final String NS_SYNCML_DEVINF = "syncml:devinf";

	public static final String DEV_INFO = "DevInf";

	public static final String VER_CT = "VerCT";

	public static final String CT_TYPE = "CTType";

	public static final String TX = "Tx";

	public static final String TX_PREF = "Tx-Pref";

	public static final String RX = "Rx";

	public static final String RX_PREF = "Rx-Pref";

	public static final String DISPLAY_NAME = "DisplayName";

	public static final String DATA_STORE = "DataStore";

	public static final String SYNC_TYPE = "SyncType";

	public static final String SYNC_CAP = "SyncCap";

	public static final String CT_CAP = "CTCap";

	public static final String DEV_TYP = "DevTyp";

	public static final String DEV_ID = "DevID";

	public static final String OEM = "OEM";

	public static final String MOD = "Mod";

	public static final String MAN = "Man";

	public static final String DEVINF_TYPE = "application/vnd.syncml-devinf";

	public static final String DEVINF_TARGET = "./devinf";

	public static final String DEVINF_TARGET_DEFAULT = "./devinf11";

	public static final int DEVINF_LOWER_VERSION_LIMIT = 10;

	public static final int DEVINF_UPPER_VERSION_LIMIT = 11;

	public static final String PARAM_NAME = "ParamName";

	public static final String VAL_ENUM = "ValEnum";

	public static final String PROP_NAME = "PropName";

	public static final String MAX_GUID_SIZE = "MaxGUIDSize";

	public static final String FWV = "FwV";

	public static final String SWV = "SwV";

	public static final String HWV = "HwV";

	public static final String SUPPORT_LARGE_OBJ = "SupportLargeObjs";

}
