/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.session.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.contenttypes.SimContentType;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.database.EncapsulatedConnection;
import com.openexchange.usm.api.exceptions.DeserializationFailedException;
import com.openexchange.usm.api.exceptions.USMSQLException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.journal.Journal;
import com.openexchange.usm.journal.SimJournal;
import com.openexchange.usm.session.dataobject.DataObjectSet;

public class DataObjectStorageTest extends TestCase {

	EncapsulatedConnection _con;
	SimSessionWithDB _session;
	DataObjectStorage _storage;
	Journal _journal = new SimJournal();
	ContentType _contentType = new SimContentType();

	@Override
	protected void setUp() throws Exception {
		try {
			SimSessionManagerImpl sessionManager = new SimSessionManagerImpl();
			sessionManager.setJournal(_journal);
			_session = new SimSessionWithDB(sessionManager, "user", "pass", "protocol", "device");
			_storage = new DataObjectStorage(_session);
			_con = _session.getWritableDBConnection();
			Statement statement = _con.createStatement();
			statement
					.executeUpdate("create table USMDataStorage (cid integer NOT NULL, usmSessionId integer NOT NULL, ObjectID varchar(64) NOT NULL, SyncKey BIGINT NOT NULL, Element LONGVARCHAR)");
			statement
					.executeUpdate("create unique index USMDataStorageUIDX on USMDataStorage (cid, usmSessionId, ObjectID, SyncKey)");

			statement.close();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}

	private DataObject createDataObjectWithID(String id) {
		DataObject dataObject = _contentType.newDataObject(_session);
		dataObject.setID(id);
		return dataObject;
	}

	//	private Serializable[][] serializeObjects(DataObjectSet objects) {
	//		Serializable[][] data = new Serializable[objects.size()][];
	//		int i = 0;
	//		for (DataObject o : objects)
	//			data[i++] = o.serialize();
	//		return data;
	//	}

	private DataObject[] deserializeObjects(Serializable[][] values, long timestamp, ContentType contentType,
			SessionImpl session) {
		DataObject[] result = new DataObject[values.length];
		for (int i = 0; i < result.length; i++) {
			DataObject o = contentType.newDataObject(session);
			try {
				o.deserialize(timestamp, values[i]);
			} catch (DeserializationFailedException e) {
				return null;
			}
			result[i] = o;
		}
		return result;
	}

	public void testPutAndGet() {
		String folderID = "first_folder";
		List<DataObject> objectList = new ArrayList<DataObject>();
		for (int i = 0; i < 10; i++) {
			DataObject o = createDataObjectWithID(String.valueOf(i));
			o.commitChanges();
			objectList.add(o);
		}
		DataObjectSet set = new DataObjectSet(objectList);
		//Serializable[][] serializedObjects = serializeObjects(set);
		long timestamp = 100L;
		try {
			_storage.put(folderID, timestamp, set, 0L, _session);
			Serializable[][] retrieved = _storage.get(folderID, timestamp);
			assertTrue(set.isEqualTo(deserializeObjects(retrieved, timestamp, _contentType, _session)));
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	public void testRemove() {
		String folderIDtoRetain = "folder_to_retain";
		List<DataObject> objectList = new ArrayList<DataObject>();
		for (int i = 0; i < 10; i++) {
			objectList.add(createDataObjectWithID(String.valueOf(i)));
		}
		DataObjectSet set = new DataObjectSet(objectList);
		//		Serializable[][] serializedObjects = serializeObjects(set);
		long timestamp = 100L;
		try {
			_storage.put(folderIDtoRetain, timestamp, set, 0L, _session);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}

		String folderIDtoRemove = "folder_to_remove";
		objectList = new ArrayList<DataObject>();
		for (int i = 0; i < 10; i++) {
			objectList.add(createDataObjectWithID(String.valueOf(i)));
		}
		set = new DataObjectSet(objectList);
		//		serializedObjects = serializeObjects(set);
		timestamp = 100L;
		try {
			_storage.put(folderIDtoRemove, timestamp, set, 0L, _session);
			_storage.remove(folderIDtoRemove);

			Serializable[][] retrieved = _storage.get(folderIDtoRetain, timestamp);
			assertNotNull(retrieved);

			retrieved = _storage.get(folderIDtoRemove, timestamp);
			assertNull(retrieved);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	public void testRetain() {
		String folderIDtoRetain = "folder_to_retain";
		List<DataObject> objectList = new ArrayList<DataObject>();
		for (int i = 0; i < 10; i++) {
			objectList.add(createDataObjectWithID(String.valueOf(i)));
		}
		DataObjectSet set = new DataObjectSet(objectList);
		//		Serializable[][] serializedObjects = serializeObjects(set);
		long timestamp = 100L;
		try {
			_storage.put(folderIDtoRetain, timestamp, set, 0L, _session);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}

		String folderIDtoRemove = "folder_to_remove";
		objectList = new ArrayList<DataObject>();
		for (int i = 0; i < 10; i++) {
			objectList.add(createDataObjectWithID(String.valueOf(i)));
		}
		set = new DataObjectSet(objectList);
		//		serializedObjects = serializeObjects(set);
		timestamp = 100L;
		try {
			_storage.put(folderIDtoRemove, timestamp, set, 0L, _session);
			_storage.retain(folderIDtoRetain);

			Serializable[][] retrieved = _storage.get(folderIDtoRetain, timestamp);
			assertNotNull(retrieved);

			retrieved = _storage.get(folderIDtoRemove, timestamp);
			assertNull(retrieved);
		} catch (DatabaseAccessException e) {
			fail(e.getMessage());
		} catch (USMSQLException e) {
			fail(e.getMessage());
		}
	}

	@Override
	protected void tearDown() throws Exception {
		Statement statement = _con.createStatement();
		try {
			statement.executeUpdate("drop index USMDataStorageUIDX");
			statement.executeUpdate("drop table USMDataStorage");
		} finally {
			statement.close();
			_con.close();
		}
	}

}
