/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test.outlooklogs;

import java.util.*;

import org.json.*;

class OutlookLogSession {

	protected List<OutlookLogRoundtrip> fRoundTrips = new ArrayList<OutlookLogRoundtrip>();
	protected final String fSessionId;

	OutlookLogSession(String sessionId) {
		super();
		fSessionId = sessionId;
	}

	String getUserName() throws JSONException {
		for (OutlookLogRoundtrip trip : fRoundTrips) {
			String userName = trip.getUserName();
			if (userName != null) {
				return userName;
			}
		}
		return null;
	}

	String getUserId() throws JSONException {
		for (OutlookLogRoundtrip trip : fRoundTrips) {
			String userId = trip.getUserId();
			if (userId != null) {
				return userId;
			}
		}
		return null;
	}

	OutlookLogRoundtrip[] getFolderHierarchySyncs() {
		List<OutlookLogRoundtrip> result = new ArrayList<OutlookLogRoundtrip>();
		for (OutlookLogRoundtrip trip : fRoundTrips) {
			if (trip.isFolderHierarchySync()) {
				result.add(trip);
			}
		}
		return result.toArray(new OutlookLogRoundtrip[result.size()]);
	}

	/**
	 * @return keys: folder-uuids; values: folder data
	 */
	Map<String, JSONObject> getFolders() throws JSONException {
		Map<String, JSONObject> result = new HashMap<String, JSONObject>();
		OutlookLogRoundtrip[] hierarchies = getFolderHierarchySyncs();
		for (OutlookLogRoundtrip hierarchy : hierarchies) {
			JSONObject data = hierarchy.fResponse.getJSONObject("data");
			JSONArray created = data.optJSONArray("created");
			if (created != null) {
				int length = created.length();
				for (int i = 0; i < length; i++) {
					JSONObject folder = created.getJSONObject(i);
					String uuid = folder.getString("uuid");
					result.put(uuid, folder);
				}
			}
		}
		return result;
	}

}
