/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test.outlooklogs;

import java.io.BufferedWriter;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.util.Toolkit;

class OutlookLogRoundtrip {

	protected String fCommand = null;
	protected JSONObject fRequest = null;
	protected String fRequestTime = null;
	protected JSONObject fResponse = null;
	protected String fResponseTime = null;

	OutlookLogRoundtrip() {
		super();
	}

	public String getSessionId() throws JSONException {
		if ("login".equals(fCommand)) {
			return fResponse.getJSONObject("data").getString("sessionid");
		}
		return fRequest.getString("sessionid");
	}

	public String getUserName() throws JSONException {
		if ("login".equals(fCommand)) {
			return fRequest.getString("user");
		}
		return null;
	}

	public String getUserId() throws JSONException {
		if ("login".equals(fCommand)) {
			return fResponse.getJSONObject("data").getString("userid");
		}
		return null;
	}

	void print(BufferedWriter out, OutlookLogSession session) throws Exception {

		if (isPing()) {
			return;
		}

		out.write(fCommand);
		if (isFolderHierarchySync()) {
			out.write(" (folder hierarchy sync)");
		}
		out.write("\r\n");

		OutlookLogReplacement folderId = new OutlookLogReplacement(fRequest, "folderid", folderInfo(session));
		OutlookLogReplacement sessionId = new OutlookLogReplacement(fRequest, "sessionid", " -> user="
				+ session.getUserName() + ", userid=" + session.getUserId());
		out.write("(" + fRequestTime + ")");
		out.write(" ");
		out.write(fRequest.toString(3));
		out.write("\r\n");
		folderId.reset();
		sessionId.reset();

		out.write("(" + fResponseTime + ")");
		out.write(" ");
		out.write(fResponse.toString(3));
		out.write("\r\n");
		out.write("\r\n");

	}

	String folderInfo(OutlookLogSession session) throws Exception {
		String folderId = fRequest.optString("folderid");
		Map<String, JSONObject> folders = session.getFolders();
		JSONObject folder = folders.get(folderId);
		if (folder == null) {
			return "";
		}
		String info = " -> title='" + folder.optString("title") + "', created_by=" + folder.optString("created_by")
				+ ", type=" + folderType(folder);
		return info;
	}

	private String folderType(JSONObject folder) {
		String type = folder.optString("type");
		if ("1".equals(type)) {
			return "private";
		}
		if ("2".equals(type)) {
			return "public";
		}
		if ("3".equals(type)) {
			return "shared";
		}
		if ("5".equals(type)) {
			return "system";
		}
		return type + " (unknown)";
	}

	boolean isFolderHierarchySync() {
		if (isSyncInitOrUpdate()) {
			String folderId = fRequest.optString("folderid");
			return Toolkit.notProvided(folderId);
		}
		return false;
	}

	private boolean isPing() {
		return "ping".equals(fCommand);
	}

	private boolean isSyncInit() {
		return "syncInit".equals(fCommand);
	}

	private boolean isSyncUpdate() {
		return "syncUpdate".equals(fCommand);
	}

	private boolean isSyncInitOrUpdate() {
		return isSyncInit() || isSyncUpdate();
	}

}
