/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;

import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.json.ConnectorBundleErrorCodes;
import com.openexchange.usm.json.USMJSONAPIException;
import com.openexchange.usm.json.response.ResponseStatusCode;
import com.openexchange.usm.util.Toolkit;

public class XOriginalHeaderParserTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String xOriginalHeaders = "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";
		try {
			Enumeration<Header> originalHeadersMap = parseXOriginalHeaders(xOriginalHeaders);
			JSONObject headers = new JSONObject();
			while (originalHeadersMap.hasMoreElements()) {
				Header nextElement = originalHeadersMap.nextElement();
				String headerName = nextElement.getName();
				String value = nextElement.getValue();
				headers.put(headerName, value);
				System.out.println(headerName + ": " + value);
			}
		} catch (MessagingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	
	public static Enumeration<Header> parseXOriginalHeaders(String xOriginalHeaders) throws MessagingException  {
		xOriginalHeaders = xOriginalHeaders.concat("/r/n");
		ByteArrayInputStream is = new ByteArrayInputStream(Toolkit.decodeBase64(xOriginalHeaders));
		
			InternetHeaders ih = new InternetHeaders(is);
			return ih.getAllHeaders();
			
		
//		int c;
//		StringBuilder name = new StringBuilder();
//		StringBuilder value = new StringBuilder();
//		boolean readNameStopReached = false;
//		while((c = is.read()) > 0) {
//			if(c == ':')  {
//				readNameStopReached = true;
//			}
//			else if(c == '\n' || c == '\r') {
//				readNameStopReached = false;
//				result.put(name.toString(), value.toString());
//				name = new StringBuilder();
//				value = new StringBuilder();
//			}
//			else {
//				if(readNameStopReached) value.append(c);
//				else name.append(c);
//			}
//		}
	}


}
