/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.Arrays;

import junit.framework.*;

import com.openexchange.usm.util.Toolkit;

/**
 *
 * @author ibr
 *
 */
public class USMJsonTestSuite extends TestCase {

	private static final String TEST_SUFFIX = ".test";
	private static final String[] KNOWN_HOSTS = { "localhost", "ox-p5.microdoc.com" };

	private static final FileFilter FILTER = new FileFilter() {
		public boolean accept(File fileOrDir) {
			String name = fileOrDir.getName();
			if (".svn".equals(name)) {
				return false;
			}
			return true;
		}
	};

	public static Test suite() throws MalformedURLException {
		USMJsonTestConfig cfg = new USMJsonTestConfig();
		return createJsonTests(cfg, cfg.getTestFilesDir(), "USM_JSONTests");
	}

	private static TestSuite createJsonTests(USMJsonTestConfig cfg, File dir, String testSuiteName)
			throws MalformedURLException {
		TestSuite suite = new TestSuite(testSuiteName);
		File[] children = dir.listFiles(FILTER);
		Arrays.sort(children);
		for (File child : children) {
			if (child.isDirectory()) {
				TestSuite ts = createJsonTests(cfg, child, child.getName());
				if (ts.countTestCases() > 0)
					suite.addTest(ts);
			} else {
				String fileName = child.getName();
				String testCaseName = fileName.substring(0, fileName.length() - TEST_SUFFIX.length());
				if (isAllowedTestFile(cfg, fileName, testCaseName)) {
					TestCase tc = new USMJsonTestCase(cfg, child, testCaseName);
					suite.addTest(tc);
				}
			}
		}
		return suite;
	}

	private static boolean isAllowedTestFile(USMJsonTestConfig cfg, String fileName, String testCaseName)
			throws MalformedURLException {

		if (!fileName.endsWith(TEST_SUFFIX)) {
			return false;
		}

		String hostInFilename = extractHostName(testCaseName);
		if (hostInFilename != null) {
			String configuredHost = cfg.getUsmBaseUrl().getHost();
			if (!configuredHost.equals(hostInFilename)) {
				return false;
			}
		}

		String[] allowedNames = cfg.getTestFileNames();
		if (Toolkit.notProvided(allowedNames)) {
			return true;
		}

		for (String allowedName : allowedNames) {
			if (fileName.equals(allowedName)) {
				return true;
			}
		}

		return false;

	}

	private static String extractHostName(String testCaseName) {
		for (String host : KNOWN_HOSTS) {
			if (testCaseName.endsWith(host)) {
				return host;
			}
		}
		return null;
	}

}
