/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json.test;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import com.openexchange.usm.util.Toolkit;

class USMJsonTestConfig {

	private static final File WS_DIR = getCanonicalFile("..");
	private static final File PROJECT_DIR = new File(WS_DIR, "com.openexchange.usm.json");

	private static File getCanonicalFile(String path) {
		File f = new File(path);
		try {
			return f.getCanonicalFile();
		} catch (IOException e) {
			return f;
		}
	}

	USMJsonTestConfig() {
		super();
	}

	private String getFirstValueForProperties(String defaultValue, String... properties) {
		for (String property : properties) {
			String value = System.getProperty(property);
			if (Toolkit.provided(value)) {
				return value;
			}
		}
		return defaultValue;
	}

	/**
	 * @return the directory under /com.openexchange.usm.json/ in which the testfiles reside
	 */
	File getTestFilesDir() {
		String dir = getFirstValueForProperties("testfiles", "testFilesDirName", "dir");
		return new File(PROJECT_DIR, dir);
	}

	/**
	 * @return the directory /com.openexchange.usm.json/
	 */
	File getProjectDir() {
		return PROJECT_DIR;
	}

	/**
	 * @return the URL to the OX server which is to be used for tests
	 */
	URL getUsmBaseUrl() throws MalformedURLException {
		String url = getFirstValueForProperties("http://ox-p5.microdoc.com:80/usm-json/",  "usmBaseUrl", "url");
		return new URL(url);
	}

	/**
	 * @return the USM user name
	 */
	String getUsmUser() {
		return getFirstValueForProperties("user4", "usmUser", "user");
	}

	/**
	 * @return the USM user's password
	 */
	String getUsmPassword() {
		return getFirstValueForProperties("secret", "usmPassword", "password", "pw");
	}

	/**
	 * @return the names of the testfiles to be executed; if empty, all testfiles under the TestFilesDir will be executed; the names must be comma separated in the property
	 */
	String[] getTestFileNames() {
		String s = getFirstValueForProperties(null, "testFileNames", "files", "file");
		if (Toolkit.notProvided(s))
			return null;
		String[] list = s.split(",");
		return list;
	}

}
