/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.connector.test;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONArray;
import org.json.JSONObject;

import com.openexchange.usm.json.ServletConstants;


public class Bug20085_TestClient {

	
	private static final String DATA = "data";
	private static final String CREATED = "created";
	private static final String SESSIONID = "sessionid";
	public static final String USER = "user";
	public static final String DEVICE = "device";
	public static final String PASSWORD = "password";
	public static final String RETURN_CONFIG = "configuration";

	/**
	 * @param args
	 */

	public static final void main(String[] args) throws Exception {
        //LOGIN block
		HttpClient httpclient = new HttpClient();
		
		PutMethod httppost = new PutMethod("http://ox-p5.microdoc.com:80/usm-json/login");
		JSONObject requestBody = new JSONObject();
		requestBody.put(USER, "user3");
		requestBody.put(DEVICE, "android");
		requestBody.put(PASSWORD, "secret");
		requestBody.put(RETURN_CONFIG, Boolean.TRUE);
		String data = executeMethod(httpclient, httppost, requestBody);
		System.out.println("Login command end----------------------------------------");
		
		JSONObject loginResponseObject = new JSONObject(data);
		String sessionID = ((JSONObject)loginResponseObject.get(DATA)).getString(SESSIONID);
		
		//SYNCINIT folders block
		httppost = new PutMethod("http://ox-p5.microdoc.com:80/usm-json/syncInit");
		requestBody = new JSONObject();
		requestBody.put(SESSIONID, sessionID);
		data = executeMethod(httpclient, httppost, requestBody);
		System.out.println("Syncinit folders command end----------------------------------------");
		
		JSONObject initFoldersResponseObject = new JSONObject(data);
		JSONArray created = ((JSONObject)initFoldersResponseObject.get(DATA)).getJSONArray(CREATED);
		String contactsUUID = null;
		for (int i = 0; i < created.length(); i++) {
			JSONObject folder = created.getJSONObject(i);
			if("Contacts".equals(folder.getString("title"))) 
				contactsUUID = folder.getString("uuid");
		}
		
		//SYNCINIT data block
		httppost = new PutMethod("http://ox-p5.microdoc.com:80/usm-json/syncInit");
		requestBody = new JSONObject();
		requestBody.put(SESSIONID, sessionID);
		requestBody.put("folderid", contactsUUID);
		created = new JSONArray();
		for(int i = 0; i < 1000; i++) {
			JSONObject contact = new JSONObject("{\"state_business\":\"Niedersachsen\", \"position\":\"Inhaber\",\"objectType\":\"contacts\",\"fax_business\":\"05461-705204\", \"file_as\":\"Katrin10 Petersen\", \"second_name\":\"und Josef\",\"image1\":null,\"first_name\":\"Katrin10\",\"street_business\":\"Meyers Tannen 18\",\"number_of_images\":1,\"telephone_home2\":\"05424294505\",\"cellular_telephone2\":\"01713802079\",\"note\":\"05404-5973 0541-20112702\",\"last_name\":\"Petersen\",\"modified_by\":\"5\",\"postal_code_business\":\"49565\",\"telephone_business1\":\"05461-705203\",\"telephone_home1\":\"05451997143\",\"number_of_attachments\":0,\"private_flag\":false,\"display_name\":\"Katrin10 Petersen\",\"city_business\":\"Bramsche\",\"telephone_company\":\"054515028991\",\"country_business\":\"Deutschland\",\"created_by\":\"5\"}"); 
					//,"uuid":"8e7b325c-f4f0-4762-95f8-fe13140e1250",
			contact.put("uuid", (UUID.randomUUID()).toString());
			created.put(i, contact);
		}
		requestBody.put(CREATED, created);
		data = executeMethod(httpclient, httppost, requestBody);
		System.out.println("Sync init with data command end----------------------------------------");

		//LOGOUT block
		httppost = new PutMethod("http://ox-p5.microdoc.com:80/usm-json/logout");
		requestBody = new JSONObject();
		requestBody.put(SESSIONID, sessionID);
		requestBody.put("endSynchronization", true);
		data = executeMethod(httpclient, httppost, requestBody);
		System.out.println("Logout command end----------------------------------------");
	}

	private static String executeMethod(HttpClient httpclient, PutMethod httppost, JSONObject requestBody)
			throws UnsupportedEncodingException, URIException, IOException, HttpException {
		
		httppost.setRequestEntity(new StringRequestEntity(requestBody.toString(), ServletConstants.TEXT_JAVASCRIPT, ServletConstants.UTF_ENCODING_8));
		httppost.setRequestHeader(new Header("Content-Type", ServletConstants.TEXT_JAVASCRIPT));
		System.out.println("executing request " + httppost.getURI());
		int statusCode = httpclient.executeMethod(httppost);
		System.out.println("HTTP statusCode= " + statusCode);
		String data = httppost.getResponseBodyAsString();
		System.out.println(data);
		return data;
	}
}
