/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.json;

public interface ConnectorBundleErrorCodes {

	// TODO Group the error codes by area / command
	// 610000-6100FF: Common support method error codes
	// 610100-6101FF: Common command method error codes (i.e. BaseCommandHandler, NormalCommandHandler)
	// 610200-6102FF: Servlet error codes
	// 610300-6103FF: Login error codes
	// 610400-6104FF: Logout error codes
	// 610500-6105FF: GetConfiguration error codes
	// 610600-6106FF: SetConfiguration error codes
	// 610700-6107FF: SyncInit error codes
	// 610800-6108FF: SyncUpdate error codes
	// 610900-6109FF: SyncEstimate error codes
	// 610A00-610AFF: SetPushNotification error codes
	// 610B00-610BFF: ReadData error codes
	// 610C00-610CFF: SendMail error codes
	// 610D00-610DFF: ResolveRecipients error codes
	// 610E00-610EFF: MoveItems error codes
	// 610F00-610FFF: GetCachedData error codes
	// 611000-6110FF: Ping error codes
	// 611100-6111FF: RetrieveIds error codes
	// 611100-...     etc. (other calls available in the future?)

	// 610000-6100FF: Common support method error codes

	// 610100-6101FF: Common command method error codes (i.e. BaseCommandHandler, NormalCommandHandler)
	int COMMAND_UNKNOWN_PARAMETER = 0x610100;
	int COMMAND_NOT_IMPLEMENTED = 0x610101;
	int COMMAND_NO_BOOLEAN_IN_JSON_OBJECT = 0x610102;
	int COMMAND_NO_STRING_IN_JSON_OBJECT = 0x610103;
	int COMMAND_MISSING_REQUIRED_PARAMETER = 0x610104;
	int COMMAND_UNKNOWN_SESSION = 0x610105;
	int COMMAND_ACCESS_DENIED = 0x610106;
	int COMMAND_INTERNAL_ERROR = 0x610107;
	int COMMAND_NO_LONG_IN_JSON_OBJECT = 0x610108;
	int COMMAND_CONTENTTYPE_MISMATCH = 0x610109;
	int COMMAND_UNKNOWN_FOLDER_ID = 0x61010A;
	int COMMAND_BAD_LIMIT_PARAMETER = 0x61010B;
	int COMMAND_BAD_CONFLICT_RESOLUTION_PARAMETER = 0x61010C;
	int COMMAND_SYNC_RESULT_JSON_ERROR = 0x61010D;
	int COMMAND_SYNC_CONFLICT = 0x61010E;
	int COMMAND_SYNC_ERROR_JSON_ERROR = 0x61010F;
	int COMMAND_INVALID_UUID = 0x610110;
	int COMMAND_NO_JSON_ARRAY_IN_JSON_OBJECT = 0x610111;
	int COMMAND_NO_JSON_OBJECT_IN_JSON_ARRAY = 0x610112;
	int COMMAND_NO_STRING_IN_JSON_ARRAY = 0x610113;
	int COMMAND_DATA_OBJECT_MISSING_UUID_IN_STORAGE = 0x610114;
	int COMMAND_DATA_OBJECT_TYPE_MISMATCH = 0x610115;
	int COMMAND_MULTIPLE_ACTIONS_ON_DATA_OBJECT = 0x610116;
	int COMMAND_DATA_OBJECT_NOT_FOUND = 0x610117;
	int COMMAND_ILLEGAL_PROPERTY_VALUE = 0x610118;
	int COMMAND_UNKNOWN_PROPERTY = 0x610119;
	int COMMAND_CANNOT_READ_EXTRA_FIELDS = 0x61011A;
	int COMMAND_NO_JSON_OBJECT_IN_JSON_OBJECT = 0x61011B;
	int COMMAND_NO_INT_IN_JSON_OBJECT = 0x61011C;
	int COMMAND_UNKNOWN_FOLDER_UUID = 0x61011D;
	int COMMAND_CANNOT_DETERMINE_FOLDER_UUID = 0x61011E;
	int COMMAND_CANNOT_FIND_FOLDER_BY_UUID = 0x61011F;
	int COMMAND_CANNOT_CREATE_MAIL = 0x610120;
	int COMMAND_SYNC_AND_PARENT_FOLDER_NO_MATCH = 0x610121;
	int COMMAND_SYNC_CAN_NOT_READ_MAIL_FROM_SERVER = 0x610122;
	int COMMAND_INVALID_JSON_PROPERTY_1 = 0x610123;
	int COMMAND_INVALID_JSON_PROPERTY_2 = 0x610124;
	int COMMAND_SYNC_CONFLICT_2 = 0x610125;
	int COMMAND_SYNC_CAN_NOT_READ_ATTACHMENTS = 0x610127;
	int COMMAND_SYNC_ERROR_ON_CREATE_DELETE_ATTACHMENTS = 0x610128;
	int COMMAND_SYNC_CAN_NOT_SAVE_SYNC_STATE = 0x610129;
	int COMMAND_SYNC_ERROR_ON_RETRIEVE_ATTACHMENTS_FORM_SERVER = 0x61012A;
	int COMMAND_SYNC_CAN_NOT_RETRIEVE_CACHED_ELEMENTS = 0x61012B;
	int COMMAND_SYNC_CAN_NOT_ADD_MEETING_REQUEST_TO_MAIL = 0x61012C;
	int COMMAND_SYNC_CAN_NOT_CONVERT_ICAL_TO_MEETING_REQUEST = 0x61012D;
	int COMMAND_SYNC_CAN_NOT_GET_MAIL_OR_MEETING_REQUEST = 0x61012E;
	int COMMAND_DATA_OBJECT_NOT_FOUND_2 = 0x61012F;
	int COMMAND_SYNC_RESULT_USM_ERROR = 0x610130;
	int INITIALIZER_USM_JSON_ACCESS_DENIED_FOR_USER = 0x610131;
	int INITIALIZER_NEW_FOLDER_TREE_MODULE_NOT_INSTALLED = 0x610132;
	int PARENT_UUID_CAN_NOT_BE_DETERMINED = 0x610133;
	int PARENT_UUID_CAN_NOT_BE_ADDED = 0x610134;
	int SYNC_INTERNAL_ERROR_ON_CREATE_DELETE_ATTACHMENTS = 0x610135;
	int COMMAND_BAD_DISTRIBUTION_LIST = 0x610136;
	int COMMAND_CANNOT_RESOLVE_DISTRIBUTION_LIST_MEMBER = 0x610137;
	int COMMAND_DUPLICATE_UUID = 0x610138;
	int SYNC_INSUFFICIENT_DELETION_RIGHTS = 0x610139;
	int SYNC_INSUFFICIENT_CREATION_RIGHTS = 0x610140;
	int SYNC_PIM_ATTACHMENT_CREATION_FAILED = 0x610141;
	int SYNC_STORING_NEW_STATE_ON_IMAP_DOWN_FAILED = 0x610142;
	int SYNC_RETREIVING_TRASH_FOLDER_FAILED = 0x610143;
	int COMMAND_REJECTED_TOO_MANY_SYNCHRONIZATIONS = 0x610144;
	int SYNC_CAN_NOT_CHANGE_CONFIRMATIONS_ERR1 = 0x610145;

	// 610200-6102FF: Servlet error codes
	int SERVLET_REGISTRATION_FAILED = 0x610200;
	int SERVLET_ALIAS_IN_USE = 0x610201;
	int BAD_REQUEST = 0x610202;
	int BAD_COMMAND_IN_REQUEST = 0x610203;
	int UTF_8_NOT_SUPPORTED = 0x610204;
	int ERROR_ON_READ_REQUEST = 0x610205;
	int BAD_JSONOBJECT_IN_REQUEST = 0x610206;
	int INVALID_ALIAS_FOR_SERVLET = 0x610207;
	int EXCEPTION_IN_SERVLET = 0x610208;

	// 610300-6103FF: Login error codes
	int LOGIN_JSON_ERROR = 0x610300;
	int LOGIN_INVALID_VERSION = 0x610301;
	int LOGIN_UNSUPPORTED_VERSION = 0x610302;
	int LOGIN_INVALID_DATE = 0x610303;
	int LOGIN_CLIENT_TIME_TOO_NEW = 0x610304;
	int LOGIN_CLIENT_TIME_TOO_OLD = 0x610305;

	// 610400-6104FF: Logout error codes
	int LOGOUT_END_SYNCHRONIZATION_FAILED = 0x610400;

	// 610500-6105FF: GetConfiguration error codes
	int GET_CONFIG_INTERNAL_ERROR = 0x610500;
	int GET_CONFIG_JSON_ERROR = 0x610501;

	// 610600-6106FF: SetConfiguration error codes
	int SET_CONFIG_UNKNOWN_CONTENTTYPE = 0x610600;
	int SET_CONFIG_KEY_TOO_LONG = 0x610601;
	//	int SET_CONFIG_JSON_ERROR = 0x610602;
	int SET_CONFIG_INTERNAL_ERROR = 0x610603;
	int SET_CONFIG_ILLEGAL_CONTENT_TYPE_FIELD = 0x610604;
	int SET_CONFIG_ILLEGAL_CONTENT_TYPE_LIST = 0x610605;
	int SET_CONFIG_ILLEGAL_CONTENT_TYPE_FIELD_LIST = 0x610606;
	int SET_CONFIG_UNSUPPORTED_FIELDS_FOR_CONTENT_TYPE = 0x610607;
	int SET_CONFIG_CAN_NOT_GET_AVALIABLE_TYPES = 0x610608;
	int SET_CONFIG_CAN_NOT_GET_AVALIABLE_TYPES_2 = 0x610609;

	// 610700-6107FF: SyncInit error codes
	int SYNC_INIT_INVALID_SYNCID = 0x610700;
	int SYNC_INIT_INTERNAL_ERROR = 0x610701;

	// 610800-6108FF: SyncUpdate error codes
	int SYNC_UPDATE_INVALID_SYNCID = 0x610800;
	int SYNC_UPDATE_INTERNAL_ERROR = 0x610801;
	int SYNC_UPDATE_NUMBER_ERROR = 0x610802;
	int SYNC_UPDATE_ERROR_APP_EXCEPTION = 0x610803;
	int SYNC_UPDATE_CAN_NOT_READ_MAIL_FROM_SERVER = 0x610804;
	int SYNC_UPDATE_CAN_NOT_UPDATE_MAIL_FROM_SERVER = 0x610805;
	int SYNC_UPDATE_INVALID_SYNCID_2 = 0x610806;
	int SYNC_UPDATE_INTERNAL_ERROR_2 = 0x610807;
	int SYNC_UPDATE_CAN_NOT_SAVE_EMAILS_SYNC_STATE = 0x610808;
	int SYNC_UPDATE_CAN_NOT_UPDATE_EMAIL_ON_SERVER = 0x610809;

	// 610900-6109FF: SyncEstimate error codes
	int SYNC_ESTIMATE_INVALID_SYNCID = 0x610900;
	int SYNC_ESTIMATE_INTERNAL_ERROR = 0x610901;
	int SYNC_ESTIMATE_JSON_ERROR = 0x610902;

	// 610A00-610AFF: SetPushNotification error codes
	int SET_PUSH_NOTIFICATION_INVALID_TYPE_ERROR = 0x610A00;
	int SET_PUSH_NOTIFICATION_INVALID_HOST_ERROR = 0x610A01;
	int SET_PUSH_NOTIFICATION_INVALID_PORT_ERROR = 0x610A02;
	int SET_PUSH_NOTIFICATION_SERVER_ISNOT_RUN_ERROR = 0x610A03;

	// 610B00-610BFF: ReadData error codes
	int READ_DATA_JSON_ERROR = 0x610B00;
	int READ_DATA_JSON_ERROR_2 = 0x610B01;
	int READ_DATA_JSON_ERROR_3 = 0x610B02;
	int READ_DATA_READ_ELEMENTS_ERROR = 0x610B03;

	// 610C00-610CFF: SendMail error codes
	int SEND_MAIL_MISSING_DATA_ERROR = 0x610C00;
	int SEND_MAIL_SENDMAIL_ACTION_ERROR = 0x610C01;

	// 610D00-610DFF: ResolveRecipients error codes
	int RESOLVE_RECIPIENTS_WRONG_PROPERTIES = 0x610D00;
	int RESOLVE_RECIPIENTS_JSON_ERROR_PROPERTIES = 0x610D01;
	int RESOLVE_RECIPIENTS_RETRIEVE_AVAILABLE_FIELDS = 0x610D02;
	int RESOLVE_RECIPIENTS_CAN_NOT_GET_CONTACTS = 0x610D03;
	int RESOLVE_RECIPIENTS_CAN_NOT_CREATE_RESPONCE = 0x610D04;
	int RESOLVE_RECIPIENTS_WRONG_NAMES_ARRAY = 0x610D05;

	// 610E00-610EFF: MoveItems error codes
	int MOVE_ITEMS_INTERNAL_ERROR = 0x610E00;
	int MOVE_ITEMS_NOT_MATCHING_FOLERS = 0x610E01;
	int MOVE_ITEMS_INVALID_SYNC_ID = 0x610E02;
	int MOVE_ITEMS_SAME_SOURCE_DEST = 0x610E03;
	int MOVE_ITEMS_INTERNAL_ERROR_2 = 0x610E04;
	int MOVE_ITEMS_INVALID_SYNC_ID_2 = 0x610E05;
	int MOVE_ITEMS_INTERNAL_ERROR_3 = 0x610E06;
	int MOVE_ITEMS_JSON_ERROR = 0x610E07;
	int MOVE_ITEMS_INTERNAL_ERROR_4 = 0x610E08;
	int MOVE_ITEMS_INTERNAL_ERROR_5 = 0x610E09;

	// 610F00-610FFF: GetCachedData error codes
	int GET_CACHED_DATA_GET_ELEMENTS_ERROR = 0x610F00;
	int GET_CACHED_DATA_JSON_ERROR = 0x610F01;

	// 611000-6110FF: Ping error codes
	int PING_NO_DB_ACCESS = 0x611000;
	int PING_SQL_ERROR = 0x611001;
	int PING_JSON_ERROR = 0x611002;
	int PING_INTERNAL_ERROR = 0x611003;
	int PING_WAIT_FOR_CHANGES_INTERRUPTED_ERROR = 0x611001;

	// 611100-6111FF: RetrieveIds error codes
	int RESOLVE_IDS_LOGIN_UNSUCCESSFUL = 0x611100;
	int RESOLVE_IDS_JSON_ERROR_ON_CREATE_RESULT = 0x611101;
	int RESOLVE_IDS_INVALID_UUID = 0x611102;

	// 611200-6112FF: invalidateObjects error codes
	int INVALIDATE_OBJECTS_DB_ERROR = 0x611200;
	int INVALIDATE_OBJECTS_SQL_ERROR = 0x611201;
	int INVALIDATE_OBJECTS_INTERNAL_ERROR = 0x611202;
	int INVALIDATE_OBJECTS_JSON_ERROR = 0x611202;

	// 611300-6113FF: locateObjects error codes
	int LOCATE_OBJECTS_DB_ERROR = 0x611300;
	int LOCATE_OBJECTS_SQL_ERROR = 0x611301;
	int LOCATE_OBJECTS_JSON_ERROR = 0x611302;

	// 611400-6114FF: setConfirmationStatus error codes
	int SET_CONFIRMATION_STATUS_DB_ERROR = 0x611400;
	int SET_CONFIRMATION_STATUS_SQL_ERROR = 0x611401;
	int SET_CONFIRMATION_STATUS_INVALID_CONTENT_TYPE = 0x611402;
	int SET_CONFIRMATION_STATUS_AUTHENTICATION_ERROR = 0x611403;
	int SET_CONFIRMATION_STATUS_OX_COMMUNICATION_ERROR = 0x611404;
	int SET_CONFIRMATION_STATUS_NO_OBJECT_FOUND_FOR_UID = 0x611405;
	int SET_CONFIRMATION_STATUS_SYNC_EXCEPTION = 0x611406;
	int SET_CONFIRMATION_STATUS_NO_FOLDERS = 0x611407;
	int SET_CONFIRMATION_STATUS_NO_STANDARD_CALENDAR_FOLDER = 0x611408;
	int SET_CONFIRMATION_STATUS_EXC_ON_SAVING_STATE = 0x611409;
	int SET_CONFIRMATION_STATUS_ERROR_ON_CREATE_RESP = 0x611410;

	// 618000 - 6180FF
	int MIMEMAIL_ILLEGAL_CONTENT_TYPE_FIELD_ERROR = 0x618000;
	int MIMEMAIL_WRITE_OUT_ERROR = 0x618001;
	int MIMEMAIL_JSONEXCEPTION_ERROR = 0x618002;
	int MIMEMAIL_JAVAPI_MESSAGING_ERROR = 0x618003;
	int MIMEMAIL_UNSUPPORTED_ENCODING_ERROR = 0x618004;
	int MIMEMAIL_ADD_HEADER_JSON_ERROR = 0x618005;
	int MIMEMAIL_ADD_HEADER_JAVAPI_MESSAGING_ERROR = 0x618006;
	int MIMEMAIL_SAVE_CHANGE_ERROR = 0x618007;
	int MIMEMAIL_IO_ERROR = 0x618008;
	int MIMEMAIL_CONTENT_TYPE_MAIL_EXC = 0x618009;
	int MIMEMAIL_CONTENT_DISP_MAIL_EXC = 0x61800A;
	int MIMEMAIL_UNSUPPORTED_ENCODING_ERROR_2 = 0x61800B;
	int MIMEMAIL_ADDRESS_EXCEPTION = 0x61800C;
	int MIMEMAIL_UNSUPPORTED_ENCODING_ERROR_3 = 0x61800D;
	int MIMEMAIL_UNSUPPORTED_BODY_FIELDS = 0x61800E;
	int MIMEMAIL_UNSUPPORTED_ENCODING_ERROR_4 = 0x61800F;
	int SMIMEMAIL_JSONEXCEPTION_ERROR = 0x618010;
	int SMIMEMAIL_JAVAPI_MESSAGING_ERROR = 0x618011;
	int MIMEMAIL_JAVAPI_MESSAGING_ERROR_PARSE_ORIGINAL_HEADERS = 0x618013;
}
