/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.mail.impl;

import junit.framework.Test;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.UnsupportedContentOperationException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.contenttypes.test.ContentTypeTransferHandlerTest;
import com.openexchange.usm.journal.SimJournal;
import com.openexchange.usm.ox_json.SimOXJSONAcess;
import com.openexchange.usm.session.dataobject.SimpleDataObject;
import com.openexchange.usm.session.dataobject.SimpleDataObjectTest;
import com.openexchange.usm.test.results.TestObjectResult;

public class MailContentTypeTransferHandlerTest extends ContentTypeTransferHandlerTest {

	public static String _propsPath = "../com.openexchange.usm.contenttypes.mail/testfiles/";

	private boolean initialized = false;

	public static Test suite() {
		return createTestSuite(_propsPath, "MailTestRepeater", MailContentTypeTransferHandlerTest.class);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		if (!initialized) {
			SimJournal journal = new SimJournal();
			MailContentTypeImpl contentType = new MailContentTypeImpl();
			SimOXJSONAcess oxAjaxAccess = new SimOXJSONAcess();
			MailContentTypeTransferHandlerImpl transferHandler = new MailContentTypeTransferHandlerImpl(contentType,
					journal.getLog(MailContentTypeTransferHandlerImpl.class), oxAjaxAccess);
			String requestPath = MailConstants.MAIL_PATH;
			initialize(journal, oxAjaxAccess, transferHandler, _propsPath, requestPath, contentType);
			initialized = true;

		}
	}

	@Override
	public void testWriteNewDataObject() throws USMException {
		try {
			//read the initial data object
			String initialDatabject = _props.getProperty("writeNewInitialDataObject");
			SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
					initialDatabject);

			//read the ajax request
			String request = _props.getProperty("writeNewRequest");
			_oxAjaxAccess.setValidParamsString(request);

			//read the expected request body
			String requestBody = _props.getProperty("writeNewExpectedRequestBody");
			_oxAjaxAccess.setValidRequestBody(requestBody);

			//read and construct the result
			TestObjectResult validResult = new TestObjectResult();
			String forJSON = _props.getProperty("writeNewExpectedResult");
			try {
				validResult.setResult(new JSONObject(forJSON));
			} catch (JSONException e) {
				fail("Invalid object in properties file");
			}

			_oxAjaxAccess.setValidResultToSend(validResult);

			//call the tested handler
			_transferHandler.writeNewDataObject(dataObject);

			fail("Unsupported Content Operation Exception is not thrown");
		} catch (UnsupportedContentOperationException ignored) {
		}
	}

	@Override
	public void testWriteUpdatedDataObject() throws NumberFormatException, USMException {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeModifiedInitialDataObject");
		SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
				initialDatabject);

		int maxRequests = 8;

		String[] request = new String[maxRequests];
		String[] requestBody = new String[maxRequests];
		TestObjectResult[] validResult = new TestObjectResult[maxRequests];

		for (int i = 0; i < maxRequests; i++) {
			//read the ajax request
			request[i] = _props.getProperty("writeModifiedRequest");

			//read the expected request body
			requestBody[i] = _props.getProperty("writeModifiedExpectedRequestBody" + (i + 1));

			//read and construct the result
			validResult[i] = new TestObjectResult();
			String forJSON = _props.getProperty("writeModifiedExpectedResult");
			try {
				validResult[i].setResult(new JSONObject(forJSON));
			} catch (JSONException e) {
				fail("Invalid object in properties file");
			}
		}

		_oxAjaxAccess.setValidParamsString(request);
		_oxAjaxAccess.setValidRequestBody(requestBody);
		_oxAjaxAccess.setValidResultToSend(validResult);

		String timestamp = _props.getProperty("writeModifiedTimestamp");
		//call the tested handler
		_transferHandler.writeUpdatedDataObject(dataObject, Long.parseLong(timestamp));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("writeModifiedExpectedDataObject");
		assertEquals(expectedDataObject, dataObject.toString());
	}
}
