/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.contenttypes.folder.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;

import junit.framework.Test;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.FolderContentType;
import com.openexchange.usm.api.contenttypes.FolderContentTypeTransferHandler;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.contenttypes.test.ContentTypeTransferHandlerTest;
import com.openexchange.usm.contenttypes.util.UtilConstants;
import com.openexchange.usm.journal.SimJournal;
import com.openexchange.usm.ox_json.SimOXJSONAcess;
import com.openexchange.usm.session.dataobject.FolderImpl;
import com.openexchange.usm.session.dataobject.SimpleDataObjectTest;
import com.openexchange.usm.test.results.TestObjectResult;

public class FolderContentTypeTransferHandlerTest extends ContentTypeTransferHandlerTest {

	static String _propsPath = "../com.openexchange.usm.contenttypes.folder/testfiles/";

	private boolean _initialized = false;

	public static Test suite() {
		//		return new TestSuite();
		return createTestSuite(_propsPath, "FolderTestRepeater", FolderContentTypeTransferHandlerTest.class);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		if (!_initialized) {
			SimJournal journal = new SimJournal();
			FolderContentTypeImpl contentType = new FolderContentTypeImpl();
			SimOXJSONAcess oxAjaxAccess = new SimOXJSONAcess();
			_transferHandler = new FolderContentTypeTransferHandlerImpl(contentType, journal
					.getLog(FolderContentTypeTransferHandlerImpl.class), oxAjaxAccess);
			String requestPath = UtilConstants.FOLDER_PATH;
			initialize(journal, oxAjaxAccess, _transferHandler, _propsPath, requestPath, contentType);
			_initialized = true;
		}
	}

	@Override
	public void testReadDataObject() throws USMException {
		//read the initial data object
		String initialDatabject = _props.getProperty("readObjectInitialDataObject");
		FolderImpl dataObject = SimpleDataObjectTest.createTestFolderObjectFromString(_session,
				(FolderContentType) _contentType, initialDatabject);

		//read the ajax request
		String request = _props.getProperty("readObjectRequest");
		String columns = _props.getProperty("readObjectColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readObjectExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.readDataObject(dataObject, createRequestedFields(dataObject.getContentType()));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("readObjectExpectedDataObject");
		assertEquals(expectedDataObject, dataObject.toString());
	}

	@Override
	public void testWriteNewDataObject() throws USMException {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeNewInitialDataObject");
		FolderImpl dataObject = SimpleDataObjectTest.createTestFolderObjectFromString(_session,
				(FolderContentType) _contentType, initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeNewRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeNewExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeNewExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid JSON object in parameters");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.writeNewDataObject(dataObject);

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("writeNewExpectedDataObject");
		assertEquals(expectedDataObject, dataObject.toString());
	}

	@Override
	public void testWriteUpdatedDataObject() throws NumberFormatException, USMException {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeModifiedInitialDataObject");
		FolderImpl dataObject = SimpleDataObjectTest.createTestFolderObjectFromString(_session,
				(FolderContentType) _contentType, initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeModifiedRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeModifiedExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeModifiedExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		String timestamp = _props.getProperty("writeModifiedTimestamp");
		//call the tested handler
		_transferHandler.writeUpdatedDataObject(dataObject, Long.parseLong(timestamp));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("writeModifiedExpectedDataObject");
		assertEquals(expectedDataObject, dataObject.toString());
	}

	@Override
	public void testWriteDeletedDataObject() throws USMException {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeDeletedInitialDataObject");
		FolderImpl dataObject = SimpleDataObjectTest.createTestFolderObjectFromString(_session,
				(FolderContentType) _contentType, initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeDeletedRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeDeletedExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeDeletedExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.writeDeletedDataObject(dataObject);

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("writeDeletedExpectedDataObject");
		assertEquals(expectedDataObject, dataObject.toString());
	}

	@Override
	public void disabled_testReadFolderContent() throws USMException {
		//read the initial data object
		String parentFolderId = _props.getProperty("readFolderContentInitialFolderID");

		Folder folder = new FolderImpl(_session, new FolderContentTypeImpl());
		folder.setElementsContentType(_contentType);
		folder.setID(parentFolderId);

		//read the ajax request
		String request = _props.getProperty("readFolderContentRequest");
		String columns = _props.getProperty("readFolderContentColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		request += "&parent=" + parentFolderId;
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readFolderContentExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		DataObject[] resultArray = _transferHandler.readFolderContent(folder, createRequestedFields(_contentType));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("readFolderContentExpectedDataObjectArray");
		assertEquals(expectedDataObject, Arrays.toString(resultArray));
	}

	@Override
	public void testReadUpdatedFolderContent() throws NumberFormatException, USMException {
		//read the initial data object
		String parentFolderId = _props.getProperty("readFolderUpdatesInitialFolderID");

		Folder folder = new FolderImpl(_session, new FolderContentTypeImpl());
		folder.setElementsContentType(_contentType);
		folder.setID(parentFolderId);

		//read the ajax request
		String request = _props.getProperty("readFolderUpdatesRequest");
		String columns = _props.getProperty("readFolderUpdatesColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		request += "&parent=" + parentFolderId;
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readFolderUpdatesExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		String timestamp = _props.getProperty("readFolderUpdatesTimestamp");
		//call the tested handler
		DataObject[] resultArray = _transferHandler.readUpdatedFolderContent(folder,
				createRequestedFields(_contentType), Long.parseLong(timestamp));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("readFolderUpdatesExpectedDataObjectArray");
		assertEquals(expectedDataObject, Arrays.toString(resultArray));
	}

	public void testReadRootFolders() throws USMException {
		//read the initial data object

		//read the ajax request
		String request = _props.getProperty("readRootRequest");
		String columns = _props.getProperty("readRootColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readRootExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		Folder[] resultArray = ((FolderContentTypeTransferHandler) _transferHandler).readRootFolders(_session,
				createRequestedFields(_contentType));

		//compare the returned data object with the expected one
		String expectedDataObject = _props.getProperty("readRootExpectedDataObjectArray");
		assertEquals(expectedDataObject, Arrays.toString(resultArray));
	}
}
