/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session;

import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.ContentType;
import com.openexchange.usm.api.database.DatabaseAccessException;
import com.openexchange.usm.api.database.EncapsulatedConnection;
import com.openexchange.usm.api.exceptions.FolderNotFoundException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.exceptions.USMSQLException;

public class SimSession implements Session {
	private static final int SESSION_ID = 200;

	private final Map<String, String> _fields = new HashMap<String, String>();
	private final Map<String, Object> _properties = new HashMap<String, Object>();

	private long _startDate = 0L;
	private long _endDate = Long.MAX_VALUE;

	private int _mailLimit = 0;

	private int _sessionId;

	private UUID _UUIDHeader;

	private OXConnectionInformation _oxConnectionData;

	public SimSession() {
		_sessionId = SESSION_ID;
		_UUIDHeader = UUID.randomUUID();
	}

	public void addChangeListener(SessionChangeListener listener) {
		throw new UnsupportedOperationException();
	}

	public ConflictResolution getConflictResolution() {
		throw new UnsupportedOperationException();
	}

	public String getDevice() {
		return "SimDevice";
	}

	public String getPassword() {
		return "SimPassword";
	}

	public String getUser() {
		return "SimUser";
	}

	public String getProtocol() {
		return "SimProtocol";
	}

	public void removeChangeListener(SessionChangeListener listener) {
		throw new UnsupportedOperationException();
	}

	public void setConflictResolution(ConflictResolution resolution) {
		throw new UnsupportedOperationException();
	}

	public void setContentTypeFilter(ContentType... usedContentTypes) {
		throw new UnsupportedOperationException();
	}

	public void setFieldFilter(ContentType contentType, String... fieldsOfInterest) {
		throw new UnsupportedOperationException();
	}

	public void setFieldFilter(ContentType contentType, BitSet fieldsOfInterest) throws DatabaseAccessException,
			USMSQLException {
		throw new UnsupportedOperationException();
	}

	public ObjectChanges waitForChanges(boolean watchFolderChanges, String[] contentChangeParentIDsToWatch, long timeout)
			throws USMException, InterruptedException {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return "SimSession";
	}

	public SyncResult syncChangesWithServer(String folderId, long timestamp, int limit, DataObjectFilter filter,
			boolean storeResult, ConflictResolution conflictResolution, DataObject... elements) {
		throw new UnsupportedOperationException();
	}

	public SyncResult syncWithServer(String folderId, int limit, DataObjectFilter filter, boolean storeResult,
			ConflictResolution conflictResolution, DataObject... elements) {
		throw new UnsupportedOperationException();
	}

	public SyncResult syncFolderChangesWithServer(long timestamp, int limit, DataObjectFilter filter,
			boolean storeResult, ConflictResolution conflictResolution, Folder... folderChanges) throws USMException {
		throw new UnsupportedOperationException();
	}

	public SyncResult syncFoldersWithServer(int limit, DataObjectFilter filter, boolean storeResult,
			ConflictResolution conflictResolution, Folder... folders) throws USMException {
		throw new UnsupportedOperationException();
	}

	public BitSet getFieldFilter(ContentType contentType) {
		return null;
	}

	public Folder getCachedFolder(String folderId, long timestamp) {
		return null;
	}

	public DataObject getCachedFolderElement(String folderId, ContentType type, String objectId, long timestamp) {
		return null;
	}

	public DataObject[] getCachedFolderElements(String folderId, ContentType type, long timestamp) {
		return null;
	}

	public Folder[] getCachedFolders(long timestamp) {
		return null;
	}

	public Folder getCachedFolder(String folderId) {
		return null;
	}

	public DataObject getCachedFolderElement(String folderId, ContentType type, String objectId) {
		return null;
	}

	public DataObject[] getCachedFolderElements(String folderId, ContentType type) {
		return null;
	}

	public Folder[] getCachedFolders() {
		return null;
	}

	public Map<DataObject, USMException> updateDataObjects(DataObject... changedObjects) throws USMException {
		throw new UnsupportedOperationException();
	}

	public DataObject readDataObject(String folderID, String objectID, String... fields) throws USMException {
		throw new UnsupportedOperationException();
	}

	public DataObject readDataObject(String folderID, String objectID, BitSet fields) throws USMException {
		throw new UnsupportedOperationException();
	}

	public int getContextId() {
		return 0;
	}

	public int getUserIdentifier() {
		return 0;
	}

	public String getPersistentField(String name) {
		return _fields.get(name);
	}

	public void setPersistentField(String name, String value) {
		_fields.put(name, value);
	}

	public void setRootFolders(String... folderId) {
		throw new UnsupportedOperationException();
	}

	public Object getCustomProperty(String key) {
		return _properties.get(key);
	}

	public Object setCustomProperty(String key, Object value) {
		return (value == null) ? _properties.remove(key) : _properties.put(key, value);
	}

	public DataObjectFilter getSyncServerObjectFilter() {
		return null;
	}

	public void setSyncServerObjectFilter(DataObjectFilter filter) {
		throw new UnsupportedOperationException();
	}

	public TimeZone getUserTimeZone() {
		return TimeZone.getTimeZone("GMT");
	}

	public EncapsulatedConnection getWritableDBConnection() throws DatabaseAccessException {
		return null;
	}

	public EncapsulatedConnection getReadOnlyDBConnection() throws DatabaseAccessException {
		return null;
	}

	public long getEndDate() {
		return _endDate;
	}

	public long getStartDate() {
		return _startDate;
	}

	public void setEndDate(long date) {
		_endDate = date;
	}

	public void setStartDate(long date) {
		_startDate = date;
	}

	public int getSessionId() {
		return _sessionId;
	}

	public String getFolderID(String shortFolderID) {
		return shortFolderID;
	}

	public String getShortFolderID(String folderID) {
		return folderID;
	}

	@Deprecated
	public long storeSyncState(long timestamp, String folderID, DataObject[] objects) throws USMException {
		return timestamp;
	}

	public long storeSyncState(long timestampToKeep, long timestamp, String folderID, DataObject[] objects)
			throws USMException {
		return timestamp;
	}

	public int getMailLimit() {
		return _mailLimit;
	}

	public void setMailLimit(int limit) {
		_mailLimit = limit;
	}

	public void endSyncronization() throws USMSQLException, DatabaseAccessException {
	}

	public Map<String, String> getPersistentFields() {
		return Collections.unmodifiableMap(_fields);
	}

	public Folder findFolder(String folderID) throws USMException {
		throw new FolderNotFoundException(-1, "Folder not found: " + folderID);
	}

	public UUID createUUID(ContentType contentType, int objectId) throws DatabaseAccessException, USMSQLException {
		UUID uuid = _UUIDHeader;
		long lsb = uuid.getLeastSignificantBits();
		lsb ^= (objectId | ((long) contentType.getCode()) << 32);
		UUID newUUID = new UUID(uuid.getMostSignificantBits(), lsb);
		return newUUID;
	}

	public void storeUUID(ContentType contentType, int objectId, UUID uuid, int folderOwner) throws USMException {
	}

	public UUID getContextUUID() throws DatabaseAccessException, USMSQLException {
		return _UUIDHeader;
	}

	public void insertStoredUUID(DataObject o) throws DatabaseAccessException, USMSQLException {

	}

	public Folder getDummyContentTypeFolder(ContentType type) {
		return null;
	}

	public ContentType[] getContentTypes() throws DatabaseAccessException, USMSQLException {
		return null;
	}

	public UUID getUUID(ContentType contentType, int objectId) throws USMException {
		return null;
	}

	public int getMappedObjectId(ContentType contentType, UUID uuid) throws USMException {
		return 0;
	}

	public void remapCachedData(String oldObjectID, String newObjectID) throws DatabaseAccessException, USMSQLException {
	}

	public JSONObject getOXUserConfiguration(String... path) {
		return new JSONObject();
	}

	public void setContentTypeSorter(ContentType contentType, Comparator<? super DataObject> comparator) {
	}

	public long storeSyncState(long timestampToKeep, long timestamp, DataObject[] objects) throws USMException {
		// TODO Auto-generated method stub
		return 0;
	}

	public OXConnectionInformation getOXConnectionData() {
		return _oxConnectionData;
	}

	public void setOXConnectionData(OXConnectionInformation data) {
		_oxConnectionData = data;
	}

	public int getFolderIdLengthLimit() {
		// TODO Auto-generated method stub
		return 0;
	}

	public void setFolderIdLengthLimit(int limit) {
		// TODO Auto-generated method stub
		return;
	}

	public String getClientIp() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setClientIp(String ip) {
		// TODO Auto-generated method stub

	}

	public void resetClientIp(String ip) {
		// TODO Auto-generated method stub

	}

	public Map<String, String> getXRequestHeaders() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setXRequestHeaders(Map<String, String> headers) {
		// TODO Auto-generated method stub

	}

	public String getDefaultEmailAddress() {
		// TODO Auto-generated method stub
		return null;
	}

	public long getNewestTimestamp(String objectID) {
		// TODO Auto-generated method stub
		return 0;
	}

	public boolean needsSynchronization(String folderID) {
		return true;
	}

	public void invalidateCachedData(String folderID) {
	}
}
