/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.contenttypes;

import static com.openexchange.usm.api.datatypes.DataTypes.*;

import java.io.Serializable;

import com.openexchange.usm.api.datatypes.*;
import com.openexchange.usm.api.exceptions.DeserializationFailedException;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Session;

/**
 * @author afe
 *
 */
public class SimContentType implements ContentType {
	private static final ContentTypeField[] FIELDS = {
			new ContentTypeField(1, "id", STRING, false, true, false, false),
			new ContentTypeField(7, "folder_id", STRING, false, false, true, false),
			new ContentTypeField(2, "Field2", new ArrayDataType(STRING)),
			new ContentTypeField(3, "Field3", BOOLEAN),
			new ContentTypeField(4, "Field4", NUMBER),
			new ContentTypeField(5, "Field5", DATE),
			new ContentTypeField(6, "Field6", TIME),
			new ContentTypeField(8, "Field7", TIMESTAMP),
			new ContentTypeField(9, "created_by", STRING) };

	private final SimContentTypeTransferHandler _transferHandler = new SimContentTypeTransferHandler();

	public String getID() {
		return "SimContentType";
	}

	public ContentTypeField[] getFields() {
		return FIELDS;
	}

	public DataObject newDataObject(Session session) {
		return new SimDataObject(session, this);
	}

	public ContentTypeTransferHandler getTransferHandler() {
		return _transferHandler;
	}

	@Override
	public int hashCode() {
		return 31;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof SimContentType))
			return false;
		return true;
	}

	public int getMatchRating(DataObject client, DataObject server) {
		return -1;
	}

	public int getCode() {
		return 100;
	}

	public void deserializeData(Serializable[] data, int i, Object[] fieldContent)
			throws DeserializationFailedException {
		throw new UnsupportedOperationException();
	}

	public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
		// TODO Auto-generated method stub
		return 0L;
	}

	public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
		// TODO Auto-generated method stub
		return 0L;
	}

	public PIMAttachments getAllAttachments(DataObject object, String sort, String order) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public PIMAttachments getAllAttachments(DataObject object) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean supportsPIMAttachments() {
		// TODO Auto-generated method stub
		return false;
	}

	public Object getObjectGroupOwner(DataObject object) {
		// TODO Auto-generated method stub
		return object.getID();
	}

	public boolean canBeFolderElementsContentType() {
		return true;
	}
}
