/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/**
 * 
 */
package com.openexchange.usm.contenttypes.test;

import java.io.*;
import java.net.URLEncoder;
import java.util.*;
import java.util.regex.Pattern;

import junit.extensions.RepeatedTest;
import junit.framework.*;

import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.usm.api.contenttypes.*;
import com.openexchange.usm.api.session.*;
import com.openexchange.usm.journal.SimJournal;
import com.openexchange.usm.ox_json.SimOXJSONAcess;
import com.openexchange.usm.session.dataobject.*;
import com.openexchange.usm.test.results.TestObjectResult;

/**
 * Test Case for all content type transfer handlers. 
 * @author ldo
 *
 */
public class ContentTypeTransferHandlerTest extends TestCase {

	protected static Properties _props;

	protected SimJournal _journal;
	protected SimOXJSONAcess _oxAjaxAccess;
	protected ContentTypeTransferHandler _transferHandler;
	protected String _propsFile;
	protected String _requestPath;
	protected ContentType _contentType;
	protected SimSession _session = new SimSession();

	public static int counter = 0;

	protected static Test createTestSuite(String path, String name, Class<?> class1) {
		int size = (new File(path)).listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return Pattern.matches("test\\d+.properties", name);
			}
		}).length;
		// Create RepeatedTest, for each properties file one test:
		TestSuite mySuite = new TestSuite(name);
//		mySuite.addTestSuite(class1);
		return new RepeatedTest(mySuite, size);
	}

	protected void initialize(SimJournal journal, SimOXJSONAcess oxAjaxAccess,
			ContentTypeTransferHandler transferHandler, String propsFile, String requestPath, ContentType contentType)
			throws FileNotFoundException, IOException {
		_journal = journal;
		_oxAjaxAccess = oxAjaxAccess;
		_transferHandler = transferHandler;
		_propsFile = propsFile;
		_requestPath = requestPath;
		_oxAjaxAccess.setValidRequestPath(_requestPath);
		_contentType = contentType;
	}

	public void testIncreaseCounter() {
		counter++;
		loadProperties();
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#readDataObject(com.openexchange.usm.api.session.DataObject, java.util.BitSet)}.
	 */
	public void testReadDataObject() throws Exception {
		//read the initial data object
		String initialDatabject = _props.getProperty("readObjectInitialDataObject");
		SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
				initialDatabject);

		//read the ajax request
		String request = _props.getProperty("readObjectRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readObjectExpectedResult");
		validResult.setResult(new JSONObject(forJSON));
		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.readDataObject(dataObject, createRequestedFields(dataObject.getContentType()));

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("readObjectExpectedDataObject");
		SimpleDataObject expectedDataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session,
				_contentType, expectedDataObjectString);
		assertEquals("read end result mismatch", expectedDataObject.toString(), dataObject.toString());
	}

	private void loadProperties() {
		_props = new Properties();
		FileInputStream input = null;
		try {
			input = new FileInputStream(_propsFile + "test" + counter + ".properties");
			_props.load(input);
		} catch (FileNotFoundException e) {
			fail("Could not load properties file: " + _propsFile + "test" + counter + ".properties");
		} catch (IOException e) {
			fail("Could not load properties file: " + _propsFile + "test" + counter + ".properties");
		} finally {
			if (input != null) {
				try {
					input.close();
				} catch (IOException ignored) {
				}
			}
		}
	}

	protected BitSet createRequestedFields(ContentType type) {
		ContentTypeField[] fields = type.getFields();
		BitSet requestedFields = new BitSet();
		for (int i = 0; i < fields.length; i++) {
			if (fields[i].getFieldID() >= 0) {
				requestedFields.set(i);
			}
		}
		return requestedFields;
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#readFolderContent(com.openexchange.usm.api.session.Folder, java.util.BitSet)}.
	 */
	public void disabled_testReadFolderContent() throws Exception {
		//read the initial data object
		String parentFolderId = _props.getProperty("readFolderContentInitialFolderID");

		Folder folder = new FolderImpl(_session, new SimFolderContentType());
		folder.setElementsContentType(_contentType);
		folder.setID(parentFolderId);

		//read the ajax request
		String request = _props.getProperty("readFolderContentRequest");
		String columns = _props.getProperty("readFolderContentColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readFolderContentExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		DataObject[] resultArray = _transferHandler.readFolderContent(folder, createRequestedFields(_contentType));

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("readFolderContentExpectedDataObjectArray");
		DataObject[] expectedDataObjects = SimpleDataObjectTest.createTestDataObjectsFromStringArray(_session,
				_contentType, expectedDataObjectString);
		assertEquals("read folder result mismatch", Arrays.toString(expectedDataObjects), Arrays.toString(resultArray));
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#readUpdatedFolderContent(com.openexchange.usm.api.session.Folder, java.util.BitSet, long)}.
	 */
	public void testReadUpdatedFolderContent() throws Exception {
		//read the initial data object
		String parentFolderId = _props.getProperty("readFolderUpdatesInitialFolderID");

		Folder folder = new FolderImpl(_session, new SimFolderContentType());
		folder.setElementsContentType(_contentType);
		folder.setID(parentFolderId);
		//			folder.setParentFolderID(parentFolderId);

		//read the ajax request
		String request = _props.getProperty("readFolderUpdatesRequest");
		String columns = _props.getProperty("readFolderUpdatesColumns");
		try {
			request += URLEncoder.encode(columns, "UTF-8");
		} catch (UnsupportedEncodingException e1) {
			fail(e1.getMessage());
		}
		_oxAjaxAccess.setValidParamsString(request);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("readFolderUpdatesExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}
		_oxAjaxAccess.setValidResultToSend(validResult);

		String timestamp = _props.getProperty("readFolderUpdatesTimestamp");
		//call the tested handler
		DataObject[] resultArray = _transferHandler.readUpdatedFolderContent(folder,
				createRequestedFields(_contentType), new Long(timestamp).longValue());

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("readFolderUpdatesExpectedDataObjectArray");
		DataObject[] expectedDataObjects = SimpleDataObjectTest.createTestDataObjectsFromStringArray(_session,
				_contentType, expectedDataObjectString);
		assertEquals("read folder update result mismatch", Arrays.toString(expectedDataObjects), Arrays
				.toString(resultArray));
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#writeDeletedDataObject(com.openexchange.usm.api.session.DataObject)}.
	 */
	public void testWriteDeletedDataObject() throws Exception {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeDeletedInitialDataObject");
		SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
				initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeDeletedRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeDeletedExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeDeletedExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.writeDeletedDataObject(dataObject);

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("writeDeletedExpectedDataObject");
		SimpleDataObject expectedDataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session,
				_contentType, expectedDataObjectString);
		assertEquals("delete result mismatch", expectedDataObject.toString(), dataObject.toString());
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#writeNewDataObject(com.openexchange.usm.api.session.DataObject)}.
	 */
	public void testWriteNewDataObject() throws Exception {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeNewInitialDataObject");
		SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
				initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeNewRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeNewExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeNewExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		//call the tested handler
		_transferHandler.writeNewDataObject(dataObject);

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("writeNewExpectedDataObject");
		SimpleDataObject expectedDataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session,
				_contentType, expectedDataObjectString);
		assertEquals("new result mismatch", expectedDataObject.toString(), dataObject.toString());
	}

	/**
	 * Test method for {@link com.openexchange.usm.api.contenttypes.ContentTypeTransferHandler#writeUpdatedDataObject(com.openexchange.usm.api.session.DataObject, long)}.
	 */
	public void testWriteUpdatedDataObject() throws Exception {
		//read the initial data object
		String initialDatabject = _props.getProperty("writeModifiedInitialDataObject");
		SimpleDataObject dataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session, _contentType,
				initialDatabject);

		//read the ajax request
		String request = _props.getProperty("writeModifiedRequest");
		_oxAjaxAccess.setValidParamsString(request);

		//read the expected request body
		String requestBody = _props.getProperty("writeModifiedExpectedRequestBody");
		_oxAjaxAccess.setValidRequestBody(requestBody);

		//read and construct the result
		TestObjectResult validResult = new TestObjectResult();
		String forJSON = _props.getProperty("writeModifiedExpectedResult");
		try {
			validResult.setResult(new JSONObject(forJSON));
		} catch (JSONException e) {
			fail("Invalid object in properties file");
		}

		_oxAjaxAccess.setValidResultToSend(validResult);

		String timestamp = _props.getProperty("writeModifiedTimestamp");
		//call the tested handler
		_transferHandler.writeUpdatedDataObject(dataObject, new Long(timestamp).longValue());

		//compare the returned data object with the expected one
		String expectedDataObjectString = _props.getProperty("writeModifiedExpectedDataObject");
		SimpleDataObject expectedDataObject = SimpleDataObjectTest.createTestDataObjectFromString(_session,
				_contentType, expectedDataObjectString);
		assertEquals("change result mismatch", expectedDataObject.toString(), dataObject.toString());
	}
}
