/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.mdsws.cruisecontrol;

import java.io.File;
import java.util.SortedMap;
import java.util.TreeMap;

import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

import org.jdom.Element;

public class ArtifactsDeleter implements Publisher {
	private String fDir;
	private int fKeep;

	public ArtifactsDeleter() {
		fKeep = 10;
	}

	public void setDir(String dir) {
		this.fDir = dir;
	}

	public void setKeep(int keep) {
		this.fKeep = keep;
	}

	public void validate() throws CruiseControlException {
		ValidationHelper.assertIsSet(fDir, "dir", getClass());
	}

	public void publish(Element cruisecontrolLog) throws CruiseControlException {
		File[] artifactDirs = new File(fDir).listFiles();
		SortedMap artifactsMap = new TreeMap();
		for (int i = 0; i < artifactDirs.length; i++) {
			try {
				long timestamp = Long.parseLong(artifactDirs[i].getName());
				artifactsMap.put(new Long(timestamp), artifactDirs[i]);
			} catch (NumberFormatException e) {
				// ignored - not an artifacts dir
			}
		}

		for (int i = 0; i < artifactsMap.size() - fKeep; i++) {
			File artifactDir = (File) artifactsMap.remove(artifactsMap
					.firstKey());
			deleteDir(artifactDir);
		}
	}

	private void deleteDir(File path) {
		if (path.exists()) {
			File[] files = path.listFiles();
			for (int i = 0; i < files.length; i++) {
				if (files[i].isDirectory())
					deleteDir(files[i]);
				else
					files[i].delete();
			}
		}
		path.delete();
	}
}
