/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.build.ant.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;

import com.openexchange.build.ant.data.OSGIManifest;

public class BuildBundleJar extends Jar {
    private File bundleDir;
    private File destDir;
    private String binDirs;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    @Override
    public void setBasedir(File baseDir) {
        this.bundleDir = baseDir;
    }

    public void setBinDirs(String binDirs) {
        this.binDirs = binDirs;
    }

    @Override
    public void execute() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(bundleDir, "build.properties")));
            String binList = props.getProperty("bin.includes");
            log("bin.includes=" + binList);
            String[] split = binList.split(",");
            for (int i = 0; i < split.length; i++) {
                if (split[i].equals(".")) { // bin directory
                	String[] bins = binDirs.split(",");
                	for (int j = 0; j < bins.length; j++) {
                		File binDir = new File(bundleDir, bins[j]);
                        if (binDir.exists()) {
                            FileSet fileSet = new FileSet();
                            fileSet.setDir(binDir);
                            addFileset(fileSet);
                        }
					}
                } else {
                    FileSet fileSet = new FileSet();
                    fileSet.setDir(bundleDir);
                    File includedFile = new File(bundleDir, split[i]);
                    if (includedFile.isDirectory()) {
                        fileSet.createInclude().setName(split[i] + "/**");
                    } else {
                        fileSet.createInclude().setName(split[i]);
                    }
                    addFileset(fileSet);
                }
            }

            File manifest = new File(bundleDir, "META-INF/MANIFEST.MF");
            setManifest(manifest);

            OSGIManifest osgiManifest = new OSGIManifest(manifest);
            String jarName = osgiManifest.getEntry(OSGIManifest.BUNDLE_SYMBOLIC_NAME) + '_'
                    + osgiManifest.getEntry(OSGIManifest.BUNDLE_VERSION) + ".jar";
            setDestFile(new File(destDir, jarName));

            super.execute();

        } catch (FileNotFoundException e) {
            log("This project has no build.properties, it will not be built");
        } catch (IOException e) {
            throw new BuildException("error reading build.properties");
        }
    }
}
