/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.security.Permission;
import org.eclipse.equinox.internal.event.EventAdminMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public class EventHandlerWrapper {
    private final ServiceReference reference;
    private final LogService log;
    private final BundleContext context;
    private EventHandler handler;
    private String[] topics;
    private Filter filter;

    public EventHandlerWrapper(ServiceReference reference, BundleContext context, LogService log) {
        this.reference = reference;
        this.context = context;
        this.log = log;
    }

    public synchronized boolean init() {
        this.topics = null;
        this.filter = null;
        Object o = this.reference.getProperty("event.topics");
        if (o instanceof String) {
            this.topics = new String[]{(String)o};
        } else if (o instanceof String[]) {
            this.topics = (String[])o;
        }
        if (this.topics == null) {
            return false;
        }
        o = this.reference.getProperty("event.filter");
        if (o instanceof String) {
            try {
                this.filter = this.context.createFilter((String)o);
            }
            catch (InvalidSyntaxException e) {
                this.log.log(1, NLS.bind((String)EventAdminMsg.EVENT_INVALID_HANDLER_FILTER, (Object)o), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EventHandlerWrapper eventHandlerWrapper = this;
        synchronized (eventHandlerWrapper) {
            if (this.handler == null) {
                return;
            }
            this.handler = null;
        }
        this.context.ungetService(this.reference);
    }

    public synchronized String[] getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventHandler getHandler() {
        EventHandlerWrapper eventHandlerWrapper = this;
        synchronized (eventHandlerWrapper) {
            if (this.handler != null) {
                return this.handler;
            }
        }
        EventHandler tempHandler = (EventHandler)this.context.getService(this.reference);
        EventHandlerWrapper eventHandlerWrapper2 = this;
        synchronized (eventHandlerWrapper2) {
            if (this.handler == null) {
                this.handler = tempHandler;
                return this.handler;
            }
            tempHandler = this.handler;
        }
        this.context.ungetService(this.reference);
        return tempHandler;
    }

    private synchronized Filter getFilter() {
        return this.filter;
    }

    public void handleEvent(Event event, Permission perm) {
        Bundle bundle = this.reference.getBundle();
        if (bundle == null) {
            return;
        }
        Filter eventFilter = this.getFilter();
        if (eventFilter != null && !event.matches(eventFilter)) {
            return;
        }
        if (perm != null && !bundle.hasPermission((Object)perm)) {
            return;
        }
        EventHandler handlerService = this.getHandler();
        if (handlerService == null) {
            return;
        }
        try {
            handlerService.handleEvent(event);
        }
        catch (Throwable t) {
            this.log.log(1, NLS.bind((String)EventAdminMsg.EVENT_DISPATCH_HANDLER_EXCEPTION, (Object)event, (Object)handlerService), t);
        }
    }
}

