/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTInitializer;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedPrivateMethodRule
extends AbstractRule {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTInitializer;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = ((ClassScope)node.getScope()).getMethodDeclarations();
        for (MethodNameDeclaration mnd : this.findUnique(methods)) {
            List<NameOccurrence> occs = methods.get(mnd);
            if (!this.privateAndNotExcluded(mnd)) continue;
            if (occs.isEmpty()) {
                this.addViolation(data, mnd.getNode(), new StringBuffer().append(mnd.getImage()).append(mnd.getParameterDisplaySignature()).toString());
                continue;
            }
            if (!this.calledFromOutsideItself(occs, mnd)) continue;
            this.addViolation(data, mnd.getNode(), new StringBuffer().append(mnd.getImage()).append(mnd.getParameterDisplaySignature()).toString());
        }
        return data;
    }

    private Set<MethodNameDeclaration> findUnique(Map<MethodNameDeclaration, List<NameOccurrence>> methods) {
        HashSet<MethodNameDeclaration> unique = new HashSet<MethodNameDeclaration>();
        HashSet<String> sigs = new HashSet<String>();
        for (MethodNameDeclaration mnd : methods.keySet()) {
            String sig = new StringBuffer().append(mnd.getImage()).append(mnd.getParameterCount()).toString();
            if (!sigs.contains(sig)) {
                unique.add(mnd);
            }
            sigs.add(sig);
        }
        return unique;
    }

    private boolean calledFromOutsideItself(List<NameOccurrence> occs, MethodNameDeclaration mnd) {
        int callsFromOutsideMethod = 0;
        for (NameOccurrence occ : occs) {
            ASTMethodDeclaration enclosingMethod;
            ASTInitializer enclosingInitializer;
            ASTConstructorDeclaration enclosingConstructor;
            SimpleNode occNode = occ.getLocation();
            Class<?> clazz = class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
            if (clazz == null) {
                clazz = new ASTConstructorDeclaration[0].getClass().getComponentType();
            }
            if ((enclosingConstructor = (ASTConstructorDeclaration)occNode.getFirstParentOfType(clazz)) != null) {
                ++callsFromOutsideMethod;
                break;
            }
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTInitializer;
            if (clazz2 == null) {
                clazz2 = new ASTInitializer[0].getClass().getComponentType();
            }
            if ((enclosingInitializer = (ASTInitializer)occNode.getFirstParentOfType(clazz2)) != null) {
                ++callsFromOutsideMethod;
                break;
            }
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
            if (clazz3 == null) {
                clazz3 = new ASTMethodDeclaration[0].getClass().getComponentType();
            }
            if ((enclosingMethod = (ASTMethodDeclaration)occNode.getFirstParentOfType(clazz3)) != null && mnd.getNode().jjtGetParent().equals(enclosingMethod)) continue;
            ++callsFromOutsideMethod;
        }
        return callsFromOutsideMethod == 0;
    }

    private boolean privateAndNotExcluded(MethodNameDeclaration mnd) {
        ASTMethodDeclarator node = (ASTMethodDeclarator)mnd.getNode();
        return ((AccessNode)node.jjtGetParent()).isPrivate() && !node.hasImageEqualTo("readObject") && !node.hasImageEqualTo("writeObject") && !node.hasImageEqualTo("readResolve") && !node.hasImageEqualTo("writeReplace");
    }
}

