/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTArguments;
import net.sourceforge.pmd.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;

public class AccessorClassGeneration
extends AbstractRule {
    private List<ClassData> classDataList = new ArrayList<ClassData>();
    private int classID = -1;
    private String packageName;

    public Object visit(ASTEnumDeclaration node, Object data) {
        return data;
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.classDataList.clear();
        this.packageName = node.getScope().getEnclosingSourceFileScope().getPackageName();
        return super.visit(node, data);
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            if (!(node.jjtGetParent().jjtGetParent() instanceof ASTCompilationUnit)) {
                String interfaceName = node.getImage();
                int formerID = this.getClassID();
                this.setClassID(this.classDataList.size());
                ClassData newClassData = new ClassData(interfaceName);
                ClassData formerClassData = this.classDataList.get(formerID);
                newClassData.addClassQualifyingName(formerClassData.getClassName());
                this.classDataList.add(this.getClassID(), newClassData);
                Object o = super.visit(node, data);
                this.setClassID(formerID);
                return o;
            }
            String interfaceName = node.getImage();
            this.classDataList.clear();
            this.setClassID(0);
            this.classDataList.add(this.getClassID(), new ClassData(interfaceName));
            Object o = super.visit(node, data);
            if (o != null) {
                this.processRule(o);
            } else {
                this.processRule(data);
            }
            this.setClassID(-1);
            return o;
        }
        if (!(node.jjtGetParent().jjtGetParent() instanceof ASTCompilationUnit)) {
            String className = node.getImage();
            int formerID = this.getClassID();
            this.setClassID(this.classDataList.size());
            ClassData newClassData = new ClassData(className);
            if (formerID == -1 || formerID >= this.classDataList.size()) {
                return null;
            }
            ClassData formerClassData = this.classDataList.get(formerID);
            newClassData.addClassQualifyingName(formerClassData.getClassName());
            this.classDataList.add(this.getClassID(), newClassData);
            Object o = super.visit(node, data);
            this.setClassID(formerID);
            return o;
        }
        String className = node.getImage();
        this.classDataList.clear();
        this.setClassID(0);
        this.classDataList.add(this.getClassID(), new ClassData(className));
        Object o = super.visit(node, data);
        if (o != null) {
            this.processRule(o);
        } else {
            this.processRule(data);
        }
        this.setClassID(-1);
        return o;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.isPrivate()) {
            this.getCurrentClassData().addConstructor(node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.classID == -1 || this.getCurrentClassData() == null) {
            return data;
        }
        AllocData ad = new AllocData(node, this.packageName, this.getCurrentClassData().getClassQualifyingNamesList());
        if (!ad.isArray()) {
            this.getCurrentClassData().addInstantiation(ad);
        }
        return super.visit(node, data);
    }

    private void processRule(Object ctx) {
        Iterator<ClassData> i$ = this.classDataList.iterator();
        while (i$.hasNext()) {
            ClassData outerDataSet = i$.next();
            Iterator<ASTConstructorDeclaration> constructors = outerDataSet.getPrivateConstructorIterator();
            while (constructors.hasNext()) {
                ASTConstructorDeclaration cd = constructors.next();
                Iterator<ClassData> i$2 = this.classDataList.iterator();
                while (i$2.hasNext()) {
                    ClassData innerDataSet = i$2.next();
                    if (outerDataSet == innerDataSet) continue;
                    Iterator<AllocData> allocations = innerDataSet.getInstantiationIterator();
                    while (allocations.hasNext()) {
                        AllocData ad = allocations.next();
                        if (!outerDataSet.getClassName().equals(ad.getName()) || cd.getParameterCount() != ad.getArgumentCount()) continue;
                        this.addViolation(ctx, ad.getASTAllocationExpression());
                    }
                }
            }
        }
    }

    private ClassData getCurrentClassData() {
        if (this.classID >= this.classDataList.size()) {
            return null;
        }
        return this.classDataList.get(this.classID);
    }

    private void setClassID(int ID) {
        this.classID = ID;
    }

    private int getClassID() {
        return this.classID;
    }

    private static String stripString(String remove, String value) {
        int index = value.indexOf(remove);
        String returnValue = index != -1 ? value.substring(0, index) + value.substring(index + remove.length()) : value;
        return returnValue;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllocData {
        private String m_Name;
        private int m_ArgumentCount;
        private ASTAllocationExpression m_ASTAllocationExpression;
        private boolean isArray;

        public AllocData(ASTAllocationExpression node, String aPackageName, List<String> classQualifyingNames) {
            if (node.jjtGetChild(1) instanceof ASTArguments) {
                ASTArguments aa = (ASTArguments)node.jjtGetChild(1);
                this.m_ArgumentCount = aa.getArgumentCount();
                if (!(node.jjtGetChild(0) instanceof ASTClassOrInterfaceType)) {
                    throw new RuntimeException(new StringBuffer().append("BUG: Expected a ASTClassOrInterfaceType, got a ").append(node.jjtGetChild(0).getClass()).toString());
                }
                ASTClassOrInterfaceType an = (ASTClassOrInterfaceType)node.jjtGetChild(0);
                this.m_Name = AccessorClassGeneration.stripString(new StringBuffer().append(aPackageName).append(".").toString(), an.getImage());
                String findName = "";
                ListIterator<String> li = classQualifyingNames.listIterator(classQualifyingNames.size());
                while (li.hasPrevious()) {
                    String aName = li.previous();
                    findName = new StringBuffer().append(aName).append(".").append(findName).toString();
                    if (!this.m_Name.startsWith(findName)) continue;
                    this.m_Name = this.m_Name.substring(findName.length());
                    break;
                }
            } else if (node.jjtGetChild(1) instanceof ASTArrayDimsAndInits) {
                this.isArray = true;
            }
            this.m_ASTAllocationExpression = node;
        }

        public String getName() {
            return this.m_Name;
        }

        public int getArgumentCount() {
            return this.m_ArgumentCount;
        }

        public ASTAllocationExpression getASTAllocationExpression() {
            return this.m_ASTAllocationExpression;
        }

        public boolean isArray() {
            return this.isArray;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassData {
        private String m_ClassName;
        private List<ASTConstructorDeclaration> m_PrivateConstructors;
        private List<AllocData> m_Instantiations;
        private List<String> m_ClassQualifyingNames;

        public ClassData(String className) {
            this.m_ClassName = className;
            this.m_PrivateConstructors = new ArrayList<ASTConstructorDeclaration>();
            this.m_Instantiations = new ArrayList<AllocData>();
            this.m_ClassQualifyingNames = new ArrayList<String>();
        }

        public void addInstantiation(AllocData ad) {
            this.m_Instantiations.add(ad);
        }

        public Iterator<AllocData> getInstantiationIterator() {
            return this.m_Instantiations.iterator();
        }

        public void addConstructor(ASTConstructorDeclaration cd) {
            this.m_PrivateConstructors.add(cd);
        }

        public Iterator<ASTConstructorDeclaration> getPrivateConstructorIterator() {
            return this.m_PrivateConstructors.iterator();
        }

        public String getClassName() {
            return this.m_ClassName;
        }

        public void addClassQualifyingName(String name) {
            this.m_ClassQualifyingNames.add(name);
        }

        public List<String> getClassQualifyingNamesList() {
            return this.m_ClassQualifyingNames;
        }
    }
}

