/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;

public abstract class AbstractPMDProperty
implements PropertyDescriptor {
    private String name;
    private String description;
    private Object defaultValue;
    private boolean isRequired = false;
    private int maxValueCount = 1;
    private float uiOrder;
    protected char multiValueDelimiter = (char)124;

    protected AbstractPMDProperty(String theName, String theDescription, Object theDefault, float theUIOrder) {
        this.name = theName;
        this.description = theDescription;
        this.defaultValue = theDefault;
        this.uiOrder = theUIOrder;
    }

    protected void multiValueDelimiter(char aDelimiter) {
        this.multiValueDelimiter = aDelimiter;
    }

    public char multiValueDelimiter() {
        return this.multiValueDelimiter;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public int maxValueCount() {
        return this.maxValueCount;
    }

    protected void maxValueCount(int theCount) {
        this.maxValueCount = theCount;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public float uiOrder() {
        return this.uiOrder;
    }

    protected String asString(Object value) {
        return value == null ? "" : value.toString();
    }

    public String asDelimitedString(Object values) {
        if (values == null) {
            return "";
        }
        if (values instanceof Object[]) {
            Object[] valueSet = (Object[])values;
            if (valueSet.length == 0) {
                return "";
            }
            if (valueSet.length == 1) {
                return this.asString(valueSet[0]);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(this.asString(valueSet[0]));
            for (int i = 1; i < valueSet.length; ++i) {
                sb.append(this.multiValueDelimiter);
                sb.append(this.asString(valueSet[i]));
            }
            return sb.toString();
        }
        return this.asString(values);
    }

    public int compareTo(PropertyDescriptor otherProperty) {
        float otherOrder = otherProperty.uiOrder();
        return (int)(otherOrder - this.uiOrder);
    }

    public String errorFor(Object value) {
        String typeError = this.typeErrorFor(value);
        if (typeError != null) {
            return typeError;
        }
        return this.valueErrorFor(value);
    }

    protected String valueErrorFor(Object value) {
        return null;
    }

    protected boolean isArray(Object value) {
        return value != null && value.getClass().getComponentType() != null;
    }

    protected String typeErrorFor(Object value) {
        if (value == null && !this.isRequired) {
            return null;
        }
        if (this.maxValueCount > 1) {
            if (!this.isArray(value)) {
                return "Value is not an array of type: " + this.type();
            }
            Class<?> arrayType = value.getClass().getComponentType();
            if (arrayType == null || !arrayType.isAssignableFrom(this.type())) {
                return "Value is not an array of type: " + this.type();
            }
            return null;
        }
        if (!this.type().isAssignableFrom(value.getClass())) {
            return value + " is not an instance of " + this.type();
        }
        return null;
    }

    public String propertyErrorFor(Rule rule) {
        String strValue = rule.getStringProperty(this.name());
        if (strValue == null && !this.isRequired()) {
            return null;
        }
        Object realValue = this.valueFrom(strValue);
        return this.errorFor(realValue);
    }

    public Object[][] choices() {
        return null;
    }

    public int preferredRowCount() {
        return 1;
    }

    public static final boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        return value.equals(otherValue);
    }

    public int compareTo(Object x0) {
        return this.compareTo((PropertyDescriptor)x0);
    }
}

