/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jaxen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jaxen.Attribute;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AttributeAxisIterator
implements Iterator<Attribute> {
    private Attribute currObj;
    private MethodWrapper[] methodWrappers;
    private int position;
    private Node node;
    private static Map<Class, MethodWrapper[]> methodCache = new HashMap<Class, MethodWrapper[]>();
    private static final /* synthetic */ Class class$java$lang$String;

    public AttributeAxisIterator(Node contextNode) {
        this.node = contextNode;
        if (!methodCache.containsKey(contextNode.getClass())) {
            Method[] preFilter = contextNode.getClass().getMethods();
            ArrayList<MethodWrapper> postFilter = new ArrayList<MethodWrapper>();
            for (int i = 0; i < preFilter.length; ++i) {
                if (!this.isAttributeAccessor(preFilter[i])) continue;
                postFilter.add(new MethodWrapper(preFilter[i]));
            }
            methodCache.put(contextNode.getClass(), postFilter.toArray(new MethodWrapper[postFilter.size()]));
        }
        this.methodWrappers = methodCache.get(contextNode.getClass());
        this.position = 0;
        this.currObj = this.getNextAttribute();
    }

    @Override
    public Attribute next() {
        if (this.currObj == null) {
            throw new IndexOutOfBoundsException();
        }
        Attribute ret = this.currObj;
        this.currObj = this.getNextAttribute();
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.currObj != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Attribute getNextAttribute() {
        if (this.position == this.methodWrappers.length) {
            return null;
        }
        MethodWrapper m = this.methodWrappers[this.position++];
        return new Attribute(this.node, m.name, m.method);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAttributeAccessor(Method method) {
        String methodName = method.getName();
        if (Integer.TYPE != method.getReturnType() && Boolean.TYPE != method.getReturnType()) {
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            if (clazz != method.getReturnType()) return false;
        }
        if (method.getParameterTypes().length != 0) return false;
        if (Void.TYPE == method.getReturnType()) return false;
        if (methodName.startsWith("jjt")) return false;
        if (methodName.equals("toString")) return false;
        if (methodName.equals("getScope")) return false;
        if (methodName.equals("getClass")) return false;
        if (methodName.equals("getTypeNameNode")) return false;
        if (methodName.equals("getImportedNameNode")) return false;
        if (methodName.equals("hashCode")) return false;
        return true;
    }

    @Override
    public Object next() {
        return this.next();
    }

    private static class MethodWrapper {
        public Method method;
        public String name;

        public MethodWrapper(Method m) {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                return n.substring("get".length());
            }
            if (n.startsWith("is")) {
                return n.substring("is".length());
            }
            if (n.startsWith("has")) {
                return n.substring("has".length());
            }
            if (n.startsWith("uses")) {
                return n.substring("uses".length());
            }
            return n;
        }
    }
}

