/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.translator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.retroweaver.RetroWeaverException;
import net.sourceforge.retroweaver.translator.ClassMirror;
import net.sourceforge.retroweaver.translator.MethodsMirror;
import net.sourceforge.retroweaver.translator.Mirror;
import net.sourceforge.retroweaver.translator.NameSpace;
import net.sourceforge.retroweaver.translator.NoMirror;
import org.objectweb.asm.Type;

public class NameTranslator {
    private static final NameSpace defaultNamespace = new NameSpace("", "net.sourceforge.retroweaver.runtime");
    private static final NameSpace concurrentNamespace = new NameSpace("java.util.concurrent", "edu.emory.mathcs.backport.java.util.concurrent");
    private static final String[] javaUtilClasses = new String[]{"AbstractQueue", "ArrayDeque", "Deque", "NavigableMap", "NavigableSet", "PriorityQueue", "Queue"};
    private static final Mirror noMirror = new NoMirror();
    private final List<NameSpace> namespaces = new LinkedList<NameSpace>();
    private final Map<String, Mirror> mirrors = new HashMap<String, Mirror>();
    private static final NameTranslator generalTranslator = new NameTranslator();
    private static final NameTranslator stringBuilderTranslator;
    private static final /* synthetic */ Class class$java$lang$StringBuffer;

    public static final NameTranslator getGeneralTranslator() {
        return generalTranslator;
    }

    public static final NameTranslator getStringBuilderTranslator() {
        return stringBuilderTranslator;
    }

    private NameTranslator() {
    }

    public void addNameSpace(NameSpace nameSpace) {
        this.namespaces.add(nameSpace);
    }

    protected Mirror getMirror(String class_) {
        if (class_ == null) {
            return noMirror;
        }
        Mirror cachedMirror = this.mirrors.get(class_);
        if (cachedMirror != null) {
            return cachedMirror;
        }
        Iterator<NameSpace> i$ = this.namespaces.iterator();
        while (i$.hasNext()) {
            NameSpace n = i$.next();
            String mirrorClass = n.getMirrorClassName(class_);
            if (mirrorClass == null) continue;
            mirrorClass = mirrorClass.replace('/', '.');
            try {
                Class<?> clazz = Class.forName(mirrorClass);
                ClassMirror mirror = new ClassMirror(clazz);
                this.mirrors.put(class_, mirror);
                return mirror;
            }
            catch (ClassNotFoundException e) {
                mirrorClass = mirrorClass + '_';
                try {
                    Class<?> clazz = Class.forName(mirrorClass);
                    MethodsMirror mirror = new MethodsMirror(clazz);
                    this.mirrors.put(class_, mirror);
                    return mirror;
                }
                catch (ClassNotFoundException e2) {
                }
            }
        }
        this.mirrors.put(class_, noMirror);
        return noMirror;
    }

    protected String translate(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        this.translate(false, name, buffer, 0, name.length());
        return buffer.toString();
    }

    private String getMirrorTranslation(String name) {
        Mirror mirror = this.getMirror(name);
        return mirror.exists() ? mirror.getTranslatedName() : name;
    }

    public String getClassMirrorTranslation(String name) {
        Mirror mirror = this.getMirror(name);
        return mirror.isClassMirror() ? mirror.getTranslatedName() : name;
    }

    public String getClassMirrorTranslationDescriptor(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        this.translate(true, name, buffer, 0, name.length());
        return buffer.toString();
    }

    private void translate(boolean classMirrorsOnly, String in, StringBuffer out, int start, int end) {
        if (start >= end) {
            return;
        }
        char firstChar = in.charAt(start);
        switch (firstChar) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': 
            case '[': {
                out.append(firstChar);
                this.translate(classMirrorsOnly, in, out, start + 1, end);
                break;
            }
            case 'L': {
                int endName = in.indexOf(59, start + 1);
                if (endName == -1) {
                    String name = in.substring(start, end);
                    String newName = classMirrorsOnly ? this.getClassMirrorTranslation(name) : this.getMirrorTranslation(name);
                    out.append(newName);
                    break;
                }
                String className = in.substring(start + 1, endName);
                String newClassName = classMirrorsOnly ? this.getClassMirrorTranslation(className) : this.getMirrorTranslation(className);
                out.append('L').append(newClassName).append(';');
                this.translate(classMirrorsOnly, in, out, endName + 1, end);
                break;
            }
            case '(': {
                int endArgs = in.indexOf(41, start + 1);
                if (endArgs == -1) {
                    throw new RetroWeaverException("Class name parsing error: missing ')' in " + in);
                }
                out.append('(');
                if (endArgs != start + 1) {
                    this.translate(classMirrorsOnly, in, out, start + 1, endArgs);
                }
                out.append(')');
                this.translate(classMirrorsOnly, in, out, endArgs + 1, end);
                break;
            }
            default: {
                String name = in.substring(start, end);
                String newName = classMirrorsOnly ? this.getClassMirrorTranslation(name) : this.getMirrorTranslation(name);
                out.append(newName);
            }
        }
    }

    protected String translateMethodDescriptor(String descriptor) {
        Type[] argTypes = Type.getArgumentTypes((String)descriptor);
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = this.getMirrorType(argTypes[i]);
        }
        Type returnType = this.getMirrorType(Type.getReturnType((String)descriptor));
        return Type.getMethodDescriptor((Type)returnType, (Type[])argTypes);
    }

    protected String translateDescriptor(String descriptor) {
        Type type = Type.getType((String)descriptor);
        type = this.getMirrorType(type);
        return type.getDescriptor();
    }

    private Type getMirrorType(Type type) {
        Type basicType;
        int numDimensions = 0;
        if (type.getSort() == 9) {
            numDimensions = type.getDimensions();
            basicType = type.getElementType();
        } else {
            basicType = type;
        }
        if (basicType.getSort() != 10) {
            return type;
        }
        Mirror mirror = this.getMirror(basicType.getInternalName());
        if (mirror.isClassMirror()) {
            StringBuffer name = new StringBuffer();
            for (int i = 0; i < numDimensions; ++i) {
                name.append('[');
            }
            name.append('L').append(mirror.getTranslatedName()).append(';');
            return Type.getType((String)name.toString());
        }
        return type;
    }

    static {
        generalTranslator.addNameSpace(defaultNamespace);
        generalTranslator.addNameSpace(concurrentNamespace);
        String[] arr$ = javaUtilClasses;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            NameSpace n = new NameSpace("java.util." + s, "edu.emory.mathcs.backport.java.util." + s);
            generalTranslator.addNameSpace(n);
        }
        stringBuilderTranslator = new NameTranslator();
        Map<String, Mirror> map = NameTranslator.stringBuilderTranslator.mirrors;
        Class<?> clazz = class$java$lang$StringBuffer;
        if (clazz == null) {
            clazz = class$java$lang$StringBuffer = new StringBuffer[0].getClass().getComponentType();
        }
        map.put("java/lang/StringBuilder", new ClassMirror(clazz));
    }
}

