/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.retroweaver.RetroWeaverClassLoader;
import net.sourceforge.retroweaver.event.VerifierListener;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefVerifier
extends ClassAdapter {
    private final int target;
    private String currentclassName;
    private final RetroWeaverClassLoader classLoader;
    private final List<String> classPathArray;
    private Set<String> failedClasses;
    private final VerifierListener listener;
    private int warningCount;
    private final List<String> classes;
    private final Map<String, SoftReference<ClassReader>> classReaderCache = new HashMap<String, SoftReference<ClassReader>>();
    private static final String nl = System.getProperty("line.separator");
    private static final EmptyVisitor EMPTY_VISITOR = new EmptyVisitor();

    public RefVerifier(int target, ClassVisitor cv, List<String> classPathArray, VerifierListener listener) {
        super(cv);
        this.classLoader = new RetroWeaverClassLoader();
        this.classPathArray = classPathArray;
        this.listener = listener;
        this.target = target;
        this.classes = new LinkedList<String>();
    }

    public void addClass(String className) {
        this.classes.add(className);
    }

    public void verifyJarFile(String jarFileName) throws IOException {
        JarFile jarFile = new JarFile(jarFileName);
        int count = this.classes.size();
        if (count > 0) {
            this.listener.verifyPathStarted(new StringBuffer().append("Verifying ").append(count).append(count == 1 ? " class" : " classes").toString());
        }
        this.classLoader.setClassPath(this.classPathArray);
        for (String name : this.classes) {
            JarEntry entry = jarFile.getJarEntry(name);
            InputStream is = jarFile.getInputStream(entry);
            this.verifyClass(is);
        }
    }

    public void verifyFiles() throws IOException {
        int count = this.classes.size();
        if (count > 0) {
            this.listener.verifyPathStarted(new StringBuffer().append("Verifying ").append(count).append(count == 1 ? " class" : " classes").toString());
        }
        this.classLoader.setClassPath(this.classPathArray);
        for (String sourcePath : this.classes) {
            this.verifyClass(new FileInputStream(sourcePath));
        }
    }

    private void verifySingleClass(String classFileName) throws IOException {
        this.classLoader.setClassPath(this.classPathArray);
        this.verifyClass(new FileInputStream(classFileName));
    }

    private void verifyClass(InputStream sourceStream) throws IOException {
        this.failedClasses = new HashSet<String>();
        ClassReader cr = new ClassReader(sourceStream);
        cr.accept((ClassVisitor)this, 0);
    }

    private void unknowClassWarning(String className, String msg) {
        StringBuffer report = new StringBuffer().append(this.currentclassName).append(": unknown class ").append(className);
        if (msg != null) {
            report.append(": ").append(msg);
        }
        this.warning(report);
    }

    private void unknownFieldWarning(String name, String desc, String msg) {
        StringBuffer report = new StringBuffer().append(this.currentclassName).append(": unknown field ").append(name).append('/').append(desc.replace('/', '.'));
        if (msg != null) {
            report.append(", ").append(msg);
        }
        this.warning(report);
    }

    private void unknownMethodWarning(String name, String desc, String msg) {
        StringBuffer report = new StringBuffer().append(this.currentclassName).append(": unknown method ").append(name).append('/').append(desc.replace('/', '.'));
        if (msg != null) {
            report.append(", ").append(msg);
        }
        this.warning(report);
    }

    private void invalidClassVersion(String className, int target, int version) {
        StringBuffer report = new StringBuffer().append(className).append(": invalid class version ").append(version).append(", target is ").append(target);
        this.warning(report);
    }

    private void warning(StringBuffer report) {
        ++this.warningCount;
        this.listener.acceptWarning(report.toString());
    }

    public void displaySummary() {
        if (this.warningCount != 0) {
            this.listener.displaySummary(this.warningCount);
        }
    }

    private ClassReader getClassReader(String className) throws ClassNotFoundException {
        ClassReader reader = null;
        SoftReference<ClassReader> ref = this.classReaderCache.get(className);
        if (ref != null) {
            reader = ref.get();
        }
        if (reader == null) {
            byte[] b = this.classLoader.getClassData(className);
            reader = new ClassReader(b);
            this.classReaderCache.put(className, new SoftReference<ClassReader>(reader));
            short version = reader.readShort(6);
            if (version > this.target) {
                this.invalidClassVersion(className.replace('/', '.'), this.target, version);
            }
        }
        return reader;
    }

    public static String getUsage() {
        return new StringBuffer().append("Usage: RefVerifier <options>").append(nl).append(" Options: ").append(nl).append(" -class <path to class to verify> (required) ").append(nl).append(" -cp <classpath containing valid classes> (required)").toString();
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> classpath = new ArrayList<String>();
        String classfile = null;
        for (int i = 0; i < args.length; ++i) {
            String command = args[i];
            ++i;
            if ("-class".equals(command)) {
                classfile = args[i];
                continue;
            }
            if ("-cp".equals(command)) {
                String path = args[i];
                StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    classpath.add(st.nextToken());
                }
                continue;
            }
            System.out.println(new StringBuffer().append("I don't understand the command: ").append(command).toString());
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        if (classfile == null) {
            System.out.println("Option \"-class\" is required.");
            System.out.println();
            System.out.println(RefVerifier.getUsage());
            return;
        }
        RefVerifier vr = new RefVerifier(48, (ClassVisitor)EMPTY_VISITOR, classpath, new DefaultListener(true));
        vr.verifySingleClass(classfile);
        vr.displaySummary();
    }

    private void checkClassName(String className) {
        String name;
        Type t = Type.getType((String)className);
        switch (t.getSort()) {
            case 9: {
                t = t.getElementType();
                if (t.getSort() != 10) {
                    return;
                }
            }
            case 10: {
                name = t.getClassName();
                break;
            }
            default: {
                return;
            }
        }
        this.checkSimpleClassName(name);
    }

    private void checkClassNameInType(String className) {
        switch (className.charAt(0)) {
            case 'L': 
            case '[': {
                this.checkClassName(className);
                break;
            }
            default: {
                this.checkSimpleClassName(className);
            }
        }
    }

    private void checkSimpleClassName(String className) {
        String name = className.replace('.', '/');
        try {
            this.getClassReader(name);
        }
        catch (ClassNotFoundException e) {
            this.failedClasses.add(name);
            this.unknowClassWarning(name.replace('/', '.'), null);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.listener.verifyClassStarted(new StringBuffer().append("Verifying ").append(name).toString());
        this.currentclassName = name.replace('/', '.');
        if (superName != null) {
            this.checkSimpleClassName(superName);
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.checkSimpleClassName(interfaces[i]);
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.checkSimpleClassName(owner);
        this.cv.visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name != null) {
            this.checkSimpleClassName(name);
        }
        if (outerName != null) {
            this.checkSimpleClassName(outerName);
        }
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null) {
            for (String s : exceptions) {
                this.checkSimpleClassName(s);
            }
        }
        return new MethodVerifier(this.cv.visitMethod(access, name, desc, signature, exceptions));
    }

    private boolean findField(String owner, String name, String c) throws ClassNotFoundException {
        String javaClassName = owner;
        while (true) {
            String[] is;
            ClassReader reader = this.getClassReader(javaClassName);
            FindFieldOrMethodClassVisitor visitor = new FindFieldOrMethodClassVisitor(false, name, c);
            try {
                reader.accept((ClassVisitor)visitor, 0);
            }
            catch (Success s) {
                return true;
            }
            for (String i : is = visitor.classInterfaces) {
                if (!this.findField(i, name, c)) continue;
                return true;
            }
            if ("java/lang/Object".equals(javaClassName)) {
                return false;
            }
            javaClassName = visitor.superClassName;
        }
    }

    private boolean findMethod(String owner, String name, String desc) throws ClassNotFoundException {
        String javaClassName = owner;
        while (true) {
            ClassReader reader = this.getClassReader(javaClassName);
            FindFieldOrMethodClassVisitor visitor = new FindFieldOrMethodClassVisitor(true, name, desc);
            try {
                reader.accept((ClassVisitor)visitor, 0);
            }
            catch (Success s) {
                return true;
            }
            if (visitor.isInterface || visitor.isAbstract) {
                String[] is;
                for (String i : is = visitor.classInterfaces) {
                    if (!this.findMethod(i, name, desc)) continue;
                    return true;
                }
                if (visitor.isInterface) {
                    return false;
                }
            }
            if ("java/lang/Object".equals(javaClassName)) {
                return false;
            }
            javaClassName = visitor.superClassName;
        }
    }

    public static class DefaultListener
    implements VerifierListener {
        private final boolean verbose;

        DefaultListener(boolean verbose) {
            this.verbose = verbose;
        }

        public void verifyPathStarted(String msg) {
            System.out.println("[RefVerifier] " + msg);
        }

        public void verifyClassStarted(String msg) {
            if (this.verbose) {
                System.out.println("[RefVerifier] " + msg);
            }
        }

        public void acceptWarning(String msg) {
            System.out.println("[RefVerifier] " + msg);
        }

        public void displaySummary(int warningCount) {
            System.out.println("[RefVerifier] Verification complete, " + warningCount + " warning(s).");
        }
    }

    private static class FindFieldOrMethodClassVisitor
    implements ClassVisitor {
        private final boolean methdodMatcher;
        private final String searchedName;
        private final String searchedDesc;
        protected String[] classInterfaces;
        protected String superClassName;
        protected boolean isInterface;
        protected boolean isAbstract;

        FindFieldOrMethodClassVisitor(boolean methdodMatcher, String name, String desc) {
            this.searchedName = name;
            this.searchedDesc = desc;
            this.methdodMatcher = methdodMatcher;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classInterfaces = interfaces;
            this.superClassName = superName;
            this.isInterface = (access & 0x200) != 0;
            this.isAbstract = (access & 0x400) != 0;
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return EMPTY_VISITOR;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (!this.methdodMatcher && name.equals(this.searchedName) && desc.equals(this.searchedDesc)) {
                throw new Success();
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methdodMatcher && name.equals(this.searchedName) && desc.equals(this.searchedDesc)) {
                throw new Success();
            }
            return null;
        }

        public void visitEnd() {
        }
    }

    private static class Success
    extends RuntimeException {
        private Success() {
        }
    }

    private class MethodVerifier
    extends MethodAdapter {
        MethodVerifier(MethodVisitor mv) {
            super(mv);
        }

        public void visitTypeInsn(int opcode, String desc) {
            RefVerifier.this.checkClassNameInType(desc);
            this.mv.visitTypeInsn(opcode, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!RefVerifier.this.failedClasses.contains(owner)) {
                try {
                    if (!RefVerifier.this.findField(owner, name, desc)) {
                        RefVerifier.this.unknownFieldWarning(name, desc, "Field not found in " + owner.replace('/', '.'));
                    }
                }
                catch (ClassNotFoundException e) {
                    RefVerifier.this.unknownFieldWarning(name, desc, "The class, " + owner.replace('/', '.') + ", could not be located: " + e.getMessage());
                }
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (!RefVerifier.this.failedClasses.contains(owner) && owner.charAt(0) != '[') {
                try {
                    if (!RefVerifier.this.findMethod(owner, name, desc)) {
                        RefVerifier.this.unknownMethodWarning(name, desc, "Method not found in " + owner.replace('/', '.'));
                    }
                }
                catch (ClassNotFoundException e) {
                    RefVerifier.this.unknownMethodWarning(name, desc, "The class, " + owner.replace('/', '.') + ", could not be located: " + e.getMessage());
                }
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            RefVerifier.this.checkClassName(desc);
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            RefVerifier.this.checkClassName(desc);
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }
}

