/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.equinox.http.Http;
import org.eclipse.equinox.http.HttpListener;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.HttpServerSocket;
import org.eclipse.equinox.http.HttpThreadPool;
import org.eclipse.equinox.socket.ServerSocketInterface;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public class HttpConfiguration
implements ManagedService,
ManagedServiceFactory {
    private HttpListener defaultHttpListener;
    private HttpListener defaultHttpsListener;
    Hashtable configuredListeners;
    protected Http http;
    protected HttpThreadPool pool;
    protected static final String enviroKeyHttpPort = "org.osgi.service.http.port";
    protected static final String enviroKeyHttpsPort = "org.osgi.service.http.port.secure";
    protected static final String enviroKeyHttpAddress = "org.eclipse.equinox.http.address";
    protected static final String HTTPSERVICEPID = "org.eclipse.equinox.http.Http";
    protected ServiceRegistration managedService;
    protected static final String HTTPSERVICEFACTORYPID = "org.eclipse.equinox.http.HttpFactory";
    protected ServiceRegistration managedServiceFactory;
    protected static final String keyHttpMinThreads = "http.minThreads";
    protected static final String keyHttpMaxThreads = "http.maxThreads";
    protected static final String keyHttpThreadPriority = "http.threadPriority";
    protected static final String keyHttpAddress = "http.address";
    protected static final String keyHttpPort = "http.port";
    protected static final String keyHttpScheme = "http.scheme";
    protected static final String keyHttpTimeout = "http.timeout";
    protected static final int DEFAULT_MINTHREADS = 4;
    protected static final int DEFAULT_MAXTHREADS = 20;
    protected static final int DEFAULT_THREADPRIOTRITY = 5;
    protected static String DEFAULT_HTTP_ADDRESS = "ALL";
    protected static int DEFAULT_HTTP_PORT = 80;
    protected static int DEFAULT_HTTPS_PORT = 443;
    protected static final int DEFAULT_TIMEOUT = 30;
    private int minThreads = 4;
    private int maxThreads = 20;
    private int threadPriority = 5;
    private boolean active;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected HttpConfiguration(Http http) throws IOException {
        this.http = http;
        this.active = true;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        this.setDefaultPorts();
        this.pool = new HttpThreadPool(this.http, this.minThreads, this.maxThreads, this.threadPriority);
        this.configuredListeners = new Hashtable(7);
        Hashtable hashtable = this.configuredListeners;
        synchronized (hashtable) {
            this.createDefaultListeners();
        }
        this.registerManagedService();
        this.registerManagedServiceFactory();
    }

    protected void registerManagedService() {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", HttpMsg.OSGi_Http_Service_IBM_Implementation_16);
        properties.put("service.pid", HTTPSERVICEPID);
        BundleContext bundleContext = this.http.context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.managedService = bundleContext.registerService(clazz.getName(), (Object)this, properties);
    }

    protected void registerManagedServiceFactory() {
        Hashtable<String, String> properties = new Hashtable<String, String>(7);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", HttpMsg.OSGi_Http_Service_IBM_Implementation_16);
        properties.put("service.pid", HTTPSERVICEFACTORYPID);
        BundleContext bundleContext = this.http.context;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.managedServiceFactory = bundleContext.registerService(clazz.getName(), (Object)this, properties);
    }

    protected void createDefaultListeners() {
        if (DEFAULT_HTTP_PORT != -1) {
            try {
                this.defaultHttpListener = new HttpListener(this.http, this, this.createProperties(DEFAULT_HTTP_ADDRESS, DEFAULT_HTTP_PORT, "http", 30));
            }
            catch (IOException e) {
                this.http.logError(HttpMsg.HTTP_UNEXPECTED_IOEXCEPTION, e);
                this.http.logError(HttpMsg.HTTP_UNEXPECTED_RUNTIMEEXCEPTION, e);
            }
        }
    }

    protected void closeDefaultListeners() {
        if (this.defaultHttpListener != null) {
            this.defaultHttpListener.close();
            this.defaultHttpListener = null;
        }
        if (this.defaultHttpsListener != null) {
            this.defaultHttpsListener.close();
            this.defaultHttpsListener = null;
        }
    }

    protected void setDefaultPorts() {
        BundleContext context = this.http.context;
        String property = context.getProperty(enviroKeyHttpPort);
        if (property != null) {
            try {
                DEFAULT_HTTP_PORT = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.http.logWarning(NLS.bind((String)HttpMsg.HTTP_DEFAULT_PORT_FORMAT_EXCEPTION, (Object)enviroKeyHttpPort), e);
            }
        }
        if ((property = context.getProperty(enviroKeyHttpsPort)) != null) {
            try {
                DEFAULT_HTTPS_PORT = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.http.logWarning(NLS.bind((String)HttpMsg.HTTP_DEFAULT_PORT_FORMAT_EXCEPTION, (Object)enviroKeyHttpsPort), e);
            }
        }
        if ((DEFAULT_HTTP_ADDRESS = context.getProperty(enviroKeyHttpAddress)) == null) {
            DEFAULT_HTTP_ADDRESS = "ALL";
        }
    }

    protected Dictionary createProperties(String address, int port, String scheme, int socketTimeout) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(31);
        properties.put("service.vendor", "IBM");
        properties.put("service.description", HttpMsg.OSGi_Http_Service_IBM_Implementation_16);
        properties.put("service.pid", "org.eclipse.equinox.http.HttpService-" + scheme);
        properties.put(keyHttpAddress, address);
        properties.put(keyHttpPort, new Integer(port));
        properties.put(keyHttpScheme, scheme);
        properties.put(keyHttpTimeout, new Integer(socketTimeout));
        return properties;
    }

    protected ServerSocketInterface createServerSocket(String address, int port, String scheme) throws IOException {
        InetAddress netAddress = null;
        if (address != null) {
            try {
                netAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException uhe) {
                this.http.logWarning(NLS.bind((String)HttpMsg.HTTP_HOST_UNKNOWN, (Object)address), uhe);
            }
        }
        if ("http".equalsIgnoreCase(scheme)) {
            try {
                HttpServerSocket ssi = new HttpServerSocket(port, 50, netAddress);
                ssi.setAddress(address);
                return ssi;
            }
            catch (IOException e) {
                this.http.logError(NLS.bind((String)HttpMsg.HTTP_PORT_IN_USE_EXCEPTION, (Object)new Integer(port)), e);
                throw e;
            }
        }
        if ("https".equalsIgnoreCase(scheme)) {
            try {
                ServerSocketInterface ssi = this.http.createSSLServerSocket(port, 50, netAddress);
                ssi.setAddress(address);
                return ssi;
            }
            catch (IOException e) {
                this.http.logError(NLS.bind((String)HttpMsg.HTTP_PORT_IN_USE_EXCEPTION, (Object)new Integer(port)), e);
                throw e;
            }
        }
        throw new IOException(NLS.bind((String)HttpMsg.HTTP_INVALID_SCHEME_EXCEPTION, (Object)scheme));
    }

    void close() {
        this.active = false;
        this.managedService.unregister();
        this.managedServiceFactory.unregister();
        if (this.defaultHttpListener != null) {
            this.defaultHttpListener.close();
            this.defaultHttpListener = null;
        }
        if (this.defaultHttpsListener != null) {
            this.defaultHttpsListener.close();
            this.defaultHttpsListener = null;
        }
        Enumeration listeners = this.configuredListeners.elements();
        while (listeners.hasMoreElements()) {
            HttpListener listener = (HttpListener)listeners.nextElement();
            listener.close();
        }
        this.pool.close();
    }

    public String getName() {
        return HttpMsg.IBM_Http_Service_37;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(final String pid, final Dictionary properties) throws ConfigurationException {
        if (this.active) {
            Object timeoutProperty;
            Object addressProperty;
            Object schemeProperty;
            String address = DEFAULT_HTTP_ADDRESS;
            int port = DEFAULT_HTTP_PORT;
            String scheme = "http";
            int timeout = 30;
            String key = keyHttpPort;
            Object portProperty = properties.get(key);
            if (portProperty != null) {
                if (!(portProperty instanceof Integer)) {
                    throw new ConfigurationException(key, "not an Integer");
                }
                port = (Integer)portProperty;
                if (port < 0 || port > 65535) {
                    throw new ConfigurationException(key, "must be in the range 0-65535");
                }
            }
            if ((schemeProperty = properties.get(key = keyHttpScheme)) != null) {
                if (!(schemeProperty instanceof String)) {
                    throw new ConfigurationException(key, "not an String");
                }
                scheme = (String)schemeProperty;
                if (!scheme.equals("http") && !scheme.equals("https")) {
                    throw new ConfigurationException(key, "must be either http or https");
                }
            }
            if ((addressProperty = properties.get(key = keyHttpAddress)) != null) {
                if (!(addressProperty instanceof String)) {
                    throw new ConfigurationException(key, "not an String");
                }
                address = (String)addressProperty;
            }
            if ((timeoutProperty = properties.get(key = keyHttpTimeout)) != null) {
                if (!(timeoutProperty instanceof Integer)) {
                    throw new ConfigurationException(key, "not an Integer");
                }
                timeout = (Integer)timeoutProperty;
                if (timeout < 0 || timeout > 600) {
                    throw new ConfigurationException(key, "must be in the range 0-600");
                }
            }
            if (schemeProperty == null) {
                if (port == DEFAULT_HTTPS_PORT) {
                    scheme = "https";
                }
            } else if (portProperty == null && scheme.equals("https")) {
                port = DEFAULT_HTTPS_PORT;
            }
            if (addressProperty == null) {
                properties.put(keyHttpAddress, address);
            }
            if (schemeProperty == null) {
                properties.put(keyHttpScheme, scheme);
            }
            if (portProperty == null) {
                properties.put(keyHttpPort, new Integer(port));
            }
            if (timeoutProperty == null) {
                properties.put(keyHttpTimeout, new Integer(timeout));
            }
            properties.remove("service.bundleLocation");
            properties.put("service.vendor", "IBM");
            properties.put("service.description", HttpMsg.OSGi_Http_Service_IBM_Implementation_16);
            Hashtable hashtable = this.configuredListeners;
            synchronized (hashtable) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws ConfigurationException {
                            if (HttpConfiguration.this.configuredListeners.size() == 0) {
                                HttpConfiguration.this.closeDefaultListeners();
                            }
                            HttpListener listener = (HttpListener)HttpConfiguration.this.configuredListeners.get(pid);
                            try {
                                if (listener != null) {
                                    listener.setProperties(properties);
                                } else {
                                    listener = new HttpListener(HttpConfiguration.this.http, HttpConfiguration.this, properties);
                                    HttpConfiguration.this.configuredListeners.put(pid, listener);
                                }
                            }
                            catch (IOException e) {
                                HttpConfiguration.this.http.logError(HttpMsg.HTTP_UNEXPECTED_IOEXCEPTION, e);
                                if (HttpConfiguration.this.configuredListeners.size() == 0) {
                                    HttpConfiguration.this.createDefaultListeners();
                                }
                                throw new ConfigurationException(null, e.getMessage());
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (ConfigurationException)pae.getException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(final String pid) {
        if (this.active) {
            Hashtable hashtable = this.configuredListeners;
            synchronized (hashtable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        HttpListener listener = (HttpListener)HttpConfiguration.this.configuredListeners.remove(pid);
                        if (listener != null) {
                            listener.close();
                        }
                        if (HttpConfiguration.this.configuredListeners.size() == 0) {
                            HttpConfiguration.this.createDefaultListeners();
                        }
                        return null;
                    }
                });
            }
        }
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (this.active) {
            if (properties == null) {
                return;
            }
            int min = this.minThreads;
            int max = this.maxThreads;
            int priority = this.threadPriority;
            String key = keyHttpMinThreads;
            Object property = properties.get(key);
            if (property != null) {
                if (!(property instanceof Integer)) {
                    throw new ConfigurationException(key, "not an Integer");
                }
                min = (Integer)property;
                if (min < 0 || min > 63) {
                    throw new ConfigurationException(key, "must be in the range 0-63");
                }
            }
            if ((property = properties.get(key = keyHttpMaxThreads)) != null) {
                if (!(property instanceof Integer)) {
                    throw new ConfigurationException(key, "not an Integer");
                }
                max = (Integer)property;
                if (max < 0 || max > 63) {
                    throw new ConfigurationException(key, "must be in the range 0-63");
                }
            }
            if ((property = properties.get(key = keyHttpThreadPriority)) != null) {
                if (!(property instanceof Integer)) {
                    throw new ConfigurationException(key, "not an Integer");
                }
                priority = (Integer)property;
                if (priority < 1 || priority > 10) {
                    throw new ConfigurationException(key, "must be one of the Thread defined priorities");
                }
            }
            if (max != this.maxThreads || min != this.minThreads) {
                this.pool.setSize(min, max);
                this.minThreads = this.pool.getLowerSizeLimit();
                this.maxThreads = this.pool.getUpperSizeLimit();
            }
            if (priority != this.threadPriority) {
                this.pool.setPriority(priority);
                this.threadPriority = priority;
            }
        }
    }
}

