/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.xml.XmlConfiguration;

public class EmbeddedJettyServer {
    public static final Logger LOG = Logger.getLogger(EmbeddedJettyServer.class);
    private Server jettyServer;
    private boolean isRunning;
    private File jettyXml;
    private int webPort;

    public EmbeddedJettyServer(File jettyXml, int webPort) {
        this.jettyXml = jettyXml;
        this.webPort = webPort;
    }

    public void start() {
        if (this.isRunning) {
            LOG.info((Object)"EmbeddedJettyServer.start() called, but server already running.");
            return;
        }
        this.jettyServer = new Server();
        try {
            XmlConfiguration configuration = new XmlConfiguration((InputStream)new FileInputStream(this.jettyXml));
            configuration.configure((Object)this.jettyServer);
            if (this.webPort != -1 && this.webPort != 8080) {
                SelectChannelConnector connector = new SelectChannelConnector();
                connector.setPort(this.webPort);
                connector.setMaxIdleTime(30000);
                this.jettyServer.setConnectors(new Connector[]{connector});
            }
            this.jettyServer.start();
        }
        catch (Exception e) {
            String msg = "Unable to start embedded Jetty server: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        this.isRunning = true;
    }

    public void stop() {
        if (this.isRunning && this.jettyServer != null) {
            try {
                this.jettyServer.stop();
            }
            catch (Exception e) {
                String msg = "Exception occurred while stopping Embedded Jetty server";
                LOG.error((Object)msg);
                throw new RuntimeException(e);
            }
        }
    }
}

