/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.cruisecontrol.CruiseControlException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class XPathAwareChild {
    private static final Logger LOG = Logger.getLogger(XPathAwareChild.class);
    private String value;
    private String xpathExpression;
    private InputStream in;
    private String xmlFile;
    private boolean wasValidated;

    public void setValue(String value) {
        this.markDirty();
        this.value = value;
    }

    public void setXPathExpression(String xpathExpression) {
        this.markDirty();
        this.xpathExpression = xpathExpression;
    }

    public void setInputStream(InputStream in) {
        this.markDirty();
        this.in = in;
    }

    public void setXMLFile(String filename) {
        this.markDirty();
        this.xmlFile = filename;
    }

    public String getFixedValue() {
        return this.value;
    }

    public String getXpathExpression() {
        return this.xpathExpression;
    }

    public String lookupValue(Element log) throws CruiseControlException {
        if (!this.wasValidated) {
            throw new IllegalStateException("This child was not validated. Should not be calling lookupValue() unless it has first been validated.");
        }
        if (this.value != null) {
            return this.value;
        }
        try {
            return this.evaluateXpath(log);
        }
        catch (Exception e) {
            throw new CruiseControlException(e);
        }
    }

    private String evaluateXpath(Element log) throws IOException, JDOMException, CruiseControlException {
        Object searchContext;
        if (this.in == null && this.xmlFile == null && log == null) {
            throw new CruiseControlException("current cruisecontrol log not set.");
        }
        if (this.xmlFile != null) {
            LOG.debug((Object)("Using file specified [" + this.xmlFile + "] to evaluate xpath."));
            searchContext = new SAXBuilder().build((InputStream)new FileInputStream(new File(this.xmlFile)));
        } else if (this.in != null) {
            LOG.debug((Object)"Using the specified input stream to evaluate xpath. This should happen during testing.");
            searchContext = new SAXBuilder().build(this.in);
        } else {
            LOG.debug((Object)"Using CruiseControl's log file to evaluate xpath.");
            searchContext = log.getParent() != null ? log.getParent() : new Document(log);
        }
        XPath xpath = XPath.newInstance((String)this.xpathExpression);
        String result = xpath.valueOf(searchContext);
        LOG.debug((Object)("Evaluated xpath [" + this.xpathExpression + "] with result [" + result + "]"));
        return result;
    }

    public void validate() throws CruiseControlException {
        if (this.xpathExpression == null && this.xmlFile != null) {
            throw new CruiseControlException("xmlFile should only be set if xpathExpression is also set.");
        }
        if (this.value == null && this.xpathExpression == null) {
            throw new CruiseControlException("Either value or xpathExpression must be set.");
        }
        if (this.value != null && this.xpathExpression != null) {
            throw new CruiseControlException("value and xpathExpression should not both be set.");
        }
        this.markClean();
    }

    private void markClean() {
        this.wasValidated = true;
    }

    protected void markDirty() {
        this.wasValidated = false;
    }
}

