/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.File;
import net.sourceforge.cruisecontrol.CruiseControlException;

public final class ValidationHelper {
    private ValidationHelper() {
    }

    public static void assertIsSet(Object attribute, String attributeName, Class plugin) throws CruiseControlException {
        ValidationHelper.assertIsSet(attribute, attributeName, ValidationHelper.getShortClassName(plugin));
    }

    public static void assertIsSet(Object attribute, String attributeName, String pluginName) throws CruiseControlException {
        if (attribute == null) {
            ValidationHelper.fail("'" + attributeName + "' is required for " + pluginName);
        }
    }

    public static void assertIsDependentSet(String masterAttribute, String masterAttributeName, String childAttribute, String childAttributeName, Class plugin) throws CruiseControlException {
        if (masterAttribute != null && childAttribute == null) {
            ValidationHelper.fail("'" + childAttributeName + "' is required for " + ValidationHelper.getShortClassName(plugin) + " if '" + masterAttributeName + "' is set");
        }
    }

    public static void assertNotEmpty(String attribute, String attributeName, Class plugin) throws CruiseControlException {
        ValidationHelper.assertTrue(attribute == null || !"".equals(attribute), attributeName + " must be meaningful or not provided on " + ValidationHelper.getShortClassName(plugin));
    }

    public static void assertHasChild(Object child, Class childType, String usualChildNodeName, Class plugin) throws CruiseControlException {
        if (child == null) {
            ValidationHelper.fail("child <" + usualChildNodeName + "> (or type " + ValidationHelper.getShortClassName(childType) + ") is required for plugin " + ValidationHelper.getShortClassName(plugin));
        }
    }

    public static void assertHasChild(Object child, String usualChildNodeName, Class plugin) throws CruiseControlException {
        if (child == null) {
            ValidationHelper.fail("child <" + usualChildNodeName + "> is required for plugin " + ValidationHelper.getShortClassName(plugin));
        }
    }

    public static void assertTrue(boolean condition, String message) throws CruiseControlException {
        if (!condition) {
            ValidationHelper.fail(message);
        }
    }

    public static void fail(String message) throws CruiseControlException {
        throw new CruiseControlException(message);
    }

    public static void fail(String message, Exception e) throws CruiseControlException {
        throw new CruiseControlException(message, e);
    }

    public static void assertFalse(boolean condition, String message) throws CruiseControlException {
        if (condition) {
            ValidationHelper.fail(message);
        }
    }

    private static String getShortClassName(Class plugin) {
        String fullClassName = plugin.getName();
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static void assertExists(File file, String attributeName, Class plugin) throws CruiseControlException {
        if (file == null || attributeName == null || plugin == null) {
            throw new IllegalArgumentException("All parameters are required.");
        }
        if (!file.exists()) {
            ValidationHelper.fail("File specified [" + file.getAbsolutePath() + "] for attribute [" + attributeName + "] on plugin [" + plugin.getName() + "] doesn't exist.");
        }
    }

    public static void assertIsNotDirectory(File file, String attributeName, Class plugin) throws CruiseControlException {
        if (file == null || attributeName == null || plugin == null) {
            throw new IllegalArgumentException("All parameters are required.");
        }
        if (file.isDirectory()) {
            ValidationHelper.fail("File specified [" + file.getAbsolutePath() + "] for attribute [" + attributeName + "] on plugin [" + plugin.getName() + "] is really a directory where a file was expected.");
        }
    }

    public static void assertIsReadable(File file, String attributeName, Class plugin) throws CruiseControlException {
        if (file == null || attributeName == null || plugin == null) {
            throw new IllegalArgumentException("All parameters are required.");
        }
        if (!file.canRead()) {
            ValidationHelper.fail("File specified [" + file.getAbsolutePath() + "] for attribute [" + attributeName + "] on plugin [" + plugin.getName() + "] is not readable.");
        }
    }

    public static void assertIntegerInRange(String candidate, int start, int end, String message) throws CruiseControlException {
        try {
            int asInt = Integer.parseInt(candidate);
            if (asInt < start || asInt > end) {
                ValidationHelper.fail(message);
            }
        }
        catch (NumberFormatException e) {
            ValidationHelper.fail(message);
        }
    }
}

