/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.IO;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static Element loadRootElement(File configFile) throws CruiseControlException {
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            return builder.build(configFile).getRootElement();
        }
        catch (Exception e) {
            throw new CruiseControlException("failed to load file [" + (configFile != null ? configFile.getName() : "") + "]", e);
        }
    }

    public static Element loadRootElement(InputStream in) throws CruiseControlException {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build(in).getRootElement();
        }
        catch (Exception e) {
            throw new CruiseControlException("failed to parse configuration", e);
        }
    }

    public static boolean isWindows() {
        String osName = Util.getOsName();
        return osName.indexOf("Windows") > -1;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromFile(File file) throws CruiseControlException, IOException {
        Properties properties = new Properties();
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            try {
                properties.load(bis);
            }
            finally {
                IO.close(bis);
            }
        }
        catch (FileNotFoundException e) {
            throw new CruiseControlException("Could not load properties from file " + file.getAbsolutePath() + ". It does not exist.", e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePropertiesToFile(Properties properties, String header, File file) throws CruiseControlException, IOException {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            try {
                properties.store(bos, header);
            }
            finally {
                IO.close(bos);
            }
        }
        catch (FileNotFoundException e) {
            throw new CruiseControlException("Could not store properties to file " + file.getAbsolutePath() + ". It does not exist.", e);
        }
    }

    public static String readFileToString(String fileName) throws IOException {
        StringBuffer out = new StringBuffer();
        Util.appendFileToBuffer(fileName, out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer result = new StringBuffer();
        try {
            String s = reader.readLine();
            while (s != null) {
                result.append(s.trim());
                s = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFileToBuffer(String fileName, StringBuffer out) throws IOException {
        FileReader fr = new FileReader(fileName);
        try {
            char[] buff = new char[4096];
            int size = fr.read(buff, 0, 4096);
            while (size > 0) {
                out.append(buff, 0, size);
                size = fr.read(buff, 0, 4096);
            }
        }
        finally {
            IO.close(fr);
        }
    }

    public static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static String parsePropertiesInString(Map<String, String> props, String string, boolean failIfMissing) throws CruiseControlException {
        int startIndex;
        if (string != null && (startIndex = string.indexOf("${")) != -1) {
            String value;
            int endIndex;
            int openedBrackets = 1;
            int lastStartIndex = startIndex + 2;
            while (true) {
                endIndex = string.indexOf("}", lastStartIndex);
                int otherStartIndex = string.indexOf("${", lastStartIndex);
                if (otherStartIndex != -1 && otherStartIndex < endIndex) {
                    ++openedBrackets;
                    lastStartIndex = otherStartIndex + 2;
                    continue;
                }
                if (--openedBrackets == 0) break;
                lastStartIndex = endIndex + 1;
            }
            if (endIndex < startIndex + 2) {
                throw new CruiseControlException("Unclosed brackets in " + string);
            }
            String property = string.substring(startIndex + 2, endIndex);
            String propertyName = Util.parsePropertiesInString(props, property, failIfMissing);
            String string2 = value = "".equals(propertyName) ? "" : props.get(propertyName);
            if (value == null) {
                if (failIfMissing) {
                    throw new CruiseControlException("Property \"" + propertyName + "\" is not defined. Please check the order in which you have used your properties.");
                }
                value = "${" + propertyName + "}";
            }
            string = string.substring(0, startIndex) + value + Util.parsePropertiesInString(props, string.substring(endIndex + 1), failIfMissing);
        }
        return string;
    }
}

