/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import org.apache.log4j.Logger;

public class StreamPumper
implements Runnable {
    private final BufferedReader in;
    private StreamConsumer consumer = null;
    private static final int SIZE = 1024;
    private static final Logger LOG = Logger.getLogger(StreamPumper.class);

    public StreamPumper(InputStream in, StreamConsumer consumer) {
        this.in = new BufferedReader(new InputStreamReader(in), 1024);
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String s = this.in.readLine();
            while (s != null) {
                s = s.replaceAll("\\e(\\[[^a-zA-Z]*[a-zA-Z]|[^\\[])", "");
                s = s.replaceAll("[\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f]", "");
                this.consumeLine(s);
                s = this.in.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IO.close(this.in);
        }
    }

    private void consumeLine(String line) {
        if (this.consumer != null) {
            try {
                this.consumer.consumeLine(line);
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Problem consuming line [" + line + "]"), (Throwable)e);
            }
        }
    }
}

